/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.configuration;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.tools.configuration.ConfigurationExportData;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.utils.CommonUtils;

public class ConfigurationExportWizardPage
extends WizardPage {
    private TextWithOpenFile file;

    protected ConfigurationExportWizardPage() {
        super(CoreMessages.dialog_workspace_export_wizard_page_name);
        this.setTitle(CoreMessages.dialog_workspace_export_wizard_page_title);
        this.setMessage(CoreMessages.dialog_workspace_export_wizard_start_message_configure_settings);
    }

    public void createControl(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group exportSettingsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_workspace_export_wizard_group, (int)2, (int)1808, (int)0);
        UIUtils.createControlLabel((Composite)exportSettingsGroup, (String)CoreMessages.dialog_workspace_export_wizard_file_name);
        this.file = new TextWithOpenFile((Composite)exportSettingsGroup, CoreMessages.dialog_workspace_export_wizard_file_path_dialog, new String[]{"*.zip"}, 8196, false);
        this.file.setLayoutData((Object)new GridData(768));
        this.file.getTextControl().addModifyListener(e -> this.updateState());
        this.updateState();
        this.setControl((Control)composite);
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        try {
            if (!CommonUtils.isEmpty((String)this.file.getText())) {
                Path.of(this.file.getText(), new String[0]);
                return true;
            }
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
        return false;
    }

    public ConfigurationExportData getExportData() {
        return new ConfigurationExportData(this.file.getText());
    }
}

