/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotNull;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ColumnBasedLDAPResultWriter
extends LDAPResultWriter {
    @NotNull
    private final ArrayList<String> formattedLines;
    private final boolean includeAllValues;
    @NotNull
    private final ColumnFormatter formatter;
    private final int maxCommentWidth;
    @NotNull
    private final Object[] columnValues;
    @NotNull
    private final String[] attributes;
    @NotNull
    private final StringBuilder formattedLineBuffer;

    public ColumnBasedLDAPResultWriter(@NotNull OutputStream outputStream, @NotNull OutputFormat outputFormat, @NotNull List<String> requestedAttributes, int maxCommentWidth, boolean includeAllValues) {
        super(outputStream);
        this.maxCommentWidth = maxCommentWidth;
        this.includeAllValues = includeAllValues;
        this.attributes = new String[requestedAttributes.size()];
        requestedAttributes.toArray(this.attributes);
        this.columnValues = new Object[this.attributes.length + 1];
        FormattableColumn[] columns = new FormattableColumn[this.attributes.length + 1];
        columns[0] = new FormattableColumn(10, HorizontalAlignment.LEFT, "DN");
        for (int i = 0; i < this.attributes.length; ++i) {
            columns[i + 1] = new FormattableColumn(10, HorizontalAlignment.LEFT, this.attributes[i]);
        }
        this.formatter = new ColumnFormatter(false, null, outputFormat, " ", columns);
        this.formattedLines = new ArrayList(20);
        this.formattedLineBuffer = new StringBuilder(100);
    }

    @Override
    public void writeComment(@NotNull String comment) {
    }

    @Override
    public void writeHeader() {
        for (String headerLine : this.formatter.getHeaderLines(false)) {
            this.print("# ");
            this.println(headerLine);
        }
    }

    @Override
    public void writeSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.columnValues[0] = entry.getDN();
        int i = 1;
        StringBuilder buffer = new StringBuilder();
        for (String attributeName : this.attributes) {
            Attribute a = entry.getAttribute(attributeName);
            if (a == null || a.size() == 0) {
                this.columnValues[i] = "";
            } else if (this.includeAllValues && a.size() > 1) {
                buffer.setLength(0);
                for (String v : a.getValues()) {
                    if (buffer.length() > 0) {
                        buffer.append('|');
                    }
                    buffer.append(v);
                }
                this.columnValues[i] = buffer.toString();
            } else {
                this.columnValues[i] = a.getValue();
            }
            ++i;
        }
        this.println(this.formatter.formatRow(this.columnValues));
    }

    @Override
    public void writeSearchResultReference(@NotNull SearchResultReference ref) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatSearchResultReference(this.formattedLines, ref, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }

    @Override
    public void writeResult(@NotNull LDAPResult result) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatResult(this.formattedLines, result, true, false, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }

    @Override
    public void writeUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        this.formattedLines.clear();
        this.formattedLineBuffer.setLength(0);
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, true, 0, this.maxCommentWidth);
        for (String s : this.formattedLines) {
            this.formattedLineBuffer.append(s);
            this.formattedLineBuffer.append(StaticUtils.EOL);
        }
        this.println(this.formattedLineBuffer.toString());
    }
}

