/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.json;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.configurator.impl.json.BinUtil;
import org.apache.felix.configurator.impl.json.JSONUtil;

public class BinaryManager
implements ConfigurationReader.BinaryHandler {
    private final List<File> allFiles = new ArrayList<File>();
    private final Map<String, List<File>> files = new HashMap<String, List<File>>();
    private final BinUtil.ResourceProvider provider;
    private final JSONUtil.Report report;

    public BinaryManager(BinUtil.ResourceProvider provider, JSONUtil.Report report) {
        this.provider = provider;
        this.report = report;
    }

    public String handleBinaryValue(String pid, String key, String value) {
        if (this.provider == null) {
            String msg = this.provider.getIdentifier().concat(" : PID ").concat(pid).concat(" : Invalid value/type for configuration : ").concat(key).concat(" : ").concat("Binary files only allowed within a bundle");
            this.report.errors.add(msg);
        } else {
            String path = value;
            try {
                File filePath = BinUtil.extractFile(this.provider, pid, path);
                if (filePath != null) {
                    this.files.computeIfAbsent(pid, mapKey -> new ArrayList()).add(filePath);
                    this.allFiles.add(filePath);
                    return filePath.getAbsolutePath();
                }
                String msg = this.provider.getIdentifier().concat(" : PID ").concat(pid).concat(" : Invalid value/type for configuration : ").concat(key).concat(" : ").concat("Entry ").concat(path).concat(" not found in bundle");
                this.report.errors.add(msg);
            }
            catch (IOException ioe) {
                String msg = this.provider.getIdentifier().concat(" : PID ").concat(pid).concat(" : Invalid value/type for configuration : ").concat(key).concat(" : ").concat("Unable to read ").concat(path).concat(" and write to ").concat(BinUtil.binDirectory.getAbsolutePath()).concat(" : ").concat(ioe.getMessage());
                this.report.errors.add(msg);
            }
        }
        return null;
    }

    public void cleanupFiles() {
        this.allFiles.stream().filter(f -> f.exists()).forEach(f -> f.delete());
        this.files.clear();
    }

    public List<File> flushFiles(String pid) {
        return this.files.remove(pid);
    }
}

