/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.preferences;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.internal.preferences.WorkingCopyPreferences;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private static final String EMPTY_STRING = "";
    private final Map<String, IEclipsePreferences> workingCopies = new HashMap<String, IEclipsePreferences>();

    @Override
    public IEclipsePreferences getWorkingCopy(IEclipsePreferences original) {
        if (original instanceof WorkingCopyPreferences) {
            throw new IllegalArgumentException("Trying to get a working copy of a working copy");
        }
        String absolutePath = original.absolutePath();
        IEclipsePreferences preferences = this.workingCopies.get(absolutePath);
        if (preferences == null) {
            preferences = new WorkingCopyPreferences(original, this);
            this.workingCopies.put(absolutePath, preferences);
        }
        return preferences;
    }

    @Override
    public void applyChanges() throws BackingStoreException {
        WorkingCopyPreferences[] valuesArray;
        Collection<IEclipsePreferences> values = this.workingCopies.values();
        WorkingCopyPreferences[] workingCopyPreferencesArray = valuesArray = values.toArray(new WorkingCopyPreferences[values.size()]);
        int n = valuesArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkingCopyPreferences prefs = workingCopyPreferencesArray[n2];
            if (prefs.nodeExists(EMPTY_STRING)) {
                prefs.flush();
            }
            ++n2;
        }
    }
}

