/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.List;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWListPeer
extends LWComponentPeer<List, ScrollableJList>
implements ListPeer {
    private static final int DEFAULT_VISIBLE_ROWS = 4;
    private static final String TEXT = "0123456789abcde";

    LWListPeer(List list, PlatformComponent platformComponent) {
        super(list, platformComponent);
        if (!((List)this.getTarget()).isBackgroundSet()) {
            ((List)this.getTarget()).setBackground(SystemColor.text);
        }
    }

    @Override
    ScrollableJList createDelegate() {
        return new ScrollableJList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        this.setMultipleMode(((List)this.getTarget()).isMultipleMode());
        int[] nArray = ((List)this.getTarget()).getSelectedIndexes();
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndices(nArray);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    Component getDelegateFocusOwner() {
        return ((ScrollableJList)this.getDelegate()).getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedIndexes() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            return ((ScrollableJList)this.getDelegate()).getView().getSelectedIndices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String string, int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().add(n, string);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delItems(int n, int n2) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeRange(n, n2);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getModel().removeAllElements();
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void select(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(true);
            ((ScrollableJList)this.getDelegate()).getView().setSelectedIndex(n);
            ((ScrollableJList)this.getDelegate()).setSkipStateChangedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deselect(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().getSelectionModel().removeSelectionInterval(n, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeVisible(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().ensureIndexIsVisible(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMultipleMode(boolean bl) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().setSelectionMode(bl ? 2 : 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(4);
    }

    @Override
    public Dimension getPreferredSize(int n) {
        return this.getMinimumSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getMinimumSize(int n) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Dimension dimension = this.getCellSize();
            dimension.height *= n;
            JScrollBar jScrollBar = ((ScrollableJList)this.getDelegate()).getVerticalScrollBar();
            dimension.width = dimension.width + (jScrollBar != null ? jScrollBar.getMinimumSize().width : 0);
            Insets insets = ((ScrollableJList)this.getDelegate()).getInsets();
            Insets insets2 = ((ScrollableJList)this.getDelegate()).getView().getInsets();
            dimension.width += insets.left + insets.right + insets2.left + insets2.right;
            dimension.height += insets.top + insets.bottom + insets2.top + insets2.bottom;
            return dimension;
        }
    }

    private Dimension getCellSize() {
        JList<String> jList = ((ScrollableJList)this.getDelegate()).getView();
        ListCellRenderer<String> listCellRenderer = jList.getCellRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(jList, TEXT, 0, false, false);
        return component.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidate() {
        Object object = this.getDelegateLock();
        synchronized (object) {
            ((ScrollableJList)this.getDelegate()).getView().invalidate();
            ((ScrollableJList)this.getDelegate()).validate();
        }
    }

    final class ScrollableJList
    extends JScrollPane
    implements ListSelectionListener {
        private boolean skipStateChangedEvent;
        private final DefaultListModel<String> model = new DefaultListModel<String>(){

            @Override
            public void add(int n, String string) {
                if (n == -1) {
                    this.addElement(string);
                } else {
                    super.add(n, string);
                }
            }
        };
        private int[] oldSelectedIndices = new int[0];

        ScrollableJList() {
            this.getViewport().setScrollMode(0);
            JListDelegate jListDelegate = new JListDelegate();
            jListDelegate.addListSelectionListener(this);
            this.getViewport().setView(jListDelegate);
            String[] stringArray = ((List)LWListPeer.this.getTarget()).getItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.add(i, stringArray[i]);
            }
        }

        public boolean isSkipStateChangedEvent() {
            return this.skipStateChangedEvent;
        }

        public void setSkipStateChangedEvent(boolean bl) {
            this.skipStateChangedEvent = bl;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && !this.isSkipStateChangedEvent()) {
                JList jList = (JList)listSelectionEvent.getSource();
                for (int i = 0; i < jList.getModel().getSize(); ++i) {
                    boolean bl;
                    boolean bl2 = Arrays.binarySearch(this.oldSelectedIndices, i) >= 0;
                    if (bl2 == (bl = jList.isSelectedIndex(i))) continue;
                    int n = !bl2 && bl ? 1 : 2;
                    LWListPeer.this.postEvent(new ItemEvent((ItemSelectable)LWListPeer.this.getTarget(), 701, i, n));
                }
                this.oldSelectedIndices = jList.getSelectedIndices();
            }
        }

        public JList<String> getView() {
            return (JList)this.getViewport().getView();
        }

        public DefaultListModel<String> getModel() {
            return this.model;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.getView().setEnabled(bl);
            super.setEnabled(bl);
        }

        @Override
        public void setOpaque(boolean bl) {
            super.setOpaque(bl);
            if (this.getView() != null) {
                this.getView().setOpaque(bl);
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.getView() != null) {
                this.getView().setFont(font);
                LWListPeer.this.revalidate();
            }
        }

        private final class JListDelegate
        extends JList<String> {
            JListDelegate() {
                super(ScrollableJList.this.model);
            }

            @Override
            public boolean hasFocus() {
                return ((List)LWListPeer.this.getTarget()).hasFocus();
            }

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                int n;
                super.processMouseEvent(mouseEvent);
                if (mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2 && 0 <= (n = this.locationToIndex(mouseEvent.getPoint())) && n < this.getModel().getSize()) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, (String)this.getModel().getElementAt(n), mouseEvent.getWhen(), mouseEvent.getModifiers()));
                }
            }

            @Override
            protected void processKeyEvent(KeyEvent keyEvent) {
                String string;
                super.processKeyEvent(keyEvent);
                if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10 && (string = (String)this.getSelectedValue()) != null) {
                    LWListPeer.this.postEvent(new ActionEvent(LWListPeer.this.getTarget(), 1001, string, keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }

            @Override
            public Point getLocationOnScreen() {
                return LWListPeer.this.getLocationOnScreen();
            }
        }
    }
}

