/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;

public abstract class TypeComponentImpl
extends MirrorImpl
implements TypeComponent {
    protected final long ref;
    protected final String name;
    protected final String signature;
    protected final String genericSignature;
    protected final ReferenceTypeImpl declaringType;
    private final int modifiers;

    TypeComponentImpl(VirtualMachine vm, ReferenceTypeImpl declaringType, long ref, String name, String signature, String genericSignature, int modifiers) {
        super(vm);
        this.declaringType = declaringType;
        this.ref = ref;
        this.name = name;
        this.signature = signature;
        this.genericSignature = genericSignature != null && genericSignature.length() != 0 ? genericSignature : null;
        this.modifiers = modifiers;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public String genericSignature() {
        return this.genericSignature;
    }

    @Override
    public int modifiers() {
        return this.modifiers;
    }

    @Override
    public ReferenceType declaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isStatic() {
        return this.isModifierSet(8);
    }

    @Override
    public boolean isFinal() {
        return this.isModifierSet(16);
    }

    @Override
    public boolean isPrivate() {
        return this.isModifierSet(2);
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isModifierSet(7);
    }

    @Override
    public boolean isProtected() {
        return this.isModifierSet(4);
    }

    @Override
    public boolean isPublic() {
        return this.isModifierSet(1);
    }

    @Override
    public boolean isSynthetic() {
        return this.isModifierSet(-268435456);
    }

    long ref() {
        return this.ref;
    }

    boolean isModifierSet(int compareBits) {
        return (this.modifiers & compareBits) != 0;
    }
}

