/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentProviderElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBasicJavaFileHighlighter
extends SyntaxHighlighterBase {
    private final Map<IElementType, TextAttributesKey> ourMap1;
    private final Map<IElementType, TextAttributesKey> ourMap2;
    protected final LanguageLevel myLanguageLevel;

    public AbstractBasicJavaFileHighlighter(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            AbstractBasicJavaFileHighlighter.$$$reportNull$$$0(0);
        }
        this.myLanguageLevel = languageLevel;
        this.ourMap1 = new HashMap<IElementType, TextAttributesKey>();
        this.ourMap2 = new HashMap<IElementType, TextAttributesKey>();
        AbstractBasicJavaFileHighlighter.fillMap(this.ourMap1, (TokenSet)BasicElementTypes.BASIC_KEYWORD_BIT_SET, (TextAttributesKey)JavaHighlightingColors.KEYWORD);
        AbstractBasicJavaFileHighlighter.fillMap(this.ourMap1, (TokenSet)BasicElementTypes.BASIC_LITERAL_BIT_SET, (TextAttributesKey)JavaHighlightingColors.KEYWORD);
        AbstractBasicJavaFileHighlighter.fillMap(this.ourMap1, (TokenSet)BasicElementTypes.BASIC_OPERATION_BIT_SET, (TextAttributesKey)JavaHighlightingColors.OPERATION_SIGN);
        for (IElementType type : JavaDocTokenType.ALL_JAVADOC_TOKENS.getTypes()) {
            this.ourMap1.put(type, JavaHighlightingColors.DOC_COMMENT);
        }
        this.ourMap1.put(JavaTokenType.INTEGER_LITERAL, JavaHighlightingColors.NUMBER);
        this.ourMap1.put(JavaTokenType.LONG_LITERAL, JavaHighlightingColors.NUMBER);
        this.ourMap1.put(JavaTokenType.FLOAT_LITERAL, JavaHighlightingColors.NUMBER);
        this.ourMap1.put(JavaTokenType.DOUBLE_LITERAL, JavaHighlightingColors.NUMBER);
        this.ourMap1.put(JavaTokenType.STRING_LITERAL, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.TEXT_BLOCK_LITERAL, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.STRING_TEMPLATE_BEGIN, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.STRING_TEMPLATE_MID, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.STRING_TEMPLATE_END, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.TEXT_BLOCK_TEMPLATE_MID, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.TEXT_BLOCK_TEMPLATE_END, JavaHighlightingColors.STRING);
        this.ourMap1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, JavaHighlightingColors.VALID_STRING_ESCAPE);
        this.ourMap1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, JavaHighlightingColors.INVALID_STRING_ESCAPE);
        this.ourMap1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, JavaHighlightingColors.INVALID_STRING_ESCAPE);
        this.ourMap1.put(JavaTokenType.CHARACTER_LITERAL, JavaHighlightingColors.STRING);
        this.ourMap1.put(JavaTokenType.LPARENTH, JavaHighlightingColors.PARENTHESES);
        this.ourMap1.put(JavaTokenType.RPARENTH, JavaHighlightingColors.PARENTHESES);
        this.ourMap1.put(JavaTokenType.LBRACE, JavaHighlightingColors.BRACES);
        this.ourMap1.put(JavaTokenType.RBRACE, JavaHighlightingColors.BRACES);
        this.ourMap1.put(JavaTokenType.LBRACKET, JavaHighlightingColors.BRACKETS);
        this.ourMap1.put(JavaTokenType.RBRACKET, JavaHighlightingColors.BRACKETS);
        this.ourMap1.put(JavaTokenType.COMMA, JavaHighlightingColors.COMMA);
        this.ourMap1.put(JavaTokenType.DOT, JavaHighlightingColors.DOT);
        this.ourMap1.put(JavaTokenType.SEMICOLON, JavaHighlightingColors.JAVA_SEMICOLON);
        this.ourMap1.put(JavaTokenType.C_STYLE_COMMENT, JavaHighlightingColors.JAVA_BLOCK_COMMENT);
        this.ourMap1.put(BasicElementTypes.BASIC_DOC_COMMENT, JavaHighlightingColors.DOC_COMMENT);
        this.ourMap1.put(JavaTokenType.END_OF_LINE_COMMENT, JavaHighlightingColors.LINE_COMMENT);
        this.ourMap1.put(TokenType.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        this.ourMap1.put(JavaDocTokenType.DOC_TAG_NAME, JavaHighlightingColors.DOC_COMMENT);
        this.ourMap2.put(JavaDocTokenType.DOC_TAG_NAME, JavaHighlightingColors.DOC_COMMENT_TAG);
        this.initAdditional(this.ourMap1, this.ourMap2);
    }

    protected abstract void initAdditional(@NotNull Map<IElementType, TextAttributesKey> var1, @NotNull Map<IElementType, TextAttributesKey> var2);

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        while (tokenType instanceof ParentProviderElementType) {
            ParentProviderElementType parentProviderElementType = (ParentProviderElementType)tokenType;
            if (parentProviderElementType.getParents().size() != 1) continue;
            tokenType = (IElementType)parentProviderElementType.getParents().iterator().next();
        }
        TextAttributesKey[] textAttributesKeyArray = AbstractBasicJavaFileHighlighter.pack((TextAttributesKey)this.ourMap1.get(tokenType), (TextAttributesKey)this.ourMap2.get(tokenType));
        if (textAttributesKeyArray == null) {
            AbstractBasicJavaFileHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/highlighter/AbstractBasicJavaFileHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/highlighter/AbstractBasicJavaFileHighlighter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

