/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.JvmClassFileInstrumenter;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationException;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.instrumentation.PatternInstrumenter;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangConfiguration;
import org.jetbrains.jps.intellilang.model.JpsIntelliLangExtensionService;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public final class PatternValidatorBuilder
extends BaseInstrumentingBuilder
implements JvmClassFileInstrumenter {
    @NotNull
    public String getId() {
        return "intelli-lang-pattern-assertions";
    }

    public boolean isEnabled(@NotNull ProjectDescriptor projectDescriptor, @NotNull JpsModule module) {
        if (projectDescriptor == null) {
            PatternValidatorBuilder.$$$reportNull$$$0(0);
        }
        if (module == null) {
            PatternValidatorBuilder.$$$reportNull$$$0(1);
        }
        JpsGlobal jpsGlobal = projectDescriptor.getModel().getGlobal();
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(jpsGlobal);
        return config.getInstrumentationType() != InstrumentationType.NONE;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public String getPresentableName() {
        String string = JpsBuildBundle.message((String)"intellilang.pattern.validator.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            PatternValidatorBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        JpsGlobal project = context.getProjectDescriptor().getModel().getGlobal();
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(project);
        return config.getInstrumentationType() != InstrumentationType.NONE;
    }

    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return !"module-info".equals(compiledClass.getClassName());
    }

    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiled, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        JpsGlobal project = context.getProjectDescriptor().getModel().getGlobal();
        JpsIntelliLangConfiguration config = JpsIntelliLangExtensionService.getInstance().getConfiguration(project);
        try {
            boolean instrumented = PatternValidatorBuilder.processClassFile(reader, writer, finder, config.getPatternAnnotationClass(), config.getInstrumentationType());
            if (instrumented) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (InstrumentationException e) {
            context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage()));
        }
        return null;
    }

    protected String getProgressMessage() {
        return JpsBuildBundle.message((String)"intellilang.pattern.validator.progress.message", (Object[])new Object[0]);
    }

    public static boolean processClassFile(ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder, String annotationClassName, InstrumentationType type) {
        PatternInstrumenter instrumenter = new PatternInstrumenter(annotationClassName, (ClassVisitor)writer, type, finder);
        reader.accept((ClassVisitor)instrumenter, 0);
        return instrumenter.instrumented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/intellilang/instrumentation/PatternValidatorBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/intellilang/instrumentation/PatternValidatorBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

