/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.defaultscope;

import java.io.File;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.module.script.ScriptExtensionProvider;
import org.openhab.core.automation.module.script.action.BusEvent;
import org.openhab.core.automation.module.script.internal.defaultscope.ItemRegistryDelegate;
import org.openhab.core.automation.module.script.internal.defaultscope.ScriptThingActionsImpl;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.IncreaseDecreaseType;
import org.openhab.core.library.types.NextPreviousType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.PlayPauseType;
import org.openhab.core.library.types.PointType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.types.RawType;
import org.openhab.core.library.types.RewindFastforwardType;
import org.openhab.core.library.types.StopMoveType;
import org.openhab.core.library.types.StringListType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.library.unit.BinaryPrefix;
import org.openhab.core.library.unit.ImperialUnits;
import org.openhab.core.library.unit.MetricPrefix;
import org.openhab.core.library.unit.SIUnits;
import org.openhab.core.library.unit.Units;
import org.openhab.core.thing.ThingRegistry;
import org.openhab.core.thing.binding.ThingActions;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
@NonNullByDefault
public class DefaultScriptScopeProvider
implements ScriptExtensionProvider {
    private static final String PRESET_DEFAULT = "default";
    private final Map<String, Object> elements = new ConcurrentHashMap<String, Object>();
    private final ScriptThingActionsImpl thingActions;

    @Activate
    public DefaultScriptScopeProvider(@Reference ItemRegistry itemRegistry, @Reference ThingRegistry thingRegistry, @Reference RuleRegistry ruleRegistry, @Reference BusEvent busEvent) {
        this.thingActions = new ScriptThingActionsImpl(thingRegistry);
        this.elements.put("State", State.class);
        this.elements.put("Command", Command.class);
        this.elements.put("URLEncoder", URLEncoder.class);
        this.elements.put("File", File.class);
        this.elements.put("Files", Files.class);
        this.elements.put("Path", Path.class);
        this.elements.put("Paths", Paths.class);
        this.elements.put("IncreaseDecreaseType", IncreaseDecreaseType.class);
        this.elements.put("DECREASE", IncreaseDecreaseType.DECREASE);
        this.elements.put("INCREASE", IncreaseDecreaseType.INCREASE);
        this.elements.put("OnOffType", OnOffType.class);
        this.elements.put("ON", OnOffType.ON);
        this.elements.put("OFF", OnOffType.OFF);
        this.elements.put("OpenClosedType", OpenClosedType.class);
        this.elements.put("CLOSED", OpenClosedType.CLOSED);
        this.elements.put("OPEN", OpenClosedType.OPEN);
        this.elements.put("StopMoveType", StopMoveType.class);
        this.elements.put("MOVE", StopMoveType.MOVE);
        this.elements.put("STOP", StopMoveType.STOP);
        this.elements.put("UpDownType", UpDownType.class);
        this.elements.put("DOWN", UpDownType.DOWN);
        this.elements.put("UP", UpDownType.UP);
        this.elements.put("UnDefType", UnDefType.class);
        this.elements.put("NULL", UnDefType.NULL);
        this.elements.put("UNDEF", UnDefType.UNDEF);
        this.elements.put("RefreshType", RefreshType.class);
        this.elements.put("REFRESH", RefreshType.REFRESH);
        this.elements.put("NextPreviousType", NextPreviousType.class);
        this.elements.put("NEXT", NextPreviousType.NEXT);
        this.elements.put("PREVIOUS", NextPreviousType.PREVIOUS);
        this.elements.put("PlayPauseType", PlayPauseType.class);
        this.elements.put("PLAY", PlayPauseType.PLAY);
        this.elements.put("PAUSE", PlayPauseType.PAUSE);
        this.elements.put("RewindFastforwardType", RewindFastforwardType.class);
        this.elements.put("REWIND", RewindFastforwardType.REWIND);
        this.elements.put("FASTFORWARD", RewindFastforwardType.FASTFORWARD);
        this.elements.put("QuantityType", QuantityType.class);
        this.elements.put("StringListType", StringListType.class);
        this.elements.put("RawType", RawType.class);
        this.elements.put("DateTimeType", DateTimeType.class);
        this.elements.put("DecimalType", DecimalType.class);
        this.elements.put("HSBType", HSBType.class);
        this.elements.put("PercentType", PercentType.class);
        this.elements.put("PointType", PointType.class);
        this.elements.put("StringType", StringType.class);
        this.elements.put("ImperialUnits", ImperialUnits.class);
        this.elements.put("MetricPrefix", MetricPrefix.class);
        this.elements.put("SIUnits", SIUnits.class);
        this.elements.put("Units", Units.class);
        this.elements.put("BinaryPrefix", BinaryPrefix.class);
        this.elements.put("ChronoUnit", ChronoUnit.class);
        this.elements.put("DayOfWeek", DayOfWeek.class);
        this.elements.put("Duration", Duration.class);
        this.elements.put("Month", Month.class);
        this.elements.put("ZoneId", ZoneId.class);
        this.elements.put("ZonedDateTime", ZonedDateTime.class);
        this.elements.put("items", new ItemRegistryDelegate(itemRegistry));
        this.elements.put("ir", itemRegistry);
        this.elements.put("itemRegistry", itemRegistry);
        this.elements.put("things", thingRegistry);
        this.elements.put("rules", ruleRegistry);
        this.elements.put("events", busEvent);
        this.elements.put("actions", this.thingActions);
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    synchronized void addThingActions(ThingActions thingActions) {
        this.thingActions.addThingActions(thingActions);
        this.elements.put(thingActions.getClass().getSimpleName(), thingActions.getClass());
    }

    protected void removeThingActions(ThingActions thingActions) {
        this.elements.remove(thingActions.getClass().getSimpleName());
        this.thingActions.removeThingActions(thingActions);
    }

    @Deactivate
    protected void deactivate() {
        this.thingActions.dispose();
        this.elements.clear();
    }

    @Override
    public Collection<String> getDefaultPresets() {
        return Set.of(PRESET_DEFAULT);
    }

    @Override
    public Collection<String> getPresets() {
        return Set.of(PRESET_DEFAULT);
    }

    @Override
    public Collection<String> getTypes() {
        return this.elements.keySet();
    }

    @Override
    public @Nullable Object get(String scriptIdentifier, String type) {
        return this.elements.get(type);
    }

    @Override
    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        if (PRESET_DEFAULT.equals(preset)) {
            return Collections.unmodifiableMap(this.elements);
        }
        return Map.of();
    }

    @Override
    public void unload(String scriptIdentifier) {
    }
}

