package graphemes_test

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/15.0.0/ucd/auxiliary/GraphemeBreakTest.txt

type unicodeTest struct {
	input    []byte
	expected [][]byte
	comment  string
}

var unicodeTests = [602]unicodeTest{
	{
		input:    []byte{0x20, 0x20},
		expected: [][]byte{{0x20}, {0x20}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd},
		expected: [][]byte{{0x20}, {0xd}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xa},
		expected: [][]byte{{0x20}, {0xa}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x1},
		expected: [][]byte{{0x20}, {0x1}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcd, 0x8f},
		expected: [][]byte{{0x20, 0xcd, 0x8f}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd8, 0x80},
		expected: [][]byte{{0x20}, {0xd8, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x20, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] SPACE (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x20}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x20}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x20}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x20}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x20}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x20}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcd, 0xb8},
		expected: [][]byte{{0x20}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] SPACE (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x20},
		expected: [][]byte{{0xd}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xd},
		expected: [][]byte{{0xd}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa},
		expected: [][]byte{{0xd, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x1},
		expected: [][]byte{{0xd}, {0x1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcd, 0x8f},
		expected: [][]byte{{0xd}, {0xcd, 0x8f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xd8, 0x80},
		expected: [][]byte{{0xd}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcd, 0xb8},
		expected: [][]byte{{0xd}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x20},
		expected: [][]byte{{0xa}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd},
		expected: [][]byte{{0xa}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xa},
		expected: [][]byte{{0xa}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x1},
		expected: [][]byte{{0xa}, {0x1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcd, 0x8f},
		expected: [][]byte{{0xa}, {0xcd, 0x8f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd8, 0x80},
		expected: [][]byte{{0xa}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xa}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xa}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xa}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xa}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xa}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xa}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xa}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcd, 0xb8},
		expected: [][]byte{{0xa}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x20},
		expected: [][]byte{{0x1}, {0x20}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xd},
		expected: [][]byte{{0x1}, {0xd}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xa},
		expected: [][]byte{{0x1}, {0xa}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x1},
		expected: [][]byte{{0x1}, {0x1}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcd, 0x8f},
		expected: [][]byte{{0x1}, {0xcd, 0x8f}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0x1}, {0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x1}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xd8, 0x80},
		expected: [][]byte{{0x1}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x1}, {0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0x1}, {0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x1}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x1}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x1}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x1}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x1}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x1}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x80},
		expected: [][]byte{{0x1}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x1}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x1}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x1}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcd, 0xb8},
		expected: [][]byte{{0x1}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0x1}, {0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <START OF HEADING> (Control) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0x20},
		expected: [][]byte{{0xcd, 0x8f}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xd},
		expected: [][]byte{{0xcd, 0x8f}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xa},
		expected: [][]byte{{0xcd, 0x8f}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0x1},
		expected: [][]byte{{0xcd, 0x8f}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcd, 0x8f},
		expected: [][]byte{{0xcd, 0x8f, 0xcd, 0x8f}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0x8f}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xd8, 0x80},
		expected: [][]byte{{0xcd, 0x8f}, {0xd8, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0x8f, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0x8f}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0x8f}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0x8f}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0x8f}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0x8f}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcd, 0x8f}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0x8f, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0x8f}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0x8f, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0x8f, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAPHEME JOINER (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcd, 0x8f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcd, 0x8f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd8, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd8, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcd, 0xb8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0x20},
		expected: [][]byte{{0xd8, 0x80, 0x20}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xd},
		expected: [][]byte{{0xd8, 0x80}, {0xd}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xa},
		expected: [][]byte{{0xd8, 0x80}, {0xa}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0x1},
		expected: [][]byte{{0xd8, 0x80}, {0x1}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcd, 0x8f},
		expected: [][]byte{{0xd8, 0x80, 0xcd, 0x8f}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd8, 0x80, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xd8, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xd8, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd8, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd8, 0x80, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd8, 0x80, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd8, 0x80, 0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd8, 0x80, 0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd8, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xd8, 0x80, 0xcd, 0xb8}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.2] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd8, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xd8, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ARABIC NUMBER SIGN (Prepend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0x1},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0x1}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcd, 0x8f},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcd, 0x8f}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xd8, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xd8, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x83}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe0, 0xa4, 0x83, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe0, 0xa4, 0x83, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] DEVANAGARI SIGN VISARGA (SpacingMark) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0x20},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0x20}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xd},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xd}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xa},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xa}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0x1},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0x1}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x84, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0x20},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0x20}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xd},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xd}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xa},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xa}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0x1},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0x1}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x85, 0xa0}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x85, 0xa0, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x85, 0xa0, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JUNGSEONG FILLER (V) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0x20},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0x20}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xd},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xd}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xa},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xa}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0x1},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0x1}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x86, 0xa8}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x86, 0xa8, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe1, 0x86, 0xa8, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL JONGSEONG KIYEOK (T) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0x1},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0x1}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcd, 0x8f},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xd8, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0x1},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0x1}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcd, 0x8f},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xd8, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x81}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x20},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x20}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xd},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xd}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xa},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xa}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x1}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcd, 0x8f},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcd, 0x8f}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xd8, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xd8, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x20},
		expected: [][]byte{{0xcc, 0x80}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd},
		expected: [][]byte{{0xcc, 0x80}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xa},
		expected: [][]byte{{0xcc, 0x80}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x1},
		expected: [][]byte{{0xcc, 0x80}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcd, 0x8f},
		expected: [][]byte{{0xcc, 0x80, 0xcd, 0x8f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd8, 0x80},
		expected: [][]byte{{0xcc, 0x80}, {0xd8, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcc, 0x80, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcc, 0x80}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcc, 0x80}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcc, 0x80}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcc, 0x80}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcd, 0xb8},
		expected: [][]byte{{0xcc, 0x80}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x1},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcd, 0x8f},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcd, 0x8f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd8, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd8, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0x20},
		expected: [][]byte{{0xcd, 0xb8}, {0x20}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xd},
		expected: [][]byte{{0xcd, 0xb8}, {0xd}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xa},
		expected: [][]byte{{0xcd, 0xb8}, {0xa}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0x1},
		expected: [][]byte{{0xcd, 0xb8}, {0x1}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [5.0] <START OF HEADING> (Control) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcd, 0x8f},
		expected: [][]byte{{0xcd, 0xb8, 0xcd, 0x8f}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcd, 0x8f},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xcd, 0x8f}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAPHEME JOINER (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0xb8}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xd8, 0x80},
		expected: [][]byte{{0xcd, 0xb8}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xd8, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xd8, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0xb8, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe0, 0xa4, 0x83}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x85, 0xa0},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x85, 0xa0}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JUNGSEONG FILLER (V) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0xb8}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe1, 0x86, 0xa8},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe1, 0x86, 0xa8}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL JONGSEONG KIYEOK (T) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0xb8}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xea, 0xb0, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GA (LV) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0xb8}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xea, 0xb0, 0x81},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xea, 0xb0, 0x81}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] HANGUL SYLLABLE GAG (LVT) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcd, 0xb8}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] COMBINING GRAVE ACCENT (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0xb8}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <reserved-0378> (Other) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcd, 0xb8, 0xcc, 0x88, 0xcd, 0xb8},
		expected: [][]byte{{0xcd, 0xb8, 0xcc, 0x88}, {0xcd, 0xb8}},
		comment:  "÷ [0.2] <reserved-0378> (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] <reserved-0378> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa, 0x61, 0xa, 0xcc, 0x88},
		expected: [][]byte{{0xd, 0xa}, {0x61}, {0xa}, {0xcc, 0x88}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Other) ÷ [5.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88},
		expected: [][]byte{{0x61, 0xcc, 0x88}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}, {0xd9, 0x86}},
		comment:  "÷ [0.2] SPACE (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] ARABIC LETTER NOON (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xd9, 0x86, 0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ARABIC LETTER NOON (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] SPACE (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xe1, 0x84, 0x80, 0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL CHOSEONG KIYEOK (L) × [6.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x80, 0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GA (LV) × [7.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8, 0xe1, 0x84, 0x80},
		expected: [][]byte{{0xea, 0xb0, 0x81, 0xe1, 0x86, 0xa8}, {0xe1, 0x84, 0x80}},
		comment:  "÷ [0.2] HANGUL SYLLABLE GAG (LVT) × [8.0] HANGUL JONGSEONG KIYEOK (T) ÷ [999.0] HANGUL CHOSEONG KIYEOK (L) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [12.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [13.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x62},
		expected: [][]byte{{0x61, 0xcc, 0x88}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe0, 0xa4, 0x83, 0x62},
		expected: [][]byte{{0x61, 0xe0, 0xa4, 0x83}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.1] DEVANAGARI SIGN VISARGA (SpacingMark) ÷ [999.0] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xd8, 0x80, 0x62},
		expected: [][]byte{{0x61}, {0xd8, 0x80, 0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) ÷ [999.0] ARABIC NUMBER SIGN (Prepend) × [9.2] LATIN SMALL LETTER B (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0x61, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [999.0] BABY (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) × [9.0] COMBINING DIAERESIS (Extend_ExtCccZwj) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] BABY (ExtPict) × [9.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPict) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] UPPER BLADE SCISSORS (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) × [11.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d}, {0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Other) × [9.0] ZERO WIDTH JOINER (ZWJ_ExtCccZwj) ÷ [999.0] UPPER BLADE SCISSORS (Other) ÷ [0.3]",
	},
}
