// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// LogRecord are experimental implementation of OpenTelemetry Log Data Model.

type LogRecord struct {
	Body                   AnyValue
	SeverityText           string
	EventName              string
	Attributes             []KeyValue
	TimeUnixNano           uint64
	ObservedTimeUnixNano   uint64
	SeverityNumber         SeverityNumber
	DroppedAttributesCount uint32
	Flags                  uint32
	TraceId                TraceID
	SpanId                 SpanID
}

var (
	protoPoolLogRecord = sync.Pool{
		New: func() any {
			return &LogRecord{}
		},
	}
)

func NewLogRecord() *LogRecord {
	if !UseProtoPooling.IsEnabled() {
		return &LogRecord{}
	}
	return protoPoolLogRecord.Get().(*LogRecord)
}

func DeleteLogRecord(orig *LogRecord, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteAnyValue(&orig.Body, false)
	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	DeleteTraceID(&orig.TraceId, false)
	DeleteSpanID(&orig.SpanId, false)

	orig.Reset()
	if nullable {
		protoPoolLogRecord.Put(orig)
	}
}

func CopyLogRecord(dest, src *LogRecord) *LogRecord {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLogRecord()
	}
	dest.TimeUnixNano = src.TimeUnixNano
	dest.ObservedTimeUnixNano = src.ObservedTimeUnixNano
	dest.SeverityNumber = src.SeverityNumber
	dest.SeverityText = src.SeverityText
	CopyAnyValue(&dest.Body, &src.Body)

	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.DroppedAttributesCount = src.DroppedAttributesCount
	dest.Flags = src.Flags
	CopyTraceID(&dest.TraceId, &src.TraceId)

	CopySpanID(&dest.SpanId, &src.SpanId)

	dest.EventName = src.EventName

	return dest
}

func CopyLogRecordSlice(dest, src []LogRecord) []LogRecord {
	var newDest []LogRecord
	if cap(dest) < len(src) {
		newDest = make([]LogRecord, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogRecord(&dest[i], false)
		}
	}
	for i := range src {
		CopyLogRecord(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLogRecordPtrSlice(dest, src []*LogRecord) []*LogRecord {
	var newDest []*LogRecord
	if cap(dest) < len(src) {
		newDest = make([]*LogRecord, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogRecord()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogRecord(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogRecord()
		}
	}
	for i := range src {
		CopyLogRecord(newDest[i], src[i])
	}
	return newDest
}

func (orig *LogRecord) Reset() {
	*orig = LogRecord{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *LogRecord) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	if orig.ObservedTimeUnixNano != uint64(0) {
		dest.WriteObjectField("observedTimeUnixNano")
		dest.WriteUint64(orig.ObservedTimeUnixNano)
	}

	if int32(orig.SeverityNumber) != 0 {
		dest.WriteObjectField("severityNumber")
		dest.WriteInt32(int32(orig.SeverityNumber))
	}
	if orig.SeverityText != "" {
		dest.WriteObjectField("severityText")
		dest.WriteString(orig.SeverityText)
	}
	dest.WriteObjectField("body")
	orig.Body.MarshalJSON(dest)
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	if !orig.TraceId.IsEmpty() {
		dest.WriteObjectField("traceId")
		orig.TraceId.MarshalJSON(dest)
	}
	if !orig.SpanId.IsEmpty() {
		dest.WriteObjectField("spanId")
		orig.SpanId.MarshalJSON(dest)
	}
	if orig.EventName != "" {
		dest.WriteObjectField("eventName")
		dest.WriteString(orig.EventName)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *LogRecord) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()
		case "observedTimeUnixNano", "observed_time_unix_nano":
			orig.ObservedTimeUnixNano = iter.ReadUint64()
		case "severityNumber", "severity_number":
			orig.SeverityNumber = SeverityNumber(iter.ReadEnumValue(SeverityNumber_value))
		case "severityText", "severity_text":
			orig.SeverityText = iter.ReadString()
		case "body":

			orig.Body.UnmarshalJSON(iter)
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "flags":
			orig.Flags = iter.ReadUint32()
		case "traceId", "trace_id":

			orig.TraceId.UnmarshalJSON(iter)
		case "spanId", "span_id":

			orig.SpanId.UnmarshalJSON(iter)
		case "eventName", "event_name":
			orig.EventName = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *LogRecord) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.TimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.ObservedTimeUnixNano != uint64(0) {
		n += 9
	}
	if orig.SeverityNumber != SeverityNumber(0) {
		n += 1 + proto.Sov(uint64(orig.SeverityNumber))
	}

	l = len(orig.SeverityText)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.Body.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != uint32(0) {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	if orig.Flags != uint32(0) {
		n += 5
	}
	l = orig.TraceId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l

	l = len(orig.EventName)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *LogRecord) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.TimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x9
	}
	if orig.ObservedTimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.ObservedTimeUnixNano))
		pos--
		buf[pos] = 0x59
	}
	if orig.SeverityNumber != SeverityNumber(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SeverityNumber))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.SeverityText)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SeverityText)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	l = orig.Body.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x32
	}
	if orig.DroppedAttributesCount != uint32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x38
	}
	if orig.Flags != uint32(0) {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x45
	}
	l = orig.TraceId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x4a

	l = orig.SpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x52

	l = len(orig.EventName)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.EventName)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x62
	}
	return len(buf) - pos
}

func (orig *LogRecord) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 11:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.ObservedTimeUnixNano = uint64(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityNumber", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.SeverityNumber = SeverityNumber(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SeverityText", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SeverityText = string(buf[startPos:pos])

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Body.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 6:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 7:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.DroppedAttributesCount = uint32(num)

		case 8:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)

		case 9:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 10:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 12:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field EventName", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.EventName = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLogRecord() *LogRecord {
	orig := NewLogRecord()
	orig.TimeUnixNano = uint64(13)
	orig.ObservedTimeUnixNano = uint64(13)
	orig.SeverityNumber = SeverityNumber(13)
	orig.SeverityText = "test_severitytext"
	orig.Body = *GenTestAnyValue()
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.DroppedAttributesCount = uint32(13)
	orig.Flags = uint32(13)
	orig.TraceId = *GenTestTraceID()
	orig.SpanId = *GenTestSpanID()
	orig.EventName = "test_eventname"
	return orig
}

func GenTestLogRecordPtrSlice() []*LogRecord {
	orig := make([]*LogRecord, 5)
	orig[0] = NewLogRecord()
	orig[1] = GenTestLogRecord()
	orig[2] = NewLogRecord()
	orig[3] = GenTestLogRecord()
	orig[4] = NewLogRecord()
	return orig
}

func GenTestLogRecordSlice() []LogRecord {
	orig := make([]LogRecord, 5)
	orig[1] = *GenTestLogRecord()
	orig[3] = *GenTestLogRecord()
	return orig
}
