// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +xandesperf -emit-llvm %s -o - \
// RUN:     -disable-O0-optnone | opt -S -passes=mem2reg \
// RUN:     | FileCheck %s --check-prefix=CHECK-RV64

#include <stdint.h>

// CHECK-RV64-LABEL: @test_ffb(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffb.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-RV64-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffb(uint64_t a, uint64_t b) {
  return __builtin_riscv_nds_ffb_64(a, b);
}

// CHECK-RV64-LABEL: @test_ffzmism(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffzmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-RV64-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffzmism(uint64_t a, uint64_t b) {
  return __builtin_riscv_nds_ffzmism_64(a, b);
}

// CHECK-RV64-LABEL: @test_ffmism(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.ffmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-RV64-NEXT:    ret i64 [[TMP0]]
//
int64_t test_ffmism(uint64_t a, uint64_t b) {
  return __builtin_riscv_nds_ffmism_64(a, b);
}

// CHECK-RV64-LABEL: @test_flmism(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call i64 @llvm.riscv.nds.flmism.i64(i64 [[A:%.*]], i64 [[B:%.*]])
// CHECK-RV64-NEXT:    ret i64 [[TMP0]]
//
int64_t test_flmism(uint64_t a, uint64_t b) {
  return __builtin_riscv_nds_flmism_64(a, b);
}
