---
name: Bug report
about: Create a report to help us improve FLTK
title: ''
labels: ''
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Please attach a self contained example that allows us to reproduce the problem.
Such an example typically consists of a single source file (e.g. `demo.cxx`) and
build instructions (e.g. `fltk-config --compile demo.cxx`). Alternatively, try
to reproduce the bug with one of the included test programs in the `test` or
`examples` folders. Add a description like this:

Steps to reproduce the behavior:
1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error: ...

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**FLTK Version**
Please complete the following information and delete non-applicable lines:
 - Version: [e.g. 1.4.0]
 - Installed as package from: [e.g. Debian 11.4 Bullseye]
 - Downloaded and self-built from: [e.g. Git, Snapshot and version, or tarball/zip]
 - If from Git, branch: [e.g. master, branch-1.3]
 - If from Git, commit: [e.g. 7d58e2385452]

**FLTK Configure / Build Options**
Please add the complete configure and build command lines if you built FLTK yourself.
Please include all configure or CMake options and add all CMake options you changed
by using CMake GUI tools (if any).
 - ./configure --enable-cairo ...
 - cmake -G"..." -DCMAKE_BUILD_TYPE=Debug ...

**Operating System / Platform:**
Please be as precise as possible, e.g. "Linux: Ubuntu 20.04"
 - OS: [e.g. Linux, macOS, Windows]
 - OS Version: [e.g. Ubuntu 20.04, macOS 12.6, Windows 11]
 - Processor if relevant [e.g. on macOS: M1, Intel]

**Linux/Unix Runtime, if applicable:**
 - Wayland
 - X11

**Additional context**
Add any other context about the problem here.
