/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "árabe";
        final String metaValue_hy = "armênio";
        final String metaValue_ae = "avéstico";
        final String metaValue_ban = "balinês";
        final String metaValue_bax = "bamum";
        final String metaValue_bn = "bengali";
        final String metaValue_bug = "buginês";
        final String metaValue_ka = "georgiano";
        final String metaValue_got = "gótico";
        final String metaValue_el = "grego";
        final String metaValue_gu = "guzerate";
        final String metaValue_he = "hebraico";
        final String metaValue_jv = "javanês";
        final String metaValue_ja = "japonês";
        final String metaValue_km = "khmer";
        final String metaValue_ko = "coreano";
        final String metaValue_la = "latim";
        final String metaValue_ml = "malaiala";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmanês";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "oriá";
        final String metaValue_phn = "fenício";
        final String metaValue_si = "cingalês";
        final String metaValue_su = "sundanês";
        final String metaValue_syr = "siríaco";
        final String metaValue_ta = "tâmil";
        final String metaValue_te = "télugo";
        final String metaValue_tl = "tagalo";
        final String metaValue_th = "tailandês";
        final String metaValue_bo = "tibetano";
        final String metaValue_uga = "ugarítico";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "África" },
            { "003", "América do Norte" },
            { "005", "América do Sul" },
            { "009", "Oceania" },
            { "011", "África Ocidental" },
            { "013", "América Central" },
            { "014", "África Oriental" },
            { "015", "África Setentrional" },
            { "017", "África Central" },
            { "018", "África Meridional" },
            { "019", "Américas" },
            { "021", "América Setentrional" },
            { "029", "Caribe" },
            { "030", "Ásia Oriental" },
            { "034", "Ásia Meridional" },
            { "035", "Sudeste Asiático" },
            { "039", "Europa Meridional" },
            { "053", "Australásia" },
            { "054", "Melanésia" },
            { "057", "Região da Micronésia" },
            { "061", "Polinésia" },
            { "142", "Ásia" },
            { "143", "Ásia Central" },
            { "145", "Ásia Ocidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa Setentrional" },
            { "155", "Europa Ocidental" },
            { "202", "África Subsaariana" },
            { "419", "América Latina" },
            { "AC", "Ilha de Ascensão" },
            { "AD", "Andorra" },
            { "AE", "Emirados Árabes Unidos" },
            { "AF", "Afeganistão" },
            { "AG", "Antígua e Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albânia" },
            { "AM", "Armênia" },
            { "AO", "Angola" },
            { "AQ", "Antártida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Áustria" },
            { "AU", "Austrália" },
            { "AW", "Aruba" },
            { "AX", "Ilhas Aland" },
            { "AZ", "Azerbaijão" },
            { "BA", "Bósnia e Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Bélgica" },
            { "BF", "Burquina Faso" },
            { "BG", "Bulgária" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "São Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolívia" },
            { "BQ", "Países Baixos Caribenhos" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "Butão" },
            { "BV", "Ilha Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrússia" },
            { "BZ", "Belize" },
            { "CA", "Canadá" },
            { "CC", "Ilhas Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "República Centro-Africana" },
            { "CG", "República do Congo" },
            { "CH", "Suíça" },
            { "CI", "Costa do Marfim" },
            { "CK", "Ilhas Cook" },
            { "CL", "Chile" },
            { "CM", "Camarões" },
            { "CN", "China" },
            { "CO", "Colômbia" },
            { "CP", "Ilha de Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Curaçao" },
            { "CX", "Ilha Christmas" },
            { "CY", "Chipre" },
            { "CZ", "Tchéquia" },
            { "DE", "Alemanha" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Argélia" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Equador" },
            { "EE", "Estônia" },
            { "EG", "Egito" },
            { "EH", "Saara Ocidental" },
            { "ER", "Eritreia" },
            { "ES", "Espanha" },
            { "ET", "Etiópia" },
            { "EU", "União Europeia" },
            { "EZ", "zona do euro" },
            { "FI", "Finlândia" },
            { "FJ", "Fiji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Micronésia" },
            { "FO", "Ilhas Faroé" },
            { "FR", "França" },
            { "GA", "Gabão" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Geórgia" },
            { "GF", "Guiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenlândia" },
            { "GM", "Gâmbia" },
            { "GN", "Guiné" },
            { "GP", "Guadalupe" },
            { "GQ", "Guiné Equatorial" },
            { "GR", "Grécia" },
            { "GS", "Ilhas Geórgia do Sul e Sandwich do Sul" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guiné-Bissau" },
            { "GY", "Guiana" },
            { "HK", "Hong Kong, RAE da China" },
            { "HM", "Ilhas Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croácia" },
            { "HT", "Haiti" },
            { "HU", "Hungria" },
            { "IC", "Ilhas Canárias" },
            { "ID", "Indonésia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Ilha de Man" },
            { "IN", "Índia" },
            { "IO", "Território Britânico do Oceano Índico" },
            { "IQ", "Iraque" },
            { "IR", "Irã" },
            { "IS", "Islândia" },
            { "IT", "Itália" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordânia" },
            { "JP", "Japão" },
            { "KE", "Quênia" },
            { "KG", "Quirguistão" },
            { "KH", "Camboja" },
            { "KI", "Quiribati" },
            { "KM", "Comores" },
            { "KN", "São Cristóvão e Névis" },
            { "KP", "Coreia do Norte" },
            { "KR", "Coreia do Sul" },
            { "KW", "Kuwait" },
            { "KY", "Ilhas Cayman" },
            { "KZ", "Cazaquistão" },
            { "LA", "Laos" },
            { "LB", "Líbano" },
            { "LC", "Santa Lúcia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libéria" },
            { "LS", "Lesoto" },
            { "LT", "Lituânia" },
            { "LU", "Luxemburgo" },
            { "LV", "Letônia" },
            { "LY", "Líbia" },
            { "MA", "Marrocos" },
            { "MC", "Mônaco" },
            { "MD", "Moldávia" },
            { "ME", "Montenegro" },
            { "MF", "São Martinho" },
            { "MG", "Madagascar" },
            { "MH", "Ilhas Marshall" },
            { "MK", "Macedônia do Norte" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birmânia)" },
            { "MN", "Mongólia" },
            { "MO", "Macau, RAE da China" },
            { "MP", "Ilhas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Mauritânia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurício" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "México" },
            { "MY", "Malásia" },
            { "MZ", "Moçambique" },
            { "NA", "Namíbia" },
            { "NC", "Nova Caledônia" },
            { "NE", "Níger" },
            { "NF", "Ilha Norfolk" },
            { "NG", "Nigéria" },
            { "NI", "Nicarágua" },
            { "NL", "Países Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zelândia" },
            { "OM", "Omã" },
            { "PA", "Panamá" },
            { "PE", "Peru" },
            { "PF", "Polinésia Francesa" },
            { "PG", "Papua-Nova Guiné" },
            { "PH", "Filipinas" },
            { "PK", "Paquistão" },
            { "PL", "Polônia" },
            { "PM", "São Pedro e Miquelão" },
            { "PN", "Ilhas Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territórios palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Catar" },
            { "QO", "Oceania Remota" },
            { "RE", "Reunião" },
            { "RO", "Romênia" },
            { "RS", "Sérvia" },
            { "RU", "Rússia" },
            { "RW", "Ruanda" },
            { "SA", "Arábia Saudita" },
            { "SB", "Ilhas Salomão" },
            { "SC", "Seicheles" },
            { "SD", "Sudão" },
            { "SE", "Suécia" },
            { "SG", "Singapura" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovênia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Eslováquia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somália" },
            { "SR", "Suriname" },
            { "SS", "Sudão do Sul" },
            { "ST", "São Tomé e Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Síria" },
            { "SZ", "Essuatíni" },
            { "TA", "Tristão da Cunha" },
            { "TC", "Ilhas Turcas e Caicos" },
            { "TD", "Chade" },
            { "TF", "Territórios Franceses do Sul" },
            { "TG", "Togo" },
            { "TH", "Tailândia" },
            { "TJ", "Tadjiquistão" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turcomenistão" },
            { "TN", "Tunísia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzânia" },
            { "UA", "Ucrânia" },
            { "UG", "Uganda" },
            { "UM", "Ilhas Menores Distantes dos EUA" },
            { "UN", "Nações Unidas" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbequistão" },
            { "VA", "Cidade do Vaticano" },
            { "VC", "São Vicente e Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Ilhas Virgens Britânicas" },
            { "VI", "Ilhas Virgens Americanas" },
            { "VN", "Vietnã" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudossotaques" },
            { "XB", "Pseudobidirecional" },
            { "XK", "Kosovo" },
            { "YE", "Iêmen" },
            { "YT", "Mayotte" },
            { "ZA", "África do Sul" },
            { "ZM", "Zâmbia" },
            { "ZW", "Zimbábue" },
            { "ZZ", "Região desconhecida" },
            { "aa", "afar" },
            { "ab", "abcázio" },
            { "ae", metaValue_ae },
            { "af", "africâner" },
            { "ak", "akan" },
            { "am", "amárico" },
            { "an", "aragonês" },
            { "ar", metaValue_ar },
            { "as", "assamês" },
            { "av", "avárico" },
            { "ay", "aimará" },
            { "az", "azerbaijano" },
            { "ba", "bashkir" },
            { "be", "bielorrusso" },
            { "bg", "búlgaro" },
            { "bi", "bislamá" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretão" },
            { "bs", "bósnio" },
            { "ca", "catalão" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "tcheco" },
            { "cu", "eslavo eclesiástico" },
            { "cv", "tchuvache" },
            { "cy", "galês" },
            { "da", "dinamarquês" },
            { "de", "alemão" },
            { "dv", "divehi" },
            { "dz", "dzonga" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglês" },
            { "eo", "esperanto" },
            { "es", "espanhol" },
            { "et", "estoniano" },
            { "eu", "basco" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finlandês" },
            { "fj", "fijiano" },
            { "fo", "feroês" },
            { "fr", "francês" },
            { "fy", "frísio ocidental" },
            { "ga", "irlandês" },
            { "gd", "gaélico escocês" },
            { "gl", "galego" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hauçá" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitiano" },
            { "hu", "húngaro" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlíngua" },
            { "id", "indonésio" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiaque" },
            { "io", "ido" },
            { "is", "islandês" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "congolês" },
            { "ki", "quicuio" },
            { "kj", "cuanhama" },
            { "kk", "cazaque" },
            { "kl", "groenlandês" },
            { "km", metaValue_km },
            { "kn", "canarim" },
            { "ko", metaValue_ko },
            { "kr", "canúri" },
            { "ks", "caxemira" },
            { "ku", "curmânji" },
            { "kv", "komi" },
            { "kw", "córnico" },
            { "ky", "quirguiz" },
            { "la", metaValue_la },
            { "lb", "luxemburguês" },
            { "lg", "luganda" },
            { "li", "limburguês" },
            { "ln", "lingala" },
            { "lo", "laosiano" },
            { "lt", "lituano" },
            { "lu", "luba-catanga" },
            { "lv", "letão" },
            { "mg", "malgaxe" },
            { "mh", "marshalês" },
            { "mi", "maori" },
            { "mk", "macedônio" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "malaio" },
            { "mt", "maltês" },
            { "my", metaValue_my },
            { "na", "nauruano" },
            { "nb", "bokmål norueguês" },
            { "nd", "ndebele do norte" },
            { "ne", "nepalês" },
            { "ng", "dongo" },
            { "nl", "holandês" },
            { "nn", "nynorsk norueguês" },
            { "no", "norueguês" },
            { "nr", "ndebele do sul" },
            { "nv", "navajo" },
            { "ny", "nianja" },
            { "oc", "occitânico" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseto" },
            { "pa", "panjabi" },
            { "pi", "páli" },
            { "pl", "polonês" },
            { "ps", "pashto" },
            { "pt", "português" },
            { "qu", "quíchua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "romeno" },
            { "ru", "russo" },
            { "rw", "quiniaruanda" },
            { "sa", "sânscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami setentrional" },
            { "sg", "sango" },
            { "sh", "servo-croata" },
            { "si", metaValue_si },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "xona" },
            { "so", "somali" },
            { "sq", "albanês" },
            { "sr", "sérvio" },
            { "ss", "suázi" },
            { "st", "soto do sul" },
            { "su", metaValue_su },
            { "sv", "sueco" },
            { "sw", "suaíli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjique" },
            { "th", metaValue_th },
            { "ti", "tigrínia" },
            { "tk", "turcomeno" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganês" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tártaro" },
            { "tw", "twi" },
            { "ty", "taitiano" },
            { "ug", "uigur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "uzbeque" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapuque" },
            { "wa", "valão" },
            { "wo", "uolofe" },
            { "xh", "xhosa" },
            { "yi", "iídiche" },
            { "yo", "iorubá" },
            { "za", "zhuang" },
            { "zh", "chinês" },
            { "zu", "zulu" },
            { "ace", "achém" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigue" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadiano" },
            { "ale", "aleúte" },
            { "alt", "altai meridional" },
            { "ang", "inglês arcaico" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramaico" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "ars", "árabe négede" },
            { "arw", "arauaqui" },
            { "asa", "asu" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "balúchi" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "ghomala’" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "hariani" },
            { "bgn", "balúchi ocidental" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriato" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "jargão Chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cheroqui" },
            { "chy", "cheiene" },
            { "ckb", "curdo central" },
            { "clc", "chilcotin" },
            { "cop", "copta" },
            { "crg", "michif" },
            { "crh", "tártara da Crimeia" },
            { "crj", "cree do sudeste" },
            { "crk", "cree das planícies" },
            { "crl", "cree do nordeste" },
            { "crm", "moose cree" },
            { "crr", "algonquiano Carolina" },
            { "crs", "crioulo francês seichelense" },
            { "csb", "kashubian" },
            { "csw", "cree swampy" },
            { "dak", "dacota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baixo sorábio" },
            { "dua", "duala" },
            { "dum", "holandês médio" },
            { "dyo", "jola-fonyi" },
            { "dyu", "diúla" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efique" },
            { "egy", "egípcio arcaico" },
            { "eka", "ekajuk" },
            { "elx", "elamite" },
            { "enm", "inglês médio" },
            { "ewo", "ewondo" },
            { "fan", "fangue" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fon", "fom" },
            { "frc", "francês cajun" },
            { "frm", "francês médio" },
            { "fro", "francês arcaico" },
            { "frr", "frísio setentrional" },
            { "frs", "frisão oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaia" },
            { "gez", "geez" },
            { "gil", "gilbertês" },
            { "gmh", "alto alemão médio" },
            { "goh", "alemão arcaico alto" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "grego arcaico" },
            { "gsw", "alemão (Suíça)" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "hak", "hacá" },
            { "haw", "havaiano" },
            { "hax", "haida do sul" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "alto sorábio" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadense ocidental" },
            { "ilo", "ilocano" },
            { "inh", "inguche" },
            { "jbo", "lojban" },
            { "jgo", "nguemba" },
            { "jmc", "machame" },
            { "jpr", "judaico-persa" },
            { "jrb", "judaico-arábico" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "maconde" },
            { "kea", "crioulo cabo-verdiano" },
            { "kfo", "koro" },
            { "kgp", "caingangue" },
            { "kha", "khasi" },
            { "kho", "khotanês" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "quimbundo" },
            { "koi", "komi-permyak" },
            { "kok", "concani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "carélio" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kölsch" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgui" },
            { "lij", "ligure" },
            { "lil", "lillooet" },
            { "lkt", "lacota" },
            { "lmo", "lombardo" },
            { "lol", "mongo" },
            { "lou", "crioulo da Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri setentrional" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "mad", "madurês" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandinga" },
            { "mas", "massai" },
            { "mde", "maba" },
            { "mdf", "mocsa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "irlandês médio" },
            { "mgh", "macua-mêto" },
            { "mgo", "meta’" },
            { "mic", "miquemaque" },
            { "min", "minangkabau" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "moicano" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "múltiplos idiomas" },
            { "mus", "creek" },
            { "mwl", "mirandês" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazandarani" },
            { "nan", "min nan" },
            { "nap", "napolitano" },
            { "naq", "nama" },
            { "nds", "baixo alemão" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueano" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "nórdico arcaico" },
            { "nqo", metaValue_nqo },
            { "nso", "soto setentrional" },
            { "nus", "nuer" },
            { "nwc", "newari clássico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwa do noroeste" },
            { "ojc", "ojibwa central" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa ocidental" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "pag", "pangasinã" },
            { "pal", "pálavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "pcm", "pidgin nigeriano" },
            { "peo", "persa arcaico" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pon", "pohnpeiano" },
            { "pqm", "malecite–passamaquoddy" },
            { "prg", "prussiano" },
            { "pro", "provençal arcaico" },
            { "quc", "quiché" },
            { "raj", "rajastani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "rhg", "ruainga" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromeno" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "sam", "aramaico samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "scots" },
            { "sdh", "curdo meridional" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irlandês arcaico" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "árabe chadiano" },
            { "sid", "sidamo" },
            { "slh", "lushootseed do sul" },
            { "sma", "sami meridional" },
            { "smj", "sami de Lule" },
            { "smn", "lapão de Inari" },
            { "sms", "sami de Skolt" },
            { "snk", "soninquê" },
            { "sog", "sogdiano" },
            { "srn", "surinamês" },
            { "srr", "serere" },
            { "ssy", metaValue_ssy },
            { "str", "salish do estreito norte" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumério" },
            { "swb", "comoriano" },
            { "syc", "siríaco clássico" },
            { "syr", metaValue_syr },
            { "szl", "silesiano" },
            { "tce", "tutchone do sul" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tétum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigré" },
            { "tiv", "tiv" },
            { "tkl", "toquelauano" },
            { "tlh", "klingon" },
            { "tli", "tlinguite" },
            { "tmh", "tamaxeque" },
            { "tog", "tonganês de Nyasa" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshiano" },
            { "ttm", "tutchone setentrional" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluano" },
            { "twq", "tasawaq" },
            { "tyv", "tuviniano" },
            { "tzm", "tamazight do Atlas Central" },
            { "udm", "udmurte" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "idioma desconhecido" },
            { "vec", "vêneto" },
            { "vmw", "macua" },
            { "vot", "vótico" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmyk" },
            { "xnr", "kandri" },
            { "xog", "lusoga" },
            { "yao", "yao" },
            { "yap", "yapese" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonês" },
            { "zap", "zapoteco" },
            { "zbl", "símbolos blis" },
            { "zen", "zenaga" },
            { "zgh", "tamazirte marroqino padrão" },
            { "zun", "zunhi" },
            { "zxx", "sem conteúdo linguístico" },
            { "zza", "zazaki" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "armi" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Batk", "bataque" },
            { "Beng", metaValue_bn },
            { "Blis", "símbolos bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", "cakm" },
            { "Cans", "escrita silábica unificada dos aborígenes canadenses" },
            { "Cari", "cariano" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", "cóptico" },
            { "Cprt", "cipriota" },
            { "Cyrl", "cirílico" },
            { "Cyrs", "cirílico eslavo eclesiástico" },
            { "Deva", "devanágari" },
            { "Dsrt", "deseret" },
            { "Egyd", "demótico egípcio" },
            { "Egyh", "hierático egípcio" },
            { "Egyp", "hieróglifos egípcios" },
            { "Ethi", "etiópico" },
            { "Geok", "khutsuri georgiano" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolítico" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuqui" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "simplificado" },
            { "Hant", "tradicional" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silabários japoneses" },
            { "Hung", "húngaro antigo" },
            { "Inds", "indo" },
            { "Ital", "itálico antigo" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Knda", "kannada" },
            { "Kore", metaValue_ko },
            { "Kthi", "kthi" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "latim fraktur" },
            { "Latg", "latim gaélico" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "linear A" },
            { "Linb", "linear B" },
            { "Lisu", "lisu" },
            { "Lyci", "lício" },
            { "Lydi", "lídio" },
            { "Mand", "mandaico" },
            { "Mani", "maniqueano" },
            { "Maya", "hieróglifos maias" },
            { "Merc", "meroítico cursivo" },
            { "Mero", "meroítico" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogâmico" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "osmania" },
            { "Perm", "pérmico antigo" },
            { "Phag", "phags-pa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", "pahlavi antigo" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonético pollard" },
            { "Prti", "prti" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "rúnico" },
            { "Samr", "samaritano" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "signwriting" },
            { "Shaw", "shaviano" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siríaco estrangelo" },
            { "Syrj", "siríaco ocidental" },
            { "Syrn", "siríaco oriental" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai Le" },
            { "Talu", "novo tai lue" },
            { "Taml", metaValue_ta },
            { "Tavt", "tavt" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "visible speech" },
            { "Xpeo", "persa antigo" },
            { "Xsux", "sumério-acadiano cuneiforme" },
            { "Yiii", "yi" },
            { "Zinh", "herdado" },
            { "Zmth", "notação matemática" },
            { "Zsye", "emoji" },
            { "Zsym", "zsym" },
            { "Zxxx", "ágrafo" },
            { "Zyyy", "comum" },
            { "Zzzz", "escrita desconhecida" },
            { "de_CH", "alto alemão (Suíça)" },
            { "fa_AF", "dari" },
            { "nl_BE", "flamengo" },
            { "ro_MD", "moldávio" },
            { "sw_CD", "suaíli do Congo" },
            { "%%1901", "ortografia alemã tradicional" },
            { "%%1994", "ortografia resiana padronizada" },
            { "%%1996", "ortografia alemã de 1996" },
            { "ar_001", "árabe moderno" },
            { "key.ca", "Calendário" },
            { "key.cf", "Formato de moeda" },
            { "key.co", "Ordenação" },
            { "key.cu", "Moeda" },
            { "key.em", "Tipo de emoji" },
            { "key.hc", "Ciclo de horário (12 vs. 24)" },
            { "key.lb", "Estilo de quebra de linha" },
            { "key.lw", "Quebras de linha em palavras" },
            { "key.ms", "Sistema de medição" },
            { "key.nu", "Números" },
            { "key.ss", "Espaço após abreviação" },
            { "key.tz", "Fuso horário" },
            { "key.va", "Variante de localidade" },
            { "nds_NL", "baixo saxão" },
            { "%%BISKE", "dialeto san giorgio/bila" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "ortografia comum" },
            { "%%LIPAW", "dialeto lipovaz de Resian" },
            { "%%NEDIS", "dialeto natisone" },
            { "%%NJIVA", "dialeto gniva/njiva" },
            { "%%OSOJS", "dialeto oseacco/osojane" },
            { "%%POSIX", "computador" },
            { "%%ROZAJ", "resiano" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialeto stolvizza/solbica" },
            { "%%UCCOR", "ortografia unificada" },
            { "az_Arab", "azeri sul" },
            { "hi_Latn", "hindi (latim)" },
            { "zh_Hans", "chinês simplificado" },
            { "zh_Hant", "chinês tradicional" },
            { "%%AO1990", "Acordo Ortográfico da Língua Portuguesa de 1990" },
            { "%%FONIPA", "fonética do Alfabeto Fonético Internacional" },
            { "%%FONUPA", "fonética do Alfabeto Fonético Urálico" },
            { "%%NDYUKA", "dialeto ndyuka" },
            { "%%PAMAKA", "dialeto pamaka" },
            { "%%PINYIN", "romanização Pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%UCRCOR", "ortografia revisada e unificada" },
            { "%%ABL1943", "Formulário Ortográfico de 1943" },
            { "%%AREVELA", "armênio oriental" },
            { "%%AREVMDA", "armênio ocidental" },
            { "%%HEPBURN", "romanização hepburn" },
            { "%%MONOTON", "monotônico" },
            { "%%POLYTON", "politônico" },
            { "%%REVISED", "ortografia revisada" },
            { "%%1606NICT", "francês antigo de 1606" },
            { "%%1694ACAD", "francês da idade moderna" },
            { "%%1959ACAD", "acadêmico" },
            { "%%BAKU1926", "alfabeto latino turco unificado" },
            { "%%BISCAYAN", "biscainho" },
            { "%%COLB1945", "Convenção Ortográfica Luso-Brasileira de 1945" },
            { "%%HOGNORSK", "alto noruego" },
            { "%%SCOTLAND", "inglês padrão escocês" },
            { "%%VALENCIA", "valenciano" },
            { "%%WADEGILE", "romanização Wade-Giles" },
            { "type.ca.roc", "Calendário da República da China" },
            { "type.co.eor", "Regras europeias de ordenação" },
            { "type.hc.h11", "Sistema de 12 horas (0–11)" },
            { "type.hc.h12", "Sistema de 12 horas (1–12)" },
            { "type.hc.h23", "Sistema de 24 horas (0–23)" },
            { "type.hc.h24", "Sistema de 24 horas (1–24)" },
            { "type.m0.bgn", "Transliteração BGN EUA" },
            { "type.nu.arab", "Algarismos indo-arábicos" },
            { "type.nu.armn", "Algarismos armênios" },
            { "type.nu.beng", "Algarismos bengali" },
            { "type.nu.cakm", "Algarismos chakma" },
            { "type.nu.deva", "Algarismos devanágari" },
            { "type.nu.ethi", "Algarismos etiopianos" },
            { "type.nu.geor", "Algarismos georgianos" },
            { "type.nu.grek", "Algarismos gregos" },
            { "type.nu.gujr", "Algarismos guzerate" },
            { "type.nu.guru", "Algarismos gurmuqui" },
            { "type.nu.hans", "Algarismos chineses simplificados" },
            { "type.nu.hant", "Algarismos chineses tradicionais" },
            { "type.nu.hebr", "Algarismos hebraicos" },
            { "type.nu.java", "Algarismos javaneses" },
            { "type.nu.jpan", "Algarismos japoneses" },
            { "type.nu.khmr", "Algarismos khmer" },
            { "type.nu.knda", "Algarismos canareses" },
            { "type.nu.laoo", "Algarismos laosianos" },
            { "type.nu.latn", "Algarismos ocidentais" },
            { "type.nu.mlym", "Algarismos malaialos" },
            { "type.nu.mong", "Algarismos mongóis" },
            { "type.nu.mtei", "Algarismos meetei mayek" },
            { "type.nu.mymr", "Algarismos mianmarenses" },
            { "type.nu.olck", "Algarismos ol chiki" },
            { "type.nu.orya", "Algarismos oriá" },
            { "type.nu.taml", "Algarismos tâmil tradicionais" },
            { "type.nu.telu", "Algarismos telugos" },
            { "type.nu.thai", "Algarismos tailandeses" },
            { "type.nu.tibt", "Algarismos tibetanos" },
            { "type.nu.vaii", "Algarismos vai" },
            { "type.ca.dangi", "Calendário Dangi" },
            { "type.co.ducet", "Ordem padrão do Unicode" },
            { "type.lb.loose", "Quebra de linha com estilo solto" },
            { "type.nu.roman", "Algarismos romanos" },
            { "type.ca.coptic", "Calendário Copta" },
            { "type.ca.hebrew", "Calendário Hebraico" },
            { "type.ca.indian", "Calendário Nacional Indiano" },
            { "type.co.compat", "Ordem anterior, para compatibilidade" },
            { "type.co.pinyin", "Ordem Pin-yin" },
            { "type.co.search", "Pesquisa de uso geral" },
            { "type.co.stroke", "Ordem dos traços" },
            { "type.co.unihan", "Ordem por Radical-Traços" },
            { "type.co.zhuyin", "Ordem Zhuyin" },
            { "type.d0.fwidth", "Largura inteira" },
            { "type.d0.hwidth", "Meia largura" },
            { "type.lb.normal", "Quebra de linha com estilo normal" },
            { "type.lb.strict", "Quebra de linha com estilo estrito" },
            { "type.m0.ungegn", "Transliteração UN GEGN" },
            { "type.ms.metric", "Sistema métrico" },
            { "type.nu.native", "Algarismos nativos" },
            { "type.ca.chinese", "Calendário Chinês" },
            { "type.ca.islamic", "Calendário Hegírico" },
            { "type.ca.iso8601", "Calendário ISO-8601" },
            { "type.ca.persian", "Calendário Persa" },
            { "type.cf.account", "Formato de moeda para contabilidade" },
            { "type.d0.npinyin", "Numérico" },
            { "type.nu.arabext", "Algarismos indo-arábicos estendidos" },
            { "type.nu.armnlow", "Algarismos armênios minúsculos" },
            { "type.nu.finance", "Numerais financeiros" },
            { "type.nu.greklow", "Algarismos gregos minúsculos" },
            { "type.nu.hanidec", "Algarismos decimais chineses" },
            { "type.nu.hansfin", "Algarismos financeiros chineses simplificados" },
            { "type.nu.hantfin", "Algarismos financeiros chineses tradicionais" },
            { "type.nu.jpanfin", "Algarismos financeiros japoneses" },
            { "type.nu.tamldec", "Algarismos tâmil" },
            { "type.ca.buddhist", "Calendário Budista" },
            { "type.ca.ethiopic", "Calendário Etíope" },
            { "type.ca.japanese", "Calendário Japonês" },
            { "type.cf.standard", "Formato de moeda padrão" },
            { "type.co.phonetic", "Ordem de classificação fonética" },
            { "type.co.searchjl", "Pesquisar por consonante inicial hangul" },
            { "type.co.standard", "Ordem padrão" },
            { "type.ms.uksystem", "Sistema de medição imperial" },
            { "type.ms.ussystem", "Sistema de medição americano" },
            { "type.nu.fullwide", "Algarismos em extensão total" },
            { "type.nu.romanlow", "Algarismos romanos minúsculos" },
            { "type.ca.gregorian", "Calendário Gregoriano" },
            { "type.co.phonebook", "Ordem de lista telefônica" },
            { "type.co.dictionary", "Ordem do dicionário" },
            { "type.co.traditional", "Ordem tradicional" },
            { "type.nu.traditional", "Numerais tradicionais" },
            { "type.ca.islamic-civil", "Calendário Hegírico (tabular, época civil)" },
            { "type.ca.islamic-umalqura", "Calendário Hegírico (Umm al‑Qura)" },
            { "type.ca.ethiopic-amete-alem", "Calendário Amete Alem Etíope" },
        };
        return data;
    }
}
