/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseDataSource;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class KingbaseDatabase
extends PostgreDatabase {
    private DBRProgressMonitor monitor;
    private String characterType;
    private String databaseCompatibleMode;
    final LanguageCache languageCache = new LanguageCache();

    protected KingbaseDatabase(DBRProgressMonitor monitor, KingbaseDataSource dataSource, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        super(monitor, (PostgreDataSource)dataSource, name, owner, templateName, tablespace, encoding);
        this.monitor = monitor;
    }

    protected KingbaseDatabase(DBRProgressMonitor monitor, KingbaseDataSource dataSource, String databaseName) throws DBException {
        super(monitor, (PostgreDataSource)dataSource, databaseName);
        this.monitor = monitor;
        this.readDatabaseInfo(monitor);
        this.checkInstanceConnection(monitor);
    }

    protected KingbaseDatabase(DBRProgressMonitor monitor, KingbaseDataSource dataSource, ResultSet dbResult) throws DBException {
        super(monitor, (PostgreDataSource)dataSource, dbResult);
        this.monitor = monitor;
        this.init(dbResult);
    }

    @NotNull
    public KingbaseDataSource getDataSource() {
        return (KingbaseDataSource)this.dataSource;
    }

    @Property(viewable=true, order=1)
    public long getObjectId() {
        return super.getObjectId();
    }

    @Property(viewable=true, order=6)
    public String getCharacterType() {
        return this.characterType;
    }

    @Property(viewable=true, order=7)
    public String getDatabaseCompatibleMode() {
        return this.databaseCompatibleMode;
    }

    private void init(ResultSet dbResult) {
        this.databaseCompatibleMode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datcompatibility");
        this.characterType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datctype");
    }

    public void setDatabaseCompatibleMode(String databaseCompatibleMode) {
        this.databaseCompatibleMode = databaseCompatibleMode;
    }

    public DBRProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void readDatabaseInfo(DBRProgressMonitor monitor) throws DBCException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getMetaContext().openSession(monitor, DBCExecutionPurpose.META, "Load database info");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT db.oid,db.* FROM sys_catalog.sys_database db WHERE datname=?");){
                    dbStat.setString(1, super.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.nextRow()) {
                            this.init((ResultSet)dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public Collection<PostgreLanguage> getLanguages(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.languageCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.languageCache.clearCache();
        return this;
    }

    public KingbaseSchema createSchemaImpl(@NotNull PostgreDatabase owner, @NotNull String name, @NotNull JDBCResultSet resultSet) throws SQLException {
        return new KingbaseSchema(owner, name, resultSet);
    }

    public KingbaseSchema createSchemaImpl(@NotNull PostgreDatabase owner, @NotNull String name, @Nullable PostgreRole postgreRole) {
        return new KingbaseSchema(owner, name, postgreRole);
    }

    public static class LanguageCache
    extends PostgreDatabase.PostgreDatabaseJDBCObjectCache<PostgreLanguage> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM sys_catalog.sys_language l \nORDER BY l.oid");
        }

        protected PostgreLanguage fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreLanguage(owner, (ResultSet)dbResult);
        }
    }

    public static class SchemaCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreSchema object, @Nullable String objectName) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("SELECT n.oid,n.*,d.description FROM sys_catalog.sys_namespace n\nLEFT OUTER JOIN sys_catalog.sys_description d ON d.objoid=n.oid AND d.objsubid=0 AND d.classoid='sys_namespace'::regclass\n");
            catalogQuery.append(" ORDER BY nspname");
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            return dbStat;
        }

        protected PostgreSchema fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"nspname");
            if (name == null) {
                return null;
            }
            return owner.createSchemaImpl(owner, name, resultSet);
        }
    }
}

