# Changelog

Notable changes to this crate will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## Unreleased - YYYY-MM-DD


## 0.3.0 - 2025-04-19

### Added
- Allow `Queue::exec_sync` on workloops.
  This is discouraged for performance reasons, but doesn't need to be
  outright disallowed.
- Added `DispatchRetained<T>`, which is a smart pointer which allows
  retain/release operations on dispatch objects, similar in spirit to
  `objc2::rc::Retained`. This mostly replaces `DispatchObject<T>`.
- Implement `Send` and `Sync` for dispatch objects.
- Added `DispatchData` helper functions.

### Changed
- Changed how memory management works to match other `objc2` crates. Instead
  of types like `DispatchGroup` holding the retain count internally, it is now
  done externally by `DispatchRetained<DispatchGroup>`.
- Converted `DispatchObject` to a trait.
- **BREAKING**: Renamed dispatch types to be prefixed with `Dispatch`
  (e.g. `DispatchGroup`, `DispatchQueue` and `DispatchOnce`).

  Some of the old names are kept (but deprecated) for easier migration.
- Handle memory management in `ffi` module automatically.
- Merged some high-level binding types with their `ffi` "_t"/"_s" counterparts.
  E.g. `dispatch_group_t`, `dispatch_group_s` and `DispatchGroup` are now one
  type.
- Move some functions to methods on the relevant Dispatch type.

### Removed
- **BREAKING**: Removed `TargetQueueError` and the error case in
  `DispatchObject::set_target_queue` (it now instead aborts on error,
  as that's what the underlying function does).
- Removed `ffi` methods that are actually macros:
  - `dispatch_wait`
  - `dispatch_notify`
  - `dispatch_cancel`
  - `dispatch_testcancel`

  Using these would have resulted in a linker error before.
* **BREAKING**: Removed direct access to most modules. Instead, types are
  publicly exported in the root.


## 0.2.0 - 2025-01-22

### Added
- Added support for `objc2` encodings.
- Added initial support for `block2`.
- Autogenerated `ffi` bindings, which adds:
  - `dispatch_data_applier_t`.
  - `dispatch_fd_t`.
  - `dispatch_io_close_flags_t`.
  - `dispatch_io_handler_t`.
  - `dispatch_io_interval_flags_t`.
  - `dispatch_io_s` / `dispatch_io_t`.
  - `dispatch_io_type_t`.
  - `DISPATCH_WALLTIME_NOW`.
  - `_dispatch_source_type_mach_recv`.
  - `_dispatch_source_type_proc`.
  - `_dispatch_source_type_signal`.
  - `_dispatch_source_type_vnode`.
  - `dispatch_allow_send_signals`.
  - `dispatch_apply`.
  - `dispatch_cancel`.
  - `dispatch_data_apply`.
  - `dispatch_get_current_queueDeprecated`.
  - `dispatch_get_main_queue`.
  - `dispatch_io_barrier`.
  - `dispatch_io_close`.
  - `dispatch_io_create`.
  - `dispatch_io_create_with_io`.
  - `dispatch_io_create_with_path`.
  - `dispatch_io_get_descriptor`.
  - `dispatch_io_read`.
  - `dispatch_io_set_high_water`.
  - `dispatch_io_set_interval`.
  - `dispatch_io_set_low_water`.
  - `dispatch_io_write`.
  - `dispatch_notify`.
  - `dispatch_read`.
  - `dispatch_testcancel`.
  - `dispatch_wait`.
  - `dispatch_write`.
- Added `#[must_use]` in bindings where the source uses it.
- Added `Queue::main` for fetching the main queue.
- Moved `run_on_main` and `MainThreadBound` from `objc2-foundation` to this
  crate.
- Added `Once`, a wrapper over `dispatch_once_f` which works similarly to
  `std::sync::Once`.
- Added `#![no_std]` support

### Changed
- Moved to the `objc2` project.
- **BREAKING**: Made `Queue::set_specific` take a key pointer instead of a `usize`.

### Fixed
- **BREAKING**: Use `extern "C-unwind"` instead of `extern "C"` in certain functions that required that.
- **BREAKING**: Use `isize` instead of `usize` in certain functions where that is more correct.
- **BREAKING**: An `F: 'static` bound was added to the following methods to make
                sure any referenced values passed to them are borrowed for long
                enough since they perform their `work` asynchronously (#689):
  - `Group::exec_async`
  - `Queue::exec_async`
  - `Queue::barrier_async`
  - `Queue::barrier_async_and_wait`


## 0.1.0 - 2022-10-02

Initial version.
