/* do not edit automatically generated by mc from Args.  */
/* Args.mod provide access to command line arguments.

Copyright (C) 2001-2024 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius@glam.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _Args_C

#include "GArgs.h"
#   include "GUnixArgs.h"
#   include "GASCII.h"

#   define MaxArgs 255
#   define MaxString 4096
typedef struct Args__T2_a Args__T2;

typedef Args__T2 *Args__T1;

typedef struct Args__T3_a Args__T3;

struct Args__T2_a { Args__T3 * array[MaxArgs+1]; };
struct Args__T3_a { char array[MaxString+1]; };
static Args__T1 Source;

/*
   GetArg - returns the nth argument from the command line.
            The success of the operation is returned.
*/

extern "C" bool Args_GetArg (char *a, unsigned int _a_high, unsigned int n);

/*
   Narg - returns the number of arguments available from
          command line.
*/

extern "C" unsigned int Args_Narg (void);


/*
   GetArg - returns the nth argument from the command line.
            The success of the operation is returned.
*/

extern "C" bool Args_GetArg (char *a, unsigned int _a_high, unsigned int n)
{
  int i;
  unsigned int High;
  unsigned int j;

  i = (int ) (n);
  j = 0;
  High = _a_high;
  if (i < (UnixArgs_GetArgC ()))
    {
      Source = static_cast<Args__T1> (UnixArgs_GetArgV ());
      while ((j < High) && ((*(*Source).array[i]).array[j] != ASCII_nul))
        {
          const_cast<char *>(a)[j] = (*(*Source).array[i]).array[j];
          j += 1;
        }
    }
  if (j <= High)
    {
      const_cast<char *>(a)[j] = ASCII_nul;
    }
  return i < (UnixArgs_GetArgC ());
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Narg - returns the number of arguments available from
          command line.
*/

extern "C" unsigned int Args_Narg (void)
{
  return UnixArgs_GetArgC ();
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_Args_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_Args_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
