// Code generated by 'ccgo -lmodernc.org/z/lib -o internal\example_windows_amd64.go -trace-translation-units C:\Users\0xjnml\go\src\modernc.org\z\tmp\cdb.json example.exe', DO NOT EDIT.

package main

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/z/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ types.Size_t

func main() { libc.Start(main1) }

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = uint16 /* <builtin>:15:24 */

type va_list = uintptr /* <builtin>:50:27 */

type ssize_t = int64 /* crtdefs.h:45:35 */

type rsize_t = size_t /* crtdefs.h:52:16 */

type intptr_t = int64 /* crtdefs.h:62:35 */

type uintptr_t = uint64 /* crtdefs.h:75:44 */

type wint_t = uint16   /* crtdefs.h:106:24 */
type wctype_t = uint16 /* crtdefs.h:107:24 */

type errno_t = int32 /* crtdefs.h:113:13 */

type time_t = int64 /* crtdefs.h:138:20 */

type threadlocaleinfostruct = struct {
	refcount      int32
	lc_codepage   uint32
	lc_collate_cp uint32
	lc_handle     [6]uint32
	lc_id         [6]LC_ID
	lc_category   [6]struct {
		locale    uintptr
		wlocale   uintptr
		refcount  uintptr
		wrefcount uintptr
	}
	lc_clike            int32
	mb_cur_max          int32
	lconv_intl_refcount uintptr
	lconv_num_refcount  uintptr
	lconv_mon_refcount  uintptr
	lconv               uintptr
	ctype1_refcount     uintptr
	ctype1              uintptr
	pctype              uintptr
	pclmap              uintptr
	pcumap              uintptr
	lc_time_curr        uintptr
} /* crtdefs.h:422:1 */

type pthreadlocinfo = uintptr /* crtdefs.h:424:39 */
type pthreadmbcinfo = uintptr /* crtdefs.h:425:36 */

type localeinfo_struct = struct {
	locinfo pthreadlocinfo
	mbcinfo pthreadmbcinfo
} /* crtdefs.h:428:9 */

type _locale_tstruct = localeinfo_struct /* crtdefs.h:431:3 */
type _locale_t = uintptr                 /* crtdefs.h:431:19 */

type tagLC_ID = struct {
	wLanguage uint16
	wCountry  uint16
	wCodePage uint16
} /* crtdefs.h:422:1 */

type LC_ID = tagLC_ID  /* crtdefs.h:439:3 */
type LPLC_ID = uintptr /* crtdefs.h:439:9 */

type threadlocinfo = threadlocaleinfostruct /* crtdefs.h:468:3 */

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Any one of these symbols __need_* means that GNU libc
//    wants us just to define one data type.  So don't define
//    the symbols that indicate this file's entire job has been done.
// snaroff@next.com says the NeXT needs this.
// Irix 5.1 needs this.

// In 4.3bsd-net2, machine/ansi.h defines these symbols, which are
//    defined if the corresponding type is *not* defined.
//    FreeBSD-2.1 defines _MACHINE_ANSI_H_ instead of _ANSI_H_

// Sequent's header files use _PTRDIFF_T_ in some conflicting way.
//    Just ignore it.

// On VxWorks, <type/vxTypesBase.h> may have defined macros like
//    _TYPE_size_t which will typedef size_t.  fixincludes patched the
//    vxTypesBase.h so that this macro is only defined if _GCC_SIZE_T is
//    not defined, and so that defining this macro defines _GCC_SIZE_T.
//    If we find that the macros are still defined at this point, we must
//    invoke them so that the type is defined as expected.

// In case nobody has defined these types, but we aren't running under
//    GCC 2.00, make sure that __PTRDIFF_TYPE__, __SIZE_TYPE__, and
//    __WCHAR_TYPE__ have reasonable values.  This can happen if the
//    parts of GCC is compiled by an older compiler, that actually
//    include gstddef.h, such as collect2.

// Signed type of difference of two pointers.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// If this symbol has done its job, get rid of it.

// Unsigned type of `sizeof' something.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

// Wide character type.
//    Locale-writers should change this as necessary to
//    be big enough to hold unique values not between 0 and 127,
//    and not (wchar_t) -1, for each defined multibyte character.

// Define this type if we are doing the whole job,
//    or if we want this type in particular.

//  In 4.3bsd-net2, leave these undefined to indicate that size_t, etc.
//     are already defined.
//  BSD/OS 3.1 and FreeBSD [23].x require the MACHINE_ANSI_H check here.

// A null pointer constant.

// Offset of member MEMBER in a struct of type TYPE.

// Type whose alignment is supported in every context and is at least
//    as great as that of any standard type not using alignment
//    specifiers.
type max_align_t = struct {
	__max_align_ll int64
	__max_align_ld float64
} /* stddef.h:426:3 */

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>
type z_size_t = size_t /* zconf.h:248:21 */

// Maximum value for memLevel in deflateInit2

// Maximum value for windowBits in deflateInit2 and inflateInit2.
// WARNING: reducing MAX_WBITS makes minigzip unable to extract .gz files
// created by gzip. (Files created by minigzip can still be extracted by
// gzip.)

// The memory requirements for deflate are (in bytes):
//             (1 << (windowBits+2)) +  (1 << (memLevel+9))
//  that is: 128K for windowBits=15  +  128K for memLevel = 8  (default values)
//  plus a few kilobytes for small objects. For example, if you want to reduce
//  the default memory requirements from 256K to 128K, compile with
//      make CFLAGS="-O -DMAX_WBITS=14 -DMAX_MEM_LEVEL=7"
//  Of course this will generally degrade compression (there's no free lunch).
//
//    The memory requirements for inflate are (in bytes) 1 << windowBits
//  that is, 32K for windowBits=15 (default value) plus about 7 kilobytes
//  for small objects.

// Type declarations

// The following definitions for FAR are needed only for MSDOS mixed
// model programming (small or medium model with some far allocations).
// This was tested only with MSC; for other MSDOS compilers you may have
// to define NO_MEMCPY in zutil.h.  If you don't need the mixed model,
// just define FAR to be empty.

// If building or using zlib as a DLL, define ZLIB_DLL.
// This is not mandatory, but it offers a little performance increase.
// If building or using zlib with the WINAPI/WINAPIV calling convention,
// define ZLIB_WINAPI.
// Caution: the standard ZLIB1.DLL is NOT compiled using ZLIB_WINAPI.

type Byte = uint8   /* zconf.h:391:24 */ // 8 bits
type uInt = uint32  /* zconf.h:393:24 */ // 16 bits or more
type uLong = uint32 /* zconf.h:394:24 */ // 32 bits or more

type Bytef = Byte   /* zconf.h:400:22 */
type charf = int8   /* zconf.h:402:19 */
type intf = int32   /* zconf.h:403:19 */
type uIntf = uInt   /* zconf.h:404:19 */
type uLongf = uLong /* zconf.h:405:19 */

type voidpc = uintptr /* zconf.h:408:23 */
type voidpf = uintptr /* zconf.h:409:23 */
type voidp = uintptr  /* zconf.h:410:23 */

// Copyright (C) 1992-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

// Use "..." so that we find syslimits.h only in this same directory.
// syslimits.h stands for the system's own limits.h file.
//    If we can use it ok unmodified, then we install this text.
//    If fixincludes fixes it, then the fixed version is installed
//    instead of this text.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// File system limits
//
// NOTE: Apparently the actual size of PATH_MAX is 260, but a space is
//       required for the NUL. TODO: Test?
// NOTE: PATH_MAX is the POSIX equivalent for Microsoft's MAX_PATH; the two
//       are semantically identical, with a limit of 259 characters for the
//       path name, plus one for a terminating NUL, for a total of 260.

// Copyright (C) 1991-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// Number of bits in a `char'.

// Maximum length of a multibyte character.

// Minimum and maximum values a `signed char' can hold.

// Maximum value an `unsigned char' can hold.  (Minimum is 0).

// Minimum and maximum values a `char' can hold.

// Minimum and maximum values a `signed short int' can hold.

// Maximum value an `unsigned short int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed int' can hold.

// Maximum value an `unsigned int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long int' can hold.
//    (Same as `int').

// Maximum value an `unsigned long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// Minimum and maximum values a `signed long long int' can hold.

// Maximum value an `unsigned long long int' can hold.  (Minimum is 0).

// This administrivia gets added to the end of limits.h
//    if the system has its own version of limits.h.

type z_crc_t = uint32 /* zconf.h:429:17 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

type _ino_t = uint16 /* types.h:43:24 */
type ino_t = uint16  /* types.h:45:24 */

type _dev_t = uint32 /* types.h:51:22 */
type dev_t = uint32  /* types.h:53:22 */

type _pid_t = int64 /* types.h:63:17 */

type pid_t = _pid_t /* types.h:68:16 */

type _mode_t = uint16 /* types.h:74:24 */

type mode_t = _mode_t /* types.h:77:17 */

type _off_t = int32  /* _mingw_off_t.h:5:16 */
type off32_t = int32 /* _mingw_off_t.h:7:16 */

type _off64_t = int64 /* _mingw_off_t.h:13:39 */
type off64_t = int64  /* _mingw_off_t.h:15:39 */

type off_t = off64_t /* _mingw_off_t.h:24:17 */

type useconds_t = uint32 /* types.h:84:22 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int32
	_       [4]byte
} /* types.h:89:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int32
		_       [4]byte
	}
} /* types.h:94:1 */

type _sigset_t = uint64 /* types.h:104:28 */

// Copyright (C) 1989, 1997, 1998, 1999, 2000 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GCC; see the file COPYING.  If not, write to
// the Free Software Foundation, 51 Franklin Street, Fifth Floor,
// Boston, MA 02110-1301, USA.

// As a special exception, if you include this header file into source
//    files compiled by GCC, this header file does not by itself cause
//    the resulting executable to be covered by the GNU General Public
//    License.  This exception does not however invalidate any other
//    reasons why the executable file might be covered by the GNU General
//    Public License.

// ISO C Standard:  7.15  Variable arguments  <stdarg.h>

// Define __gnuc_va_list.

// Define the standard macros for the user,
//    if this invocation was from the user program.

// Define va_list, if desired, from __gnuc_va_list.
// We deliberately do not define va_list when called from
//    stdio.h, because ANSI C says that stdio.h is not supposed to define
//    va_list.  stdio.h needs to have access to that data type,
//    but must not use that name.  It should use the name __gnuc_va_list,
//    which is safe because it is reserved for the implementation.

// The macro _VA_LIST_ is the same thing used by this file in Ultrix.
//    But on BSD NET2 we must not test or define or undef it.
//    (Note that the comments in NET 2's ansi.h
//    are incorrect for _VA_LIST_--see stdio.h!)
// The macro _VA_LIST_DEFINED is used in Windows NT 3.5

// include mingw stuff
// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.15  Variable arguments  <stdarg.h>

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// Copyright (C) 1989-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// ISO C Standard:  7.17  Common definitions  <stddef.h>

// a little trick to accommodate both "#define _LARGEFILE64_SOURCE" and
// "#define _LARGEFILE64_SOURCE 1" as requesting 64-bit operations, (even
// though the former does not conform to the LFS document), but considering
// both "#undef _LARGEFILE64_SOURCE" and "#define _LARGEFILE64_SOURCE 0" as
// equivalently requesting no 64-bit operations

// MVS linker does not support external names larger than 8 bytes

//
//     The 'zlib' compression library provides in-memory compression and
//   decompression functions, including integrity checks of the uncompressed data.
//   This version of the library supports only one compression method (deflation)
//   but other algorithms will be added later and will have the same stream
//   interface.
//
//     Compression can be done in a single step if the buffers are large enough,
//   or can be done by repeated calls of the compression function.  In the latter
//   case, the application must provide more input and/or consume the output
//   (providing more output space) before each call.
//
//     The compressed data format used by default by the in-memory functions is
//   the zlib format, which is a zlib wrapper documented in RFC 1950, wrapped
//   around a deflate stream, which is itself documented in RFC 1951.
//
//     The library also supports reading and writing files in gzip (.gz) format
//   with an interface similar to that of stdio using the functions that start
//   with "gz".  The gzip format is different from the zlib format.  gzip is a
//   gzip wrapper, documented in RFC 1952, wrapped around a deflate stream.
//
//     This library can optionally read and write gzip and raw deflate streams in
//   memory as well.
//
//     The zlib format was designed to be compact and fast for use in memory
//   and on communications channels.  The gzip format was designed for single-
//   file compression on file systems, has a larger header than zlib to maintain
//   directory information, and uses a different, slower check method than zlib.
//
//     The library does not install any signal handler.  The decoder checks
//   the consistency of the compressed data, so the library should never crash
//   even in the case of corrupted input.

type alloc_func = uintptr /* zlib.h:81:16 */
type free_func = uintptr  /* zlib.h:82:16 */

type z_stream_s = struct {
	next_in   uintptr
	avail_in  uInt
	total_in  uLong
	next_out  uintptr
	avail_out uInt
	total_out uLong
	msg       uintptr
	state     uintptr
	zalloc    alloc_func
	zfree     free_func
	opaque    voidpf
	data_type int32
	adler     uLong
	reserved  uLong
	_         [4]byte
} /* zlib.h:86:9 */

type z_stream = z_stream_s /* zlib.h:106:3 */

type z_streamp = uintptr /* zlib.h:108:22 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header_s = struct {
	text      int32
	time      uLong
	xflags    int32
	os        int32
	extra     uintptr
	extra_len uInt
	extra_max uInt
	name      uintptr
	name_max  uInt
	_         [4]byte
	comment   uintptr
	comm_max  uInt
	hcrc      int32
	done      int32
	_         [4]byte
} /* zlib.h:114:9 */

//
//      gzip header information passed to and from zlib routines.  See RFC 1952
//   for more details on the meanings of these fields.
type gz_header = gz_header_s /* zlib.h:129:3 */

type gz_headerp = uintptr /* zlib.h:131:23 */
//
//      inflateGetHeader() requests that gzip header information be stored in the
//    provided gz_header structure.  inflateGetHeader() may be called after
//    inflateInit2() or inflateReset(), and before the first call of inflate().
//    As inflate() processes the gzip stream, head->done is zero until the header
//    is completed, at which time head->done is set to one.  If a zlib stream is
//    being decoded, then head->done is set to -1 to indicate that there will be
//    no gzip header information forthcoming.  Note that Z_BLOCK or Z_TREES can be
//    used to force inflate() to return immediately after header processing is
//    complete and before any actual data is decompressed.
//
//      The text, time, xflags, and os fields are filled in with the gzip header
//    contents.  hcrc is set to true if there is a header CRC.  (The header CRC
//    was valid if done is set to one.) If extra is not Z_NULL, then extra_max
//    contains the maximum number of bytes to write to extra.  Once done is true,
//    extra_len contains the actual extra field length, and extra contains the
//    extra field, or that field truncated if extra_max is less than extra_len.
//    If name is not Z_NULL, then up to name_max characters are written there,
//    terminated with a zero unless the length is greater than name_max.  If
//    comment is not Z_NULL, then up to comm_max characters are written there,
//    terminated with a zero unless the length is greater than comm_max.  When any
//    of extra, name, or comment are not Z_NULL and the respective field is not
//    present in the header, then that field is set to Z_NULL to signal its
//    absence.  This allows the use of deflateSetHeader() with the returned
//    structure to duplicate the header.  However if those fields are set to
//    allocated memory, then the application will need to save those pointers
//    elsewhere so that they can be eventually freed.
//
//      If inflateGetHeader is not used, then the header information is simply
//    discarded.  The header is always checked for validity, including the header
//    CRC if present.  inflateReset() will reset the process to discard the header
//    information.  The application would need to call inflateGetHeader() again to
//    retrieve the header from the next gzip stream.
//
//      inflateGetHeader returns Z_OK if success, or Z_STREAM_ERROR if the source
//    stream state was inconsistent.

//
// ZEXTERN int ZEXPORT inflateBackInit OF((z_streamp strm, int windowBits,
//                                         unsigned char FAR *window));
//
//      Initialize the internal stream state for decompression using inflateBack()
//    calls.  The fields zalloc, zfree and opaque in strm must be initialized
//    before the call.  If zalloc and zfree are Z_NULL, then the default library-
//    derived memory allocation routines are used.  windowBits is the base two
//    logarithm of the window size, in the range 8..15.  window is a caller
//    supplied buffer of that size.  Except for special applications where it is
//    assured that deflate was used with small window sizes, windowBits must be 15
//    and a 32K byte window must be supplied to be able to decompress general
//    deflate streams.
//
//      See inflateBack() for the usage of these routines.
//
//      inflateBackInit will return Z_OK on success, Z_STREAM_ERROR if any of
//    the parameters are invalid, Z_MEM_ERROR if the internal state could not be
//    allocated, or Z_VERSION_ERROR if the version of the library does not match
//    the version of the header file.

type in_func = uintptr  /* zlib.h:1092:18 */
type out_func = uintptr /* zlib.h:1094:13 */
//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile_s = struct {
	have uint32
	_    [4]byte
	next uintptr
	pos  int32
	_    [4]byte
} /* zlib.h:1300:9 */

//
//      Same as uncompress, except that sourceLen is a pointer, where the
//    length of the source is *sourceLen.  On return, *sourceLen is the number of
//    source bytes consumed.

// gzip file access functions

//
//      This library supports reading and writing files in gzip (.gz) format with
//    an interface similar to that of stdio, using the functions that start with
//    "gz".  The gzip format is different from the zlib format.  gzip is a gzip
//    wrapper, documented in RFC 1952, wrapped around a deflate stream.

type gzFile = uintptr /* zlib.h:1300:25 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Undefine __mingw_<printf> macros.

type _iobuf = struct {
	_ptr      uintptr
	_cnt      int32
	_         [4]byte
	_base     uintptr
	_flag     int32
	_file     int32
	_charbuf  int32
	_bufsiz   int32
	_tmpfname uintptr
} /* stdio.h:26:3 */

type FILE = _iobuf /* stdio.h:36:25 */

type fpos_t = int64 /* stdio.h:104:37 */

func vsnwprintf(tls *libc.TLS, s uintptr, n size_t, format uintptr, arg va_list) int32 { /* stdio.h:1209:15: */
	return libc.X_vsnwprintf(tls, s, n, format, arg)

}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

func vswprintf(tls *libc.TLS, __stream uintptr, __count size_t, __format uintptr, __local_argv uintptr) int32 { /* swprintf.inl:27:5: */
	return vsnwprintf(tls, __stream, __count, __format, __local_argv)
}

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Copyright (C) 1992-2018 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 3, or (at your option) any later
// version.
//
// GCC is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.
//
// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
// <http://www.gnu.org/licenses/>.

// This administrivia gets added to the beginning of limits.h
//    if the system has its own version of limits.h.

// We use _GCC_LIMITS_H_ because we want this not to match
//    any macros that the system's limits.h uses for its own purposes.

type _onexit_t = uintptr /* stdlib.h:49:15 */

type _div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:59:11 */

type div_t = _div_t /* stdlib.h:62:5 */

type _ldiv_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:64:11 */

type ldiv_t = _ldiv_t /* stdlib.h:67:5 */

type _LDOUBLE = struct{ ld [10]uint8 } /* stdlib.h:76:5 */

type _CRT_DOUBLE = struct{ x float64 } /* stdlib.h:83:5 */

type _CRT_FLOAT = struct{ f float32 } /* stdlib.h:87:5 */

type _LONGDOUBLE = struct{ x float64 } /* stdlib.h:94:5 */

type _LDBL12 = struct{ ld12 [12]uint8 } /* stdlib.h:101:5 */

type _purecall_handler = uintptr /* stdlib.h:142:16 */

type _invalid_parameter_handler = uintptr /* stdlib.h:147:16 */

type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:699:61 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _heapinfo = struct {
	_pentry  uintptr
	_size    size_t
	_useflag int32
	_        [4]byte
} /* malloc.h:46:11 */

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// *
// This file has no copyright assigned and is placed in the Public Domain.
// This file is part of the mingw-w64 runtime package.
// No warranty is given; refer to the file DISCLAIMER.PD within this package.

// Return codes for _heapwalk()

// Values for _heapinfo.useflag

// The structure used to walk through the heap with _heapwalk.
type _HEAPINFO = _heapinfo /* malloc.h:50:5 */

var hello = *(*[14]int8)(unsafe.Pointer(ts /* "hello, hello!" */)) /* example.c:29:21 */
// "hello world" would be more standard, but the repeated "hello"
// stresses the compression code better, sorry...

var dictionary = *(*[6]int8)(unsafe.Pointer(ts + 14 /* "hello" */)) /* example.c:34:19 */
var dictId uLong                                                    /* example.c:35:14: */

var zalloc alloc_func = uintptr(0) /* example.c:77:19 */
var zfree free_func = uintptr(0)   /* example.c:78:18 */

// ===========================================================================
// Test compress() and uncompress()
func test_compress(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:88:6: */
	bp := tls.Alloc(48)
	defer tls.Free(48)
	*(*uLong)(unsafe.Pointer(bp + 40)) = comprLen
	*(*uLong)(unsafe.Pointer(bp + 44)) = uncomprLen

	var err int32
	var len uLong = (uLong(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uLong(1))

	err = z.Xcompress(tls, compr, bp+40 /* &comprLen */, uintptr(uintptr(unsafe.Pointer(&hello))), len)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+34 /* "compress" */, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	err = z.Xuncompress(tls, uncompr, bp+44 /* &uncomprLen */, compr, *(*uLong)(unsafe.Pointer(bp + 40 /* comprLen */)))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+51 /* "uncompress" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+62 /* "bad uncompress\n" */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+78 /* "uncompress(): %s..." */, libc.VaList(bp+32, uncompr))
	}
}

// ===========================================================================
// Test read/write of .gz files
func test_gzio(tls *libc.TLS, fname uintptr, uncompr uintptr, uncomprLen uLong) { /* example.c:114:6: */
	bp := tls.Alloc(84)
	defer tls.Free(84)

	// var err int32 at bp+80, 4

	var len int32 = (int32(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + 1)
	var file gzFile
	var pos int32

	file = z.Xgzopen(tls, fname, ts+96 /* "wb" */)
	if file == (uintptr(0)) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+99 /* "gzopen error\n" */, 0)
		libc.Xexit(tls, 1)
	}
	z.Xgzputc(tls, file, 'h')
	if z.Xgzputs(tls, file, ts+113 /* "ello" */) != 4 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+118 /* "gzputs err: %s\n" */, libc.VaList(bp, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if z.Xgzprintf(tls, file, ts+134 /* ", %s!" */, libc.VaList(bp+8, ts+14 /* "hello" */)) != 8 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+140 /* "gzprintf err: %s..." */, libc.VaList(bp+16, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	z.Xgzseek(tls, file, 1, 1) // add one zero byte
	z.Xgzclose(tls, file)

	file = z.Xgzopen(tls, fname, ts+158 /* "rb" */)
	if file == (uintptr(0)) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+99 /* "gzopen error\n" */, 0)
		libc.Xexit(tls, 1)
	}
	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	if z.Xgzread(tls, file, uncompr, uint32(uncomprLen)) != len {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+161 /* "gzread err: %s\n" */, libc.VaList(bp+24, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+177 /* "bad gzread: %s\n" */, libc.VaList(bp+32, uncompr))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+193 /* "gzread(): %s\n" */, libc.VaList(bp+40, uncompr))
	}

	pos = z.Xgzseek(tls, file, -8, 1)
	if (pos != 6) || (z.Xgztell(tls, file) != pos) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+207, /* "gzseek error, po..." */
			libc.VaList(bp+48, pos, z.Xgztell(tls, file)))
		libc.Xexit(tls, 1)
	}

	if (func() int32 {
		if (*gzFile_s)(unsafe.Pointer(file)).have != 0 {
			return int32(func() uint8 {
				(*gzFile_s)(unsafe.Pointer(file)).have--
				(*gzFile_s)(unsafe.Pointer(file)).pos++
				return *(*uint8)(unsafe.Pointer(libc.PostIncUintptr(&((*gzFile_s)(unsafe.Pointer(file)).next), 1)))
			}())
		}
		return z.Xgzgetc(tls, file)
	}()) != ' ' {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+242 /* "gzgetc error\n" */, 0)
		libc.Xexit(tls, 1)
	}

	if z.Xgzungetc(tls, ' ', file) != ' ' {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+256 /* "gzungetc error\n" */, 0)
		libc.Xexit(tls, 1)
	}

	z.Xgzgets(tls, file, uncompr, int32(uncomprLen))
	if libc.Xstrlen(tls, uncompr) != uint64(7) { // " hello!"
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+272 /* "gzgets err after..." */, libc.VaList(bp+64, z.Xgzerror(tls, file, bp+80 /* &err */)))
		libc.Xexit(tls, 1)
	}
	if libc.Xstrcmp(tls, uncompr, (uintptr(unsafe.Pointer(&hello))+uintptr(6))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+301 /* "bad gzgets after..." */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+326 /* "gzgets() after g..." */, libc.VaList(bp+72, uncompr))
	}

	z.Xgzclose(tls, file)
}

// ===========================================================================
// Test deflate() with small buffers
func test_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:200:6: */
	bp := tls.Alloc(152)
	defer tls.Free(152)

	// var c_stream z_stream at bp+64, 88
	// compression stream
	var err int32
	var len uLong = (uLong(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uLong(1))

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64 /* &c_stream */, -1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr

	for ((*z_stream)(unsafe.Pointer(bp+64 /* &c_stream */)).total_in != len) && ((*z_stream)(unsafe.Pointer(bp+64 /* &c_stream */)).total_out < comprLen) {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = libc.AssignPtrUint32(bp+64 /* &c_stream */ +24 /* &.avail_out */, uInt(1)) // force small buffers
		err = z.Xdeflate(tls, bp+64 /* &c_stream */, 0)
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	// Finish the stream, still forcing small buffers:
	for {
		(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(1)
		err = z.Xdeflate(tls, bp+64 /* &c_stream */, 4)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XdeflateEnd(tls, bp+64 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with small buffers
func test_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:238:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(0)
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	for ((*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out < uncomprLen) && ((*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_in < comprLen) {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = libc.AssignPtrUint32(bp+56 /* &d_stream */ +24 /* &.avail_out */, uInt(1)) // force small buffers
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+403 /* "inflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+422 /* "bad inflate\n" */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+435 /* "inflate(): %s\n" */, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Test deflate() with large buffers and dynamic change of compression level
func test_large_deflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:279:6: */
	bp := tls.Alloc(168)
	defer tls.Free(168)

	// var c_stream z_stream at bp+80, 88
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+80 /* &c_stream */, 1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_out = uInt(comprLen)

	// At this point, uncompr is still mostly zeroes, so it should compress
	// very well:
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+80 /* &c_stream */)).avail_in != uInt(0) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+450 /* "deflate not gree..." */, 0)
		libc.Xexit(tls, 1)
	}

	// Feed in already compressed data and switch to no compression:
	z.XdeflateParams(tls, bp+80 /* &c_stream */, 0, 0)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = (uInt(comprLen) / uInt(2))
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	// Switch back to compressing mode:
	z.XdeflateParams(tls, bp+80 /* &c_stream */, 9, 1)
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).next_in = uncompr
	(*z_stream)(unsafe.Pointer(bp + 80 /* &c_stream */)).avail_in = uInt(uncomprLen)
	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xdeflate(tls, bp+80 /* &c_stream */, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+470 /* "deflate should r..." */, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+80 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+64, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with large buffers
func test_large_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:334:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	for {
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr // discard the output
		(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+506 /* "large inflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out != ((uLong(2) * uncomprLen) + (comprLen / uLong(2))) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+520 /* "bad large inflat..." */, libc.VaList(bp+48, (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).total_out))
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+544 /* "large_inflate():..." */, 0)
	}
}

// ===========================================================================
// Test deflate() with full flush
func test_flush(tls *libc.TLS, compr uintptr, comprLen uintptr) { /* example.c:375:6: */
	bp := tls.Alloc(152)
	defer tls.Free(152)

	// var c_stream z_stream at bp+64, 88
	// compression stream
	var err int32
	var len uInt = (uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1))

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+64 /* &c_stream */, -1, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = uInt(3)
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_out = uInt(*(*uLong)(unsafe.Pointer(comprLen)))
	err = z.Xdeflate(tls, bp+64 /* &c_stream */, 3)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+372 /* "deflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*Byte)(unsafe.Pointer(compr + 3))++ // force an error in first compressed block
	(*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).avail_in = (len - uInt(3))

	err = z.Xdeflate(tls, bp+64 /* &c_stream */, 4)
	if err != 1 {
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+372 /* "deflate" */, err))
				libc.Xexit(tls, 1)
			}
		}

	}
	err = z.XdeflateEnd(tls, bp+64 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	*(*uLong)(unsafe.Pointer(comprLen)) = (*z_stream)(unsafe.Pointer(bp + 64 /* &c_stream */)).total_out
}

// ===========================================================================
// Test inflateSync()
func test_sync(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:413:6: */
	bp := tls.Alloc(160)
	defer tls.Free(160)

	var err int32
	// var d_stream z_stream at bp+72, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = uInt(2) // just read the zlib header

	err = z.XinflateInit_(tls, bp+72 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_out = uInt(uncomprLen)

	err = z.Xinflate(tls, bp+72 /* &d_stream */, 0)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+403 /* "inflate" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 72 /* &d_stream */)).avail_in = (uInt(comprLen) - uInt(2)) // read all compressed data
	err = z.XinflateSync(tls, bp+72 /* &d_stream */)                                           /* but skip the damaged part */
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+565 /* "inflateSync" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.Xinflate(tls, bp+72 /* &d_stream */, 4)
	if err != (-3) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+577 /* "inflate should r..." */, 0)
		// Because of incorrect adler32
		libc.Xexit(tls, 1)
	}
	err = z.XinflateEnd(tls, bp+72 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+48, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	libc.Xprintf(tls, ts+611 /* "after inflateSyn..." */, libc.VaList(bp+64, uncompr))
}

// ===========================================================================
// Test deflate() with preset dictionary
func test_dict_deflate(tls *libc.TLS, compr uintptr, comprLen uLong) { /* example.c:457:6: */
	bp := tls.Alloc(136)
	defer tls.Free(136)

	// var c_stream z_stream at bp+48, 88
	// compression stream
	var err int32

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).opaque = uintptr(0)

	err = z.XdeflateInit_(tls, bp+48 /* &c_stream */, 9, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+360 /* "deflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	err = z.XdeflateSetDictionary(tls, bp+48, /* &c_stream */
		uintptr(uintptr(unsafe.Pointer(&dictionary))), uint32(int32(unsafe.Sizeof(dictionary))))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+639 /* "deflateSetDictio..." */, err))
			libc.Xexit(tls, 1)
		}
	}

	dictId = (*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).adler
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_out = compr
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_out = uInt(comprLen)

	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).next_in = uintptr(uintptr(unsafe.Pointer(&hello)))
	(*z_stream)(unsafe.Pointer(bp + 48 /* &c_stream */)).avail_in = (uInt(libc.Xstrlen(tls, uintptr(unsafe.Pointer(&hello)))) + uInt(1))

	err = z.Xdeflate(tls, bp+48 /* &c_stream */, 4)
	if err != 1 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+470 /* "deflate should r..." */, 0)
		libc.Xexit(tls, 1)
	}
	err = z.XdeflateEnd(tls, bp+48 /* &c_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+380 /* "deflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

}

// ===========================================================================
// Test inflate() with a preset dictionary
func test_dict_inflate(tls *libc.TLS, compr uintptr, comprLen uLong, uncompr uintptr, uncomprLen uLong) { /* example.c:494:6: */
	bp := tls.Alloc(144)
	defer tls.Free(144)

	var err int32
	// var d_stream z_stream at bp+56, 88
	// decompression stream

	libc.Xstrcpy(tls, uncompr, ts+43 /* "garbage" */)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zalloc = zalloc
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).zfree = zfree
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).opaque = uintptr(0)

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_in = compr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_in = uInt(comprLen)

	err = z.XinflateInit_(tls, bp+56 /* &d_stream */, ts+353 /* "1.2.11" */, int32(unsafe.Sizeof(z_stream{})))
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp, ts+391 /* "inflateInit" */, err))
			libc.Xexit(tls, 1)
		}
	}

	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).next_out = uncompr
	(*z_stream)(unsafe.Pointer(bp + 56 /* &d_stream */)).avail_out = uInt(uncomprLen)

	for {
		err = z.Xinflate(tls, bp+56 /* &d_stream */, 0)
		if err == 1 {
			break
		}
		if err == 2 {
			if (*z_stream)(unsafe.Pointer(bp+56 /* &d_stream */)).adler != dictId {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+660 /* "unexpected dicti..." */, 0)
				libc.Xexit(tls, 1)
			}
			err = z.XinflateSetDictionary(tls, bp+56 /* &d_stream */, uintptr(uintptr(unsafe.Pointer(&dictionary))),
				uint32(int32(unsafe.Sizeof(dictionary))))
		}
		{
			if err != 0 {
				libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+16, ts+682 /* "inflate with dic..." */, err))
				libc.Xexit(tls, 1)
			}
		}

	}

	err = z.XinflateEnd(tls, bp+56 /* &d_stream */)
	{
		if err != 0 {
			libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+20 /* "%s error: %d\n" */, libc.VaList(bp+32, ts+411 /* "inflateEnd" */, err))
			libc.Xexit(tls, 1)
		}
	}

	if libc.Xstrcmp(tls, uncompr, uintptr(unsafe.Pointer(&hello))) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+700 /* "bad inflate with..." */, 0)
		libc.Xexit(tls, 1)
	} else {
		libc.Xprintf(tls, ts+723 /* "inflate with dic..." */, libc.VaList(bp+48, uncompr))
	}
}

// ===========================================================================
// Usage:  example [output.gz  [input.gz]]

func main1(tls *libc.TLS, argc int32, argv uintptr) int32 { /* example.c:545:5: */
	bp := tls.Alloc(28)
	defer tls.Free(28)

	var compr uintptr
	var uncompr uintptr
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = (uint32(uint64(10000) * uint64(unsafe.Sizeof(int32(0))))) // don't overflow on MSDOS
	var uncomprLen uLong = *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */))

	if int32(*(*int8)(unsafe.Pointer(z.XzlibVersion(tls)))) != int32(*(*int8)(unsafe.Pointer(myVersion))) {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+752 /* "incompatible zli..." */, 0)
		libc.Xexit(tls, 1)

	} else if libc.Xstrcmp(tls, z.XzlibVersion(tls), ts+353 /* "1.2.11" */) != 0 {
		libc.Xfprintf(tls, libc.X__acrt_iob_func(tls, uint32(2)), ts+779 /* "warning: differe..." */, 0)
	}

	libc.Xprintf(tls, ts+812, /* "zlib version %s ..." */
		libc.VaList(bp, ts+353 /* "1.2.11" */, 0x12b0, z.XzlibCompileFlags(tls)))

	compr = libc.Xcalloc(tls, uint64(uInt(*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))), uint64(1))
	uncompr = libc.Xcalloc(tls, uint64(uInt(uncomprLen)), uint64(1))
	// compr and uncompr are cleared to avoid reading uninitialized
	// data and to ensure that uncompr compresses well.
	if (compr == uintptr(0)) || (uncompr == uintptr(0)) {
		libc.Xprintf(tls, ts+861 /* "out of memory\n" */, 0)
		libc.Xexit(tls, 1)
	}

	test_compress(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_gzio(tls, func() uintptr {
		if argc > 1 {
			return *(*uintptr)(unsafe.Pointer(argv + 1*8))
		}
		return ts + 876 /* "foo.gz" */
	}(),
		uncompr, uncomprLen)

	test_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_large_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	test_large_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	test_flush(tls, compr, bp+24 /* &comprLen */)
	test_sync(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)
	*(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)) = uncomprLen

	test_dict_deflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)))
	test_dict_inflate(tls, compr, *(*uLong)(unsafe.Pointer(bp + 24 /* comprLen */)), uncompr, uncomprLen)

	libc.Xfree(tls, compr)
	libc.Xfree(tls, uncompr)

	return 0
}

var myVersion uintptr = ts + 353 /* "1.2.11" */ /* example.c:552:22 */

var ts1 = "hello, hello!\x00hello\x00%s error: %d\n\x00compress\x00garbage\x00uncompress\x00bad uncompress\n\x00uncompress(): %s\n\x00wb\x00gzopen error\n\x00ello\x00gzputs err: %s\n\x00, %s!\x00gzprintf err: %s\n\x00rb\x00gzread err: %s\n\x00bad gzread: %s\n\x00gzread(): %s\n\x00gzseek error, pos=%ld, gztell=%ld\n\x00gzgetc error\n\x00gzungetc error\n\x00gzgets err after gzseek: %s\n\x00bad gzgets after gzseek\n\x00gzgets() after gzseek: %s\n\x001.2.11\x00deflateInit\x00deflate\x00deflateEnd\x00inflateInit\x00inflate\x00inflateEnd\x00bad inflate\n\x00inflate(): %s\n\x00deflate not greedy\n\x00deflate should report Z_STREAM_END\n\x00large inflate\x00bad large inflate: %ld\n\x00large_inflate(): OK\n\x00inflateSync\x00inflate should report DATA_ERROR\n\x00after inflateSync(): hel%s\n\x00deflateSetDictionary\x00unexpected dictionary\x00inflate with dict\x00bad inflate with dict\n\x00inflate with dictionary: %s\n\x00incompatible zlib version\n\x00warning: different zlib version\n\x00zlib version %s = 0x%04x, compile flags = 0x%lx\n\x00out of memory\n\x00foo.gz\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
