/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jivesoftware.smack.AbstractXMPPConnection;

public class AsyncButOrdered<K> {
    private final Map<K, Queue<Runnable>> pendingRunnables = new WeakHashMap<K, Queue<Runnable>>();
    private final Map<K, Handler> threadActiveMap = new HashMap<K, Handler>();
    private final Executor executor;

    public AsyncButOrdered() {
        this(null);
    }

    public AsyncButOrdered(Executor executor) {
        this.executor = executor;
    }

    private void scheduleHandler(Handler handler) {
        if (this.executor == null) {
            AbstractXMPPConnection.asyncGo(handler);
        } else {
            this.executor.execute(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAsyncButOrdered(K key, Runnable runnable) {
        Queue<Runnable> keyQueue;
        Map<K, Queue<Runnable>> map = this.pendingRunnables;
        synchronized (map) {
            keyQueue = this.pendingRunnables.get(key);
            if (keyQueue == null) {
                keyQueue = new ConcurrentLinkedQueue<Runnable>();
                this.pendingRunnables.put(key, keyQueue);
            }
        }
        keyQueue.add(runnable);
        Handler newlyCreatedHandler = null;
        Map<K, Handler> map2 = this.threadActiveMap;
        synchronized (map2) {
            if (!this.threadActiveMap.containsKey(key)) {
                newlyCreatedHandler = new Handler(keyQueue, key);
                this.threadActiveMap.put(key, newlyCreatedHandler);
            }
        }
        if (newlyCreatedHandler != null) {
            this.scheduleHandler(newlyCreatedHandler);
            return true;
        }
        return false;
    }

    public Executor asExecutorFor(final K key) {
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                AsyncButOrdered.this.performAsyncButOrdered(key, runnable);
            }
        };
    }

    private class Handler
    implements Runnable {
        private final Queue<Runnable> keyQueue;
        private final K key;

        Handler(Queue<Runnable> keyQueue, K key) {
            this.keyQueue = keyQueue;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable runnable = null;
                while ((runnable = this.keyQueue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t) {
                        Handler newlyCreatedHandler = new Handler(this.keyQueue, this.key);
                        Map map = AsyncButOrdered.this.threadActiveMap;
                        synchronized (map) {
                            AsyncButOrdered.this.threadActiveMap.put(this.key, newlyCreatedHandler);
                        }
                        AsyncButOrdered.this.scheduleHandler(newlyCreatedHandler);
                        throw t;
                    }
                }
                Map map = AsyncButOrdered.this.threadActiveMap;
                synchronized (map) {
                    if (this.keyQueue.isEmpty()) {
                        AsyncButOrdered.this.threadActiveMap.remove(this.key);
                        break;
                    }
                }
            }
        }
    }
}

