/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.util;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserId
implements CharSequence {
    private static final Pattern emailPattern = Pattern.compile("(?:[\\p{L}\\u0900-\\u097F0-9!#\\$%&'*+/=?^_`{|}~-]+(?:\\.[\\p{L}\\u0900-\\u097F0-9!#\\$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[\\p{L}\\u0900-\\u097F0-9](?:[\\p{L}\\u0900-\\u097F0-9-]*[\\p{L}\\u0900-\\u097F0-9])?\\.)+[\\p{L}\\u0900-\\u097F0-9](?:[\\p{L}\\u0900-\\u097F0-9-]*[\\p{L}\\u0900-\\u097F0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[$\\p{L}\\u0900-\\u097F0-9-]*[\\p{L}\\u0900-\\u097F0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    private static final Pattern nameAddrPattern = Pattern.compile("^((?<name>.+?)\\s)?(\\((?<comment>.+?)\\)\\s)?(<(?<email>.+?)>)?$");
    private final String name;
    private final String comment;
    private final String email;
    private long hash = Long.MAX_VALUE;

    public static UserId parse(@Nonnull String string2) {
        Builder builder = UserId.newBuilder();
        Matcher matcher = nameAddrPattern.matcher(string2 = string2.trim());
        if (matcher.find()) {
            String name = matcher.group(2);
            String comment = matcher.group(4);
            String mail = matcher.group(6);
            if (!(matcher = emailPattern.matcher(mail)).matches()) {
                throw new IllegalArgumentException("Malformed email address");
            }
            if (name != null) {
                builder.withName(name);
            }
            if (comment != null) {
                builder.withComment(comment);
            }
            builder.withEmail(mail);
        } else {
            matcher = emailPattern.matcher(string2);
            if (matcher.matches()) {
                builder.withEmail(string2);
            } else {
                throw new IllegalArgumentException("Malformed email address");
            }
        }
        return builder.build();
    }

    private UserId(@Nullable String name, @Nullable String comment, @Nullable String email) {
        this.name = name == null ? null : name.trim();
        this.comment = comment == null ? null : comment.trim();
        this.email = email == null ? null : email.trim();
    }

    public static UserId onlyEmail(@Nonnull String email) {
        return new UserId(null, null, email);
    }

    public static UserId nameAndEmail(@Nonnull String name, @Nonnull String email) {
        return new UserId(name, null, email);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this.name, this.comment, this.email);
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean preserveQuotes) {
        if (this.name == null || this.name.isEmpty()) {
            return this.name;
        }
        if (this.name.startsWith("\"")) {
            if (preserveQuotes) {
                return this.name;
            }
            String withoutQuotes = this.name.substring(1);
            if (withoutQuotes.endsWith("\"")) {
                withoutQuotes = withoutQuotes.substring(0, withoutQuotes.length() - 1);
            }
            return withoutQuotes;
        }
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.getName(true));
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('(').append(this.comment).append(')');
        }
        if (this.email != null && !this.email.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('<').append(this.email).append('>');
        }
        return sb.toString();
    }

    @Deprecated
    public String asString() {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserId)) {
            return false;
        }
        UserId other = (UserId)o;
        return UserId.isEqualComponent(this.name, other.name, false) && UserId.isEqualComponent(this.comment, other.comment, false) && UserId.isEqualComponent(this.email, other.email, true);
    }

    public int hashCode() {
        if (this.hash != Long.MAX_VALUE) {
            return (int)this.hash;
        }
        int hashCode = 7;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + (this.comment == null ? 0 : this.comment.hashCode());
        hashCode = 31 * hashCode + (this.email == null ? 0 : this.email.toLowerCase().hashCode());
        this.hash = hashCode;
        return hashCode;
    }

    private static boolean isEqualComponent(String value, String otherValue, boolean ignoreCase) {
        boolean otherValueIsNull;
        boolean valueIsNull = value == null;
        boolean bl = otherValueIsNull = otherValue == null;
        return valueIsNull && otherValueIsNull || !valueIsNull && !otherValueIsNull && (ignoreCase ? value.equalsIgnoreCase(otherValue) : value.equals(otherValue));
    }

    public static int compare(@Nullable UserId o1, @Nullable UserId o2, @Nonnull Comparator<UserId> comparator) {
        return comparator.compare(o1, o2);
    }

    private static class NullSafeStringComparator
    implements Comparator<String> {
        private NullSafeStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    public static class DefaultIgnoreCaseComparator
    implements Comparator<UserId> {
        @Override
        public int compare(UserId o1, UserId o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            NullSafeStringComparator c = new NullSafeStringComparator();
            int cName = c.compare(DefaultIgnoreCaseComparator.lower(o1.getName()), DefaultIgnoreCaseComparator.lower(o2.getName()));
            if (cName != 0) {
                return cName;
            }
            int cComment = c.compare(DefaultIgnoreCaseComparator.lower(o1.getComment()), DefaultIgnoreCaseComparator.lower(o2.getComment()));
            if (cComment != 0) {
                return cComment;
            }
            return c.compare(DefaultIgnoreCaseComparator.lower(o1.getEmail()), DefaultIgnoreCaseComparator.lower(o2.getEmail()));
        }

        private static String lower(String string2) {
            return string2 == null ? null : string2.toLowerCase();
        }
    }

    public static class DefaultComparator
    implements Comparator<UserId> {
        @Override
        public int compare(UserId o1, UserId o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            NullSafeStringComparator c = new NullSafeStringComparator();
            int cName = c.compare(o1.getName(), o2.getName());
            if (cName != 0) {
                return cName;
            }
            int cComment = c.compare(o1.getComment(), o2.getComment());
            if (cComment != 0) {
                return cComment;
            }
            return c.compare(o1.getEmail(), o2.getEmail());
        }
    }

    public static final class Builder {
        private String name;
        private String comment;
        private String email;

        private Builder() {
        }

        private Builder(String name, String comment, String email) {
            this.name = name;
            this.comment = comment;
            this.email = email;
        }

        public Builder withName(@Nonnull String name) {
            this.name = name;
            return this;
        }

        public Builder withComment(@Nonnull String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withEmail(@Nonnull String email) {
            this.email = email;
            return this;
        }

        public Builder noName() {
            this.name = null;
            return this;
        }

        public Builder noComment() {
            this.comment = null;
            return this;
        }

        public Builder noEmail() {
            this.email = null;
            return this;
        }

        public UserId build() {
            return new UserId(this.name, this.comment, this.email);
        }
    }
}

