/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.auth.oauth2client.internal;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.UrlEncoded;
import org.openhab.core.auth.client.oauth2.AccessTokenRefreshListener;
import org.openhab.core.auth.client.oauth2.AccessTokenResponse;
import org.openhab.core.auth.client.oauth2.DeviceCodeResponseDTO;
import org.openhab.core.auth.client.oauth2.OAuthClientService;
import org.openhab.core.auth.client.oauth2.OAuthException;
import org.openhab.core.auth.client.oauth2.OAuthResponseException;
import org.openhab.core.auth.oauth2client.internal.OAuthConnector;
import org.openhab.core.auth.oauth2client.internal.OAuthConnectorRFC8628;
import org.openhab.core.auth.oauth2client.internal.OAuthStoreHandler;
import org.openhab.core.auth.oauth2client.internal.PersistedParams;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class OAuthClientServiceImpl
implements OAuthClientService {
    public static final int DEFAULT_TOKEN_EXPIRES_IN_BUFFER_SECOND = 10;
    private static final String EXCEPTION_MESSAGE_CLOSED = "Client service is closed";
    private final transient Logger logger = LoggerFactory.getLogger(OAuthClientServiceImpl.class);
    private final Object refreshTokenProcessLock = new Object();
    @NonNullByDefault(value={})
    private OAuthStoreHandler storeHandler;
    private final String handle;
    private final int tokenExpiresInSeconds;
    private final HttpClientFactory httpClientFactory;
    private final @Nullable GsonBuilder gsonBuilder;
    private final List<AccessTokenRefreshListener> accessTokenRefreshListeners = new ArrayList<AccessTokenRefreshListener>();
    private PersistedParams persistedParams = new PersistedParams();
    private @Nullable Fields extraAuthFields = null;
    private @Nullable OAuthConnectorRFC8628 oAuthConnectorRFC8628 = null;
    private volatile boolean closed = false;

    private OAuthClientServiceImpl(String handle, int tokenExpiresInSeconds, HttpClientFactory httpClientFactory, @Nullable GsonBuilder gsonBuilder) {
        this.handle = handle;
        this.tokenExpiresInSeconds = tokenExpiresInSeconds;
        this.httpClientFactory = httpClientFactory;
        this.gsonBuilder = gsonBuilder;
    }

    static @Nullable OAuthClientServiceImpl getInstance(String handle, OAuthStoreHandler storeHandler, int tokenExpiresInSeconds, HttpClientFactory httpClientFactory) {
        PersistedParams persistedParamsFromStore = storeHandler.loadPersistedParams(handle);
        if (persistedParamsFromStore == null) {
            return null;
        }
        OAuthClientServiceImpl clientService = new OAuthClientServiceImpl(handle, tokenExpiresInSeconds, httpClientFactory, null);
        clientService.storeHandler = storeHandler;
        clientService.persistedParams = persistedParamsFromStore;
        return clientService;
    }

    static OAuthClientServiceImpl createInstance(String handle, OAuthStoreHandler storeHandler, HttpClientFactory httpClientFactory, PersistedParams params) {
        OAuthClientServiceImpl clientService = new OAuthClientServiceImpl(handle, params.tokenExpiresInSeconds, httpClientFactory, null);
        clientService.storeHandler = storeHandler;
        clientService.persistedParams = params;
        storeHandler.savePersistedParams(handle, clientService.persistedParams);
        return clientService;
    }

    public String getAuthorizationUrl(@Nullable String redirectURI, @Nullable String scope, @Nullable String state) throws OAuthException {
        this.persistedParams.state = state == null ? this.createNewState() : state;
        String scopeToUse = scope == null ? this.persistedParams.scope : scope;
        this.persistedParams.redirectUri = redirectURI;
        String authorizationUrl = this.persistedParams.authorizationUrl;
        if (authorizationUrl == null) {
            throw new OAuthException("Missing authorization url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        GsonBuilder gsonBuilder = this.gsonBuilder;
        OAuthConnector connector = gsonBuilder == null ? new OAuthConnector(this.httpClientFactory, this.extraAuthFields) : new OAuthConnector(this.httpClientFactory, this.extraAuthFields, gsonBuilder);
        return connector.getAuthorizationUrl(authorizationUrl, clientId, redirectURI, this.persistedParams.state, scopeToUse);
    }

    public String extractAuthCodeFromAuthResponse(String redirectURLwithParams) throws OAuthException {
        try {
            URL redirectURLObject = new URI(redirectURLwithParams).toURL();
            UrlEncoded urlEncoded = new UrlEncoded(redirectURLObject.getQuery());
            String stateFromRedirectURL = (String)urlEncoded.getValue("state", 0);
            if (stateFromRedirectURL == null) {
                if (this.persistedParams.state == null) {
                    return (String)urlEncoded.getValue("code", 0);
                }
                throw new OAuthException(String.format("state from redirectURL is incorrect.  Expected: %s Found: %s", this.persistedParams.state, stateFromRedirectURL));
            }
            if (stateFromRedirectURL.equals(this.persistedParams.state)) {
                return (String)urlEncoded.getValue("code", 0);
            }
            throw new OAuthException(String.format("state from redirectURL is incorrect.  Expected: %s Found: %s", this.persistedParams.state, stateFromRedirectURL));
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            throw new OAuthException("Redirect URL is malformed", (Throwable)e);
        }
    }

    public AccessTokenResponse getAccessTokenResponseByAuthorizationCode(String authorizationCode, @Nullable String redirectURI) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        if (this.persistedParams.redirectUri != null && !this.persistedParams.redirectUri.equals(redirectURI)) {
            throw new OAuthException(String.format("redirectURI should be the same from previous call #getAuthorizationUrl.  Expected: %s Found: %s", this.persistedParams.redirectUri, redirectURI));
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        GsonBuilder gsonBuilder = this.gsonBuilder;
        OAuthConnector connector = gsonBuilder == null ? new OAuthConnector(this.httpClientFactory, this.extraAuthFields) : new OAuthConnector(this.httpClientFactory, this.extraAuthFields, gsonBuilder);
        AccessTokenResponse accessTokenResponse = connector.grantTypeAuthorizationCode(tokenUrl, authorizationCode, clientId, this.persistedParams.clientSecret, redirectURI, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse getAccessTokenByImplicit(@Nullable String redirectURI, @Nullable String scope, @Nullable String state) throws OAuthException, IOException, OAuthResponseException {
        throw new UnsupportedOperationException("Implicit Grant is not implemented");
    }

    public AccessTokenResponse getAccessTokenByResourceOwnerPasswordCredentials(String username, String password, @Nullable String scope) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        GsonBuilder gsonBuilder = this.gsonBuilder;
        OAuthConnector connector = gsonBuilder == null ? new OAuthConnector(this.httpClientFactory, this.extraAuthFields) : new OAuthConnector(this.httpClientFactory, this.extraAuthFields, gsonBuilder);
        AccessTokenResponse accessTokenResponse = connector.grantTypePassword(tokenUrl, username, password, this.persistedParams.clientId, this.persistedParams.clientSecret, scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse getAccessTokenByClientCredentials(@Nullable String scope) throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        String tokenUrl = this.persistedParams.tokenUrl;
        if (tokenUrl == null) {
            throw new OAuthException("Missing token url");
        }
        String clientId = this.persistedParams.clientId;
        if (clientId == null) {
            throw new OAuthException("Missing client ID");
        }
        GsonBuilder gsonBuilder = this.gsonBuilder;
        OAuthConnector connector = gsonBuilder == null ? new OAuthConnector(this.httpClientFactory, this.extraAuthFields) : new OAuthConnector(this.httpClientFactory, this.extraAuthFields, gsonBuilder);
        AccessTokenResponse accessTokenResponse = connector.grantTypeClientCredentials(tokenUrl, clientId, this.persistedParams.clientSecret, scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        return accessTokenResponse;
    }

    public AccessTokenResponse refreshToken() throws OAuthException, IOException, OAuthResponseException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        return this.refreshTokenInner(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse refreshTokenInner(boolean forceRefresh) throws OAuthException, IOException, OAuthResponseException {
        AccessTokenResponse accessTokenResponse = null;
        Object object = this.refreshTokenProcessLock;
        synchronized (object) {
            AccessTokenResponse lastAccessToken;
            try {
                lastAccessToken = this.storeHandler.loadAccessTokenResponse(this.handle);
            }
            catch (GeneralSecurityException e) {
                throw new OAuthException("Cannot decrypt access token from store", (Throwable)e);
            }
            if (lastAccessToken == null) {
                throw new OAuthException("Cannot refresh token because last access token is not available from handle: " + this.handle);
            }
            if (lastAccessToken.getRefreshToken() == null) {
                throw new OAuthException("Cannot refresh token because last access token did not have a refresh token");
            }
            String tokenUrl = this.persistedParams.tokenUrl;
            if (tokenUrl == null) {
                throw new OAuthException("tokenUrl is required but null");
            }
            if (forceRefresh || lastAccessToken.isExpired(Instant.now(), this.tokenExpiresInSeconds)) {
                GsonBuilder gsonBuilder = this.gsonBuilder;
                OAuthConnector connector = gsonBuilder == null ? new OAuthConnector(this.httpClientFactory, this.extraAuthFields) : new OAuthConnector(this.httpClientFactory, this.extraAuthFields, gsonBuilder);
                accessTokenResponse = connector.grantTypeRefreshToken(tokenUrl, lastAccessToken.getRefreshToken(), this.persistedParams.clientId, this.persistedParams.clientSecret, this.persistedParams.scope, Boolean.TRUE.equals(this.persistedParams.supportsBasicAuth));
                String refreshToken = accessTokenResponse.getRefreshToken();
                if (refreshToken == null || refreshToken.isBlank()) {
                    accessTokenResponse.setRefreshToken(lastAccessToken.getRefreshToken());
                }
            } else {
                return lastAccessToken;
            }
            this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
        }
        this.notifyAccessTokenResponse(accessTokenResponse);
        return accessTokenResponse;
    }

    public @Nullable AccessTokenResponse getAccessTokenResponse() throws OAuthException, IOException, OAuthResponseException {
        AccessTokenResponse lastAccessToken;
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        try {
            lastAccessToken = this.storeHandler.loadAccessTokenResponse(this.handle);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException("Cannot decrypt access token from store", (Throwable)e);
        }
        if (lastAccessToken == null) {
            return null;
        }
        if (lastAccessToken.isExpired(Instant.now(), this.tokenExpiresInSeconds) && lastAccessToken.getRefreshToken() != null) {
            return this.refreshTokenInner(false);
        }
        return lastAccessToken;
    }

    public void importAccessTokenResponse(AccessTokenResponse accessTokenResponse) throws OAuthException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        this.storeHandler.saveAccessTokenResponse(this.handle, accessTokenResponse);
    }

    public void setTokenExpiresInBuffer(int tokenExpiresInBuffer) {
        this.persistedParams.tokenExpiresInSeconds = tokenExpiresInBuffer;
    }

    public void remove() throws OAuthException {
        if (this.isClosed()) {
            throw new OAuthException(EXCEPTION_MESSAGE_CLOSED);
        }
        this.logger.debug("removing handle: {}", (Object)this.handle);
        this.storeHandler.remove(this.handle);
        this.close();
    }

    public void close() {
        this.closed = true;
        this.storeHandler = null;
        this.logger.debug("closing oauth client, handle: {}", (Object)this.handle);
        this.closeOAuthConnectorRFC8628();
    }

    private synchronized void closeOAuthConnectorRFC8628() {
        OAuthConnectorRFC8628 connector = this.oAuthConnectorRFC8628;
        if (connector != null) {
            connector.close();
        }
        this.oAuthConnectorRFC8628 = null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void addAccessTokenRefreshListener(AccessTokenRefreshListener listener) {
        this.accessTokenRefreshListeners.add(listener);
    }

    public boolean removeAccessTokenRefreshListener(AccessTokenRefreshListener listener) {
        return this.accessTokenRefreshListeners.remove(listener);
    }

    private String createNewState() {
        return UUID.randomUUID().toString();
    }

    public void addExtraAuthField(String key, String value) {
        if (this.extraAuthFields == null) {
            this.extraAuthFields = new Fields();
        }
        this.extraAuthFields.add(key, value);
    }

    public OAuthClientService withGsonBuilder(GsonBuilder gsonBuilder) {
        OAuthClientServiceImpl clientService = new OAuthClientServiceImpl(this.handle, this.persistedParams.tokenExpiresInSeconds, this.httpClientFactory, gsonBuilder);
        clientService.persistedParams = this.persistedParams;
        clientService.storeHandler = this.storeHandler;
        this.storeHandler.savePersistedParams(this.handle, clientService.persistedParams);
        return clientService;
    }

    public @Nullable DeviceCodeResponseDTO getDeviceCodeResponse() throws OAuthException {
        OAuthConnectorRFC8628 connector;
        this.closeOAuthConnectorRFC8628();
        if (this.persistedParams.tokenUrl == null) {
            throw new OAuthException("Missing access token request url");
        }
        if (this.persistedParams.authorizationUrl == null) {
            throw new OAuthException("Missing device code request url");
        }
        if (this.persistedParams.clientId == null) {
            throw new OAuthException("Missing client id");
        }
        if (this.persistedParams.scope == null) {
            throw new OAuthException("Missing scope");
        }
        this.oAuthConnectorRFC8628 = connector = new OAuthConnectorRFC8628(this, this.handle, this.storeHandler, this.httpClientFactory, this.gsonBuilder, this.persistedParams.tokenUrl, this.persistedParams.authorizationUrl, this.persistedParams.clientId, this.persistedParams.scope);
        return connector.getDeviceCodeResponse();
    }

    public void notifyAccessTokenResponse(AccessTokenResponse atr) {
        this.accessTokenRefreshListeners.forEach(l -> l.onAccessTokenResponse(atr));
    }
}

