﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amp/model/ComponentConfig.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace PrometheusService {
namespace Model {

ComponentConfig::ComponentConfig(JsonView jsonValue) { *this = jsonValue; }

ComponentConfig& ComponentConfig::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("options")) {
    Aws::Map<Aws::String, JsonView> optionsJsonMap = jsonValue.GetObject("options").GetAllObjects();
    for (auto& optionsItem : optionsJsonMap) {
      m_options[optionsItem.first] = optionsItem.second.AsString();
    }
    m_optionsHasBeenSet = true;
  }
  return *this;
}

JsonValue ComponentConfig::Jsonize() const {
  JsonValue payload;

  if (m_optionsHasBeenSet) {
    JsonValue optionsJsonMap;
    for (auto& optionsItem : m_options) {
      optionsJsonMap.WithString(optionsItem.first, optionsItem.second);
    }
    payload.WithObject("options", std::move(optionsJsonMap));
  }

  return payload;
}

}  // namespace Model
}  // namespace PrometheusService
}  // namespace Aws
