/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.TraceClause;
import net.sf.saxon.expr.instruct.ComponentTracer;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.trace.TraceableComponent;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class TraceCodeInjector
implements CodeInjector {
    protected int traceLevel = 2;

    public void setTraceLevel(int traceLevel) {
        this.traceLevel = traceLevel;
    }

    public static int levelValue(String level) {
        switch (level) {
            case "none": {
                return 0;
            }
            case "low": {
                return 1;
            }
            case "normal": {
                return 2;
            }
            case "high": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Trace level " + level);
    }

    @Override
    public Expression inject(Expression exp) {
        if (exp instanceof FLWORExpression) {
            ((FLWORExpression)exp).injectCode(this);
            return exp;
        }
        if (!(exp instanceof TraceExpression) && this.isApplicable(exp)) {
            return new TraceExpression(exp);
        }
        return exp;
    }

    protected boolean isApplicable(Expression exp) {
        return false;
    }

    @Override
    public void process(TraceableComponent component) {
        if (!(component.getBody() instanceof ComponentTracer)) {
            Expression newBody = ExpressionTool.injectCode(component.getBody(), this);
            component.setBody(newBody);
            ComponentTracer trace = new ComponentTracer(component);
            component.setBody(trace);
        }
    }

    @Override
    public Clause injectClause(FLWORExpression expression, Clause clause) {
        try {
            clause.processOperands(operand -> operand.setChildExpression(ExpressionTool.injectCode(operand.getChildExpression(), this)));
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
        return new TraceClause(expression, clause);
    }
}

