/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.chunk;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dita.dost.util.Constants;
import org.dita.dost.util.RoseTree;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChunkUtils {
    public static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public static boolean isCompatible(Document doc) {
        return ChunkUtils.isCompatible(doc, null);
    }

    public static boolean isCompatible(Document doc, Set<String> override) {
        List<RoseTree<Set<String>>> chunkTree = ChunkUtils.getChunkTree(doc);
        if (chunkTree.isEmpty() && (override == null || override.isEmpty())) {
            return false;
        }
        Set tokens = Stream.concat(chunkTree.stream().flatMap(RoseTree::flatten).flatMap(Collection::stream), override != null ? override.stream() : Stream.empty()).collect(Collectors.toSet());
        if (tokens.size() == 1 && tokens.contains("to-content")) {
            return true;
        }
        if (tokens.size() == 1 && tokens.contains("by-topic")) {
            return true;
        }
        if (tokens.size() == 2 && tokens.contains("to-content") && tokens.contains("by-topic")) {
            for (RoseTree<Set<String>> tree : chunkTree) {
                if (!ChunkUtils.findCombineWithSplitDescendant(tree)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean findCombineWithSplitDescendant(RoseTree<Set<String>> root) {
        ArrayDeque stack = new ArrayDeque();
        stack.push(root);
        while (!stack.isEmpty()) {
            RoseTree node = (RoseTree)stack.pop();
            if (((Set)node.getValue()).contains("to-content")) {
                Stack descendantStack = new Stack();
                descendantStack.push(node);
                while (!descendantStack.isEmpty()) {
                    RoseTree descendant = (RoseTree)descendantStack.pop();
                    if (((Set)descendant.getValue()).contains("by-topic")) {
                        return true;
                    }
                    for (RoseTree child : descendant.getChildren()) {
                        descendantStack.push(child);
                    }
                }
            }
            for (RoseTree child : node.getChildren()) {
                stack.push(child);
            }
        }
        return false;
    }

    private static List<RoseTree<Set<String>>> getChunkTree(Document doc) {
        ArrayList<RoseTree<Set<String>>> res = new ArrayList<RoseTree<Set<String>>>();
        ChunkUtils.collectChunkTreeTokens(doc.getDocumentElement(), res);
        return res;
    }

    private static void collectChunkTreeTokens(Element elem, List<RoseTree<Set<String>>> dst) {
        Attr chunkAttr = elem.getAttributeNode("chunk");
        if (chunkAttr != null) {
            Set chunkTokens = Stream.of(WHITESPACE.split(chunkAttr.getValue())).filter(token -> !token.isBlank()).collect(Collectors.toSet());
            ArrayList<RoseTree<Set<String>>> res = new ArrayList<RoseTree<Set<String>>>();
            for (Element child : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                ChunkUtils.collectChunkTreeTokens(child, res);
            }
            RoseTree chunkTree = new RoseTree(chunkTokens, res);
            dst.add(chunkTree);
        } else {
            for (Element child : XMLUtils.getChildElements(elem, Constants.MAP_TOPICREF)) {
                ChunkUtils.collectChunkTreeTokens(child, dst);
            }
        }
    }
}

