/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.render.pdf.pdfbox.HandleAnnotations;
import org.apache.fop.render.pdf.pdfbox.PDFBoxAdapter;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class CloneAnnotations
implements HandleAnnotations<COSObject> {
    private PDFBoxAdapter pdfBoxAdapter;
    private Set<COSObject> fields = new TreeSet<COSObject>(new CompareFields());

    public CloneAnnotations(PDFBoxAdapter pdfBoxAdapter) {
        this.pdfBoxAdapter = pdfBoxAdapter;
    }

    @Override
    public Set<COSObject> getFields() {
        return this.fields;
    }

    @Override
    public void load(COSObject annot, PDAcroForm srcAcroForm) {
        this.getField(annot, srcAcroForm);
    }

    private COSDictionary getField(COSObject fieldObject, PDAcroForm srcAcroForm) {
        COSObject parent;
        COSDictionary field = (COSDictionary)fieldObject.getObject();
        while ((parent = this.getParent(field)) != null) {
            fieldObject = parent;
            field = (COSDictionary)fieldObject.getObject();
        }
        if (srcAcroForm != null) {
            COSArray srcFields = (COSArray)srcAcroForm.getCOSObject().getDictionaryObject(COSName.FIELDS);
            if (srcFields != null && srcFields.toList().contains(fieldObject)) {
                this.fields.add(fieldObject);
            }
        } else {
            this.fields.add(fieldObject);
        }
        return field;
    }

    private COSObject getParent(COSDictionary field) {
        COSBase parent = field.getItem(COSName.PARENT);
        if (parent instanceof COSObject) {
            return (COSObject)parent;
        }
        return null;
    }

    @Override
    public void cloneAnnotParent(COSBase annot, PDFDictionary clonedAnnot, Collection<COSName> exclude) throws IOException {
        COSDictionary dictionary;
        COSBase parent;
        if (annot instanceof COSObject && (parent = (dictionary = (COSDictionary)((COSObject)annot).getObject()).getItem(COSName.PARENT)) != null) {
            clonedAnnot.put(COSName.PARENT.getName(), this.pdfBoxAdapter.cloneForNewDocument(parent, parent, exclude));
        }
    }

    static class CompareFields
    implements Comparator<COSObject>,
    Serializable {
        private static final long serialVersionUID = -6081505461660440801L;

        CompareFields() {
        }

        @Override
        public int compare(COSObject o1, COSObject o2) {
            return (int)(o1.getObjectNumber() - o2.getObjectNumber());
        }
    }
}

