/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ui.AbstractSelectFilesDialog;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectFilesDialog
extends AbstractSelectFilesDialog {
    @NotNull
    private final VirtualFileList myFileList;
    private final boolean myDeletableFiles;

    protected SelectFilesDialog(Project project, @NotNull List<? extends VirtualFile> files, @NlsContexts.Label @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        if (files == null) {
            SelectFilesDialog.$$$reportNull$$$0(0);
        }
        super(project, false, confirmationOption, prompt);
        this.myDeletableFiles = deletableFiles;
        this.myFileList = new VirtualFileList(project, selectableFiles, deletableFiles, files);
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @NlsContexts.Label @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles) {
        if (originalFiles == null) {
            SelectFilesDialog.$$$reportNull$$$0(1);
        }
        SelectFilesDialog dialog = new SelectFilesDialog(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dialog.init();
        SelectFilesDialog selectFilesDialog = dialog;
        if (selectFilesDialog == null) {
            SelectFilesDialog.$$$reportNull$$$0(2);
        }
        return selectFilesDialog;
    }

    @NotNull
    public static SelectFilesDialog init(Project project, @NotNull List<? extends VirtualFile> originalFiles, @NlsContexts.Label @Nullable String prompt, @Nullable VcsShowConfirmationOption confirmationOption, boolean selectableFiles, boolean deletableFiles, @NlsContexts.Button @NotNull String okActionName, @NlsContexts.Button @NotNull String cancelActionName) {
        if (originalFiles == null) {
            SelectFilesDialog.$$$reportNull$$$0(3);
        }
        if (okActionName == null) {
            SelectFilesDialog.$$$reportNull$$$0(4);
        }
        if (cancelActionName == null) {
            SelectFilesDialog.$$$reportNull$$$0(5);
        }
        SelectFilesDialog dlg = SelectFilesDialog.init(project, originalFiles, prompt, confirmationOption, selectableFiles, deletableFiles);
        dlg.setOKButtonText(okActionName);
        dlg.setCancelButtonText(cancelActionName);
        SelectFilesDialog selectFilesDialog = dlg;
        if (selectFilesDialog == null) {
            SelectFilesDialog.$$$reportNull$$$0(6);
        }
        return selectFilesDialog;
    }

    public Collection<VirtualFile> getSelectedFiles() {
        return this.myFileList.getIncludedChanges();
    }

    public void setSelectedFiles(@NotNull Collection<VirtualFile> selected) {
        if (selected == null) {
            SelectFilesDialog.$$$reportNull$$$0(7);
        }
        this.myFileList.setIncludedChanges(selected);
        this.myFileList.rebuildTree();
    }

    @Override
    @NotNull
    protected ChangesTree getFileList() {
        VirtualFileList virtualFileList = this.myFileList;
        if (virtualFileList == null) {
            SelectFilesDialog.$$$reportNull$$$0(8);
        }
        return virtualFileList;
    }

    @Override
    @NotNull
    protected DefaultActionGroup createToolbarActions() {
        DefaultActionGroup defaultGroup = super.createToolbarActions();
        if (this.myDeletableFiles) {
            DeleteAction deleteAction = new DeleteAction(null, null, IconUtil.getRemoveIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.actionPerformed(e);
                    SelectFilesDialog.this.myFileList.rebuildTree();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$1", "actionPerformed"));
                }
            };
            ActionUtil.mergeFrom((AnAction)deleteAction, (String)"$Delete");
            deleteAction.registerCustomShortcutSet((JComponent)((Object)this.getFileList()), null);
            defaultGroup.add((AnAction)deleteAction);
        }
        DefaultActionGroup defaultActionGroup = defaultGroup;
        if (defaultActionGroup == null) {
            SelectFilesDialog.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "okActionName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelActionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static class VirtualFileList
    extends AsyncChangesTreeImpl.VirtualFiles {
        @Nullable
        private final DeleteProvider myDeleteProvider;

        public VirtualFileList(Project project, boolean selectableFiles, boolean deletableFiles, @NotNull List<? extends VirtualFile> files) {
            if (files == null) {
                VirtualFileList.$$$reportNull$$$0(0);
            }
            super(project, selectableFiles, true, files);
            this.myDeleteProvider = deletableFiles ? new VirtualFileDeleteProvider() : null;
        }

        @Override
        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                VirtualFileList.$$$reportNull$$$0(1);
            }
            super.uiDataSnapshot(sink);
            sink.set(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)this.myDeleteProvider);
            sink.set(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)this.getSelectedChanges().toArray(VirtualFile.EMPTY_ARRAY));
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull ChangesGroupingPolicyFactory grouping, @NotNull List<? extends VirtualFile> changes) {
            if (grouping == null) {
                VirtualFileList.$$$reportNull$$$0(2);
            }
            if (changes == null) {
                VirtualFileList.$$$reportNull$$$0(3);
            }
            DefaultTreeModel defaultTreeModel = super.buildTreeModel(grouping, ContainerUtil.filter(changes, VirtualFile::isValid));
            if (defaultTreeModel == null) {
                VirtualFileList.$$$reportNull$$$0(4);
            }
            return defaultTreeModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$VirtualFileList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SelectFilesDialog$VirtualFileList";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

