// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains incremental updates to the source content text during streaming responses, allowing clients to build up the cited content progressively.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CitationSourceContentDelta {
    /// <p>An incremental update to the text content from the source document that is being cited.</p>
    pub text: ::std::option::Option<::std::string::String>,
}
impl CitationSourceContentDelta {
    /// <p>An incremental update to the text content from the source document that is being cited.</p>
    pub fn text(&self) -> ::std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl CitationSourceContentDelta {
    /// Creates a new builder-style object to manufacture [`CitationSourceContentDelta`](crate::types::CitationSourceContentDelta).
    pub fn builder() -> crate::types::builders::CitationSourceContentDeltaBuilder {
        crate::types::builders::CitationSourceContentDeltaBuilder::default()
    }
}

/// A builder for [`CitationSourceContentDelta`](crate::types::CitationSourceContentDelta).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CitationSourceContentDeltaBuilder {
    pub(crate) text: ::std::option::Option<::std::string::String>,
}
impl CitationSourceContentDeltaBuilder {
    /// <p>An incremental update to the text content from the source document that is being cited.</p>
    pub fn text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An incremental update to the text content from the source document that is being cited.</p>
    pub fn set_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.text = input;
        self
    }
    /// <p>An incremental update to the text content from the source document that is being cited.</p>
    pub fn get_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.text
    }
    /// Consumes the builder and constructs a [`CitationSourceContentDelta`](crate::types::CitationSourceContentDelta).
    pub fn build(self) -> crate::types::CitationSourceContentDelta {
        crate::types::CitationSourceContentDelta { text: self.text }
    }
}
