/* PR c/102989 */
/* { dg-require-effective-target bitint } */
/* { dg-options "-O2 -std=c23 -pedantic-errors" } */

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
tests192 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192 (_Decimal32 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
tests575 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575 (_Decimal32 d)
{
  return d;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 192
  if (tests192 (0.DF) != 0wb
      || tests192 (0.9999999DF) != 0wb
      || tests192 (7.999999DF) != 7wb
      || tests192 (-0.000DF) != 0wb
      || tests192 (-0.9999999DF) != 0wb
      || tests192 (-1.DF) != -1wb
      || tests192 (-42.5DF) != -42wb
      || tests192 (-3424.231e+27DF) != -3424231000000000000000000000000wb
      || tests192 (-213855.9e+43DF) != -2138559000000000000000000000000000000000000000000wb
      || tests192 (313855.0e+52DF) != 3138550000000000000000000000000000000000000000000000000000wb
      || tests192 (-3138550.e+51DF) != -3138550000000000000000000000000000000000000000000000000000wb)
    __builtin_abort ();
  if (tests192 (313855.1e+52DF) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (9999999e+90DF) != 3138550867693340381917894711603833208051177722232017256447wb
      || tests192 (-3138551e+51DF) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb
      || tests192 (-9999999e+90DF) != -3138550867693340381917894711603833208051177722232017256447wb - 1wb)
    __builtin_abort ();
  if (testu192 (0.DF) != 0uwb
      || testu192 (0.9999999DF) != 0uwb
      || testu192 (-0.9999999DF) != 0uwb
      || testu192 (-0.5DF) != 0uwb
      || testu192 (-0.0000DF) != 0uwb
      || testu192 (-0.99999DF) != 0uwb
      || testu192 (42.99999DF) != 42uwb
      || testu192 (42.e+21DF) != 42000000000000000000000uwb
      || testu192 (3427.231e+29DF) != 342723100000000000000000000000000uwb
      || testu192 (6277101.0e+51DF) != 6277101000000000000000000000000000000000000000000000000000uwb)
    __builtin_abort ();
  if (testu192 (-1.DF) != 0uwb
      || testu192 (-42.5e+15DF) != 0uwb
      || testu192 (-9999999e+90DF) != 0uwb
      || testu192 (6277102.0e+51DF) != 6277101735386680763835789423207666416102355444464034512895uwb
      || testu192 (9999999e+90DF) != 6277101735386680763835789423207666416102355444464034512895uwb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (tests575 (0.DF) != 0wb
      || tests575 (0.999999DF) != 0wb
      || tests575 (12.9999DF) != 12wb
      || tests575 (-0.DF) != 0wb
      || tests575 (-0.999DF) != 0wb
      || tests575 (-1.0000DF) != -1wb
      || tests575 (-89.5DF) != -89wb
      || tests575 (-34242.31e+37DF) != -342423100000000000000000000000000000000000wb
      || tests575 (-518326.2e+88DF) != -5183262000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (9999999e+90DF) != 9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb
      || tests575 (-9999999e+90DF) != -9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb)
    __builtin_abort ();
  if (testu575 (0.DF) != 0uwb
      || testu575 (0.5555555DF) != 0uwb
      || testu575 (-0.7777777DF) != 0uwb
      || testu575 (-0.99DF) != 0uwb
      || testu575 (-0.DF) != 0uwb
      || testu575 (-0.7777777DF) != 0uwb
      || testu575 (-0.9999999DF) != 0uwb
      || testu575 (42.99999DF) != 42uwb
      || testu575 (42.e+21DF) != 42000000000000000000000uwb
      || testu575 (9427.231e+27DF) != 9427231000000000000000000000000uwb
      || testu575 (9999999e+90DF) != 9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb)
    __builtin_abort ();
  if (testu575 (-1.DF) != 0uwb
      || testu575 (-42.5e+15DF) != 0uwb
      || testu575 (-9999999e+90DF) != 0uwb)
    __builtin_abort ();
#endif
}
