package logz

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/logz/mgmt/2020-10-01-preview/logz"

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// FilteringTag the definition of a filtering tag. Filtering tags are used for capturing resources and
// include/exclude them from being monitored.
type FilteringTag struct {
	// Name - The name (also known as the key) of the tag.
	Name *string `json:"name,omitempty"`
	// Value - The value of the tag.
	Value *string `json:"value,omitempty"`
	// Action - Possible values include: 'TagActionInclude', 'TagActionExclude'
	Action TagAction `json:"action,omitempty"`
}

// IdentityProperties ...
type IdentityProperties struct {
	// PrincipalID - READ-ONLY; The identity ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - Possible values include: 'ManagedIdentityTypesSystemAssigned', 'ManagedIdentityTypesUserAssigned'
	Type ManagedIdentityTypes `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProperties.
func (IP IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	return json.Marshal(objectMap)
}

// LogRules set of rules for sending logs for the Monitor resource.
type LogRules struct {
	// SendAadLogs - Flag specifying if AAD logs should be sent for the Monitor resource.
	SendAadLogs *bool `json:"sendAadLogs,omitempty"`
	// SendSubscriptionLogs - Flag specifying if subscription logs should be sent for the Monitor resource.
	SendSubscriptionLogs *bool `json:"sendSubscriptionLogs,omitempty"`
	// SendActivityLogs - Flag specifying if activity logs from Azure resources should be sent for the Monitor resource.
	SendActivityLogs *bool `json:"sendActivityLogs,omitempty"`
	// FilteringTags - List of filtering tags to be used for capturing logs. This only takes effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only Exclude action is specified, the rules will apply to the list of all available resources. If Include actions are specified, the rules will only include resources with the associated tags.
	FilteringTags *[]FilteringTag `json:"filteringTags,omitempty"`
}

// MonitoredResource the properties of a resource currently being monitored by the Logz monitor resource.
type MonitoredResource struct {
	// ID - The ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// SendingMetrics - Flag indicating if resource is sending metrics to Logz.
	SendingMetrics *bool `json:"sendingMetrics,omitempty"`
	// ReasonForMetricsStatus - Reason for why the resource is sending metrics (or why it is not sending).
	ReasonForMetricsStatus *string `json:"reasonForMetricsStatus,omitempty"`
	// SendingLogs - Flag indicating if resource is sending logs to Logz.
	SendingLogs *bool       `json:"sendingLogs,omitempty"`
	SystemData  *SystemData `json:"systemData,omitempty"`
	// ReasonForLogsStatus - Reason for why the resource is sending logs (or why it is not sending).
	ReasonForLogsStatus *string `json:"reasonForLogsStatus,omitempty"`
}

// MonitoredResourceListResponse response of a list operation.
type MonitoredResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoredResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoredResourceListResponseIterator provides access to a complete listing of MonitoredResource values.
type MonitoredResourceListResponseIterator struct {
	i    int
	page MonitoredResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoredResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoredResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoredResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoredResourceListResponseIterator) Response() MonitoredResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoredResourceListResponseIterator) Value() MonitoredResource {
	if !iter.page.NotDone() {
		return MonitoredResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoredResourceListResponseIterator type.
func NewMonitoredResourceListResponseIterator(page MonitoredResourceListResponsePage) MonitoredResourceListResponseIterator {
	return MonitoredResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitoredResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitoredResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitoredResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitoredResourceListResponse) monitoredResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitoredResourceListResponsePage contains a page of MonitoredResource values.
type MonitoredResourceListResponsePage struct {
	fn   func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)
	mrlr MonitoredResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoredResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoredResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoredResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoredResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoredResourceListResponsePage) Response() MonitoredResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoredResourceListResponsePage) Values() []MonitoredResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitoredResourceListResponsePage type.
func NewMonitoredResourceListResponsePage(cur MonitoredResourceListResponse, getNextPage func(context.Context, MonitoredResourceListResponse) (MonitoredResourceListResponse, error)) MonitoredResourceListResponsePage {
	return MonitoredResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitoringTagRules capture logs and metrics of Azure resources based on ARM tags.
type MonitoringTagRules struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Name of the rule set.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The id of the rule set.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the rule set.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData                   `json:"systemData,omitempty"`
	Properties *MonitoringTagRulesProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitoringTagRules.
func (mtr MonitoringTagRules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mtr.Properties != nil {
		objectMap["properties"] = mtr.Properties
	}
	return json.Marshal(objectMap)
}

// MonitoringTagRulesListResponse response of a list operation.
type MonitoringTagRulesListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitoringTagRules `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitoringTagRulesListResponseIterator provides access to a complete listing of MonitoringTagRules
// values.
type MonitoringTagRulesListResponseIterator struct {
	i    int
	page MonitoringTagRulesListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitoringTagRulesListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitoringTagRulesListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitoringTagRulesListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitoringTagRulesListResponseIterator) Response() MonitoringTagRulesListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitoringTagRulesListResponseIterator) Value() MonitoringTagRules {
	if !iter.page.NotDone() {
		return MonitoringTagRules{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitoringTagRulesListResponseIterator type.
func NewMonitoringTagRulesListResponseIterator(page MonitoringTagRulesListResponsePage) MonitoringTagRulesListResponseIterator {
	return MonitoringTagRulesListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mtrlr MonitoringTagRulesListResponse) IsEmpty() bool {
	return mtrlr.Value == nil || len(*mtrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mtrlr MonitoringTagRulesListResponse) hasNextLink() bool {
	return mtrlr.NextLink != nil && len(*mtrlr.NextLink) != 0
}

// monitoringTagRulesListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mtrlr MonitoringTagRulesListResponse) monitoringTagRulesListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mtrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mtrlr.NextLink)))
}

// MonitoringTagRulesListResponsePage contains a page of MonitoringTagRules values.
type MonitoringTagRulesListResponsePage struct {
	fn    func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)
	mtrlr MonitoringTagRulesListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitoringTagRulesListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitoringTagRulesListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mtrlr)
		if err != nil {
			return err
		}
		page.mtrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitoringTagRulesListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitoringTagRulesListResponsePage) NotDone() bool {
	return !page.mtrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitoringTagRulesListResponsePage) Response() MonitoringTagRulesListResponse {
	return page.mtrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitoringTagRulesListResponsePage) Values() []MonitoringTagRules {
	if page.mtrlr.IsEmpty() {
		return nil
	}
	return *page.mtrlr.Value
}

// Creates a new instance of the MonitoringTagRulesListResponsePage type.
func NewMonitoringTagRulesListResponsePage(cur MonitoringTagRulesListResponse, getNextPage func(context.Context, MonitoringTagRulesListResponse) (MonitoringTagRulesListResponse, error)) MonitoringTagRulesListResponsePage {
	return MonitoringTagRulesListResponsePage{
		fn:    getNextPage,
		mtrlr: cur,
	}
}

// MonitoringTagRulesProperties definition of the properties for a TagRules resource.
type MonitoringTagRulesProperties struct {
	// ProvisioningState - Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateNotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	LogRules          *LogRules         `json:"logRules,omitempty"`
	SystemData        *SystemData       `json:"systemData,omitempty"`
}

// MonitorProperties properties specific to the monitor resource.
type MonitorProperties struct {
	// ProvisioningState - Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateNotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// MonitoringStatus - Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
	// MarketplaceSubscriptionStatus - Possible values include: 'MarketplaceSubscriptionStatusActive', 'MarketplaceSubscriptionStatusSuspended'
	MarketplaceSubscriptionStatus MarketplaceSubscriptionStatus `json:"marketplaceSubscriptionStatus,omitempty"`
	LogzOrganizationProperties    *OrganizationProperties       `json:"logzOrganizationProperties,omitempty"`
	UserInfo                      *UserInfo                     `json:"userInfo,omitempty"`
	PlanData                      *PlanData                     `json:"planData,omitempty"`
	// LiftrResourceCategory - Possible values include: 'LiftrResourceCategoriesUnknown', 'LiftrResourceCategoriesMonitorLogs'
	LiftrResourceCategory LiftrResourceCategories `json:"liftrResourceCategory,omitempty"`
	// LiftrResourcePreference - READ-ONLY; The priority of the resource.
	LiftrResourcePreference *int32 `json:"liftrResourcePreference,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorProperties.
func (mp MonitorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mp.ProvisioningState != "" {
		objectMap["provisioningState"] = mp.ProvisioningState
	}
	if mp.MonitoringStatus != "" {
		objectMap["monitoringStatus"] = mp.MonitoringStatus
	}
	if mp.MarketplaceSubscriptionStatus != "" {
		objectMap["marketplaceSubscriptionStatus"] = mp.MarketplaceSubscriptionStatus
	}
	if mp.LogzOrganizationProperties != nil {
		objectMap["logzOrganizationProperties"] = mp.LogzOrganizationProperties
	}
	if mp.UserInfo != nil {
		objectMap["userInfo"] = mp.UserInfo
	}
	if mp.PlanData != nil {
		objectMap["planData"] = mp.PlanData
	}
	if mp.LiftrResourceCategory != "" {
		objectMap["liftrResourceCategory"] = mp.LiftrResourceCategory
	}
	return json.Marshal(objectMap)
}

// MonitorResource ...
type MonitorResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the monitor resource.
	ID *string `json:"id,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource
	SystemData *SystemData `json:"systemData,omitempty"`
	// Name - READ-ONLY; Name of the monitor resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the monitor resource.
	Type       *string             `json:"type,omitempty"`
	Properties *MonitorProperties  `json:"properties,omitempty"`
	Identity   *IdentityProperties `json:"identity,omitempty"`
	Tags       map[string]*string  `json:"tags"`
	Location   *string             `json:"location,omitempty"`
}

// MarshalJSON is the custom marshaler for MonitorResource.
func (mr MonitorResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.Properties != nil {
		objectMap["properties"] = mr.Properties
	}
	if mr.Identity != nil {
		objectMap["identity"] = mr.Identity
	}
	if mr.Tags != nil {
		objectMap["tags"] = mr.Tags
	}
	if mr.Location != nil {
		objectMap["location"] = mr.Location
	}
	return json.Marshal(objectMap)
}

// MonitorResourceListResponse response of a list operation.
type MonitorResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]MonitorResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MonitorResourceListResponseIterator provides access to a complete listing of MonitorResource values.
type MonitorResourceListResponseIterator struct {
	i    int
	page MonitorResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MonitorResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MonitorResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MonitorResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MonitorResourceListResponseIterator) Response() MonitorResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MonitorResourceListResponseIterator) Value() MonitorResource {
	if !iter.page.NotDone() {
		return MonitorResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MonitorResourceListResponseIterator type.
func NewMonitorResourceListResponseIterator(page MonitorResourceListResponsePage) MonitorResourceListResponseIterator {
	return MonitorResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrlr MonitorResourceListResponse) IsEmpty() bool {
	return mrlr.Value == nil || len(*mrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrlr MonitorResourceListResponse) hasNextLink() bool {
	return mrlr.NextLink != nil && len(*mrlr.NextLink) != 0
}

// monitorResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrlr MonitorResourceListResponse) monitorResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !mrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrlr.NextLink)))
}

// MonitorResourceListResponsePage contains a page of MonitorResource values.
type MonitorResourceListResponsePage struct {
	fn   func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)
	mrlr MonitorResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MonitorResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrlr)
		if err != nil {
			return err
		}
		page.mrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MonitorResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MonitorResourceListResponsePage) NotDone() bool {
	return !page.mrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MonitorResourceListResponsePage) Response() MonitorResourceListResponse {
	return page.mrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MonitorResourceListResponsePage) Values() []MonitorResource {
	if page.mrlr.IsEmpty() {
		return nil
	}
	return *page.mrlr.Value
}

// Creates a new instance of the MonitorResourceListResponsePage type.
func NewMonitorResourceListResponsePage(cur MonitorResourceListResponse, getNextPage func(context.Context, MonitorResourceListResponse) (MonitorResourceListResponse, error)) MonitorResourceListResponsePage {
	return MonitorResourceListResponsePage{
		fn:   getNextPage,
		mrlr: cur,
	}
}

// MonitorResourceUpdateParameters the parameters for a PATCH request to a monitor resource.
type MonitorResourceUpdateParameters struct {
	Properties *MonitorUpdateProperties `json:"properties,omitempty"`
	// Tags - The new tags of the monitor resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MonitorResourceUpdateParameters.
func (mrup MonitorResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrup.Properties != nil {
		objectMap["properties"] = mrup.Properties
	}
	if mrup.Tags != nil {
		objectMap["tags"] = mrup.Tags
	}
	return json.Marshal(objectMap)
}

// MonitorsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (MonitorResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsCreateFuture.Result.
func (future *MonitorsCreateFuture) result(client MonitorsClient) (mr MonitorResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("logz.MonitorsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mr.Response.Response, err = future.GetResult(sender); err == nil && mr.Response.Response.StatusCode != http.StatusNoContent {
		mr, err = client.CreateResponder(mr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "logz.MonitorsCreateFuture", "Result", mr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MonitorsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MonitorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MonitorsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MonitorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MonitorsDeleteFuture.Result.
func (future *MonitorsDeleteFuture) result(client MonitorsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("logz.MonitorsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MonitorUpdateProperties the set of properties that can be update in a PATCH request to a monitor
// resource.
type MonitorUpdateProperties struct {
	// MonitoringStatus - Possible values include: 'MonitoringStatusEnabled', 'MonitoringStatusDisabled'
	MonitoringStatus MonitoringStatus `json:"monitoringStatus,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider, i.e., Microsoft.Logz.
	Provider *string `json:"provider,omitempty"`
	// Resource - Type on which the operation is performed, e.g., 'monitors'.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation, e.g., 'Write monitors'.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of GET request to list the Microsoft.Logz operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Logz provider.
	Value *[]OperationResult `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationResult values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationResult {
	if !iter.page.NotDone() {
		return OperationResult{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationResult values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationResult {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationResult a Microsoft.Logz REST API operation.
type OperationResult struct {
	// Name - Operation name, i.e., {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool             `json:"isDataAction,omitempty"`
	Display      *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OrganizationProperties ...
type OrganizationProperties struct {
	// CompanyName - Name of the Logz organization.
	CompanyName *string `json:"companyName,omitempty"`
	// ID - READ-ONLY; Id of the Logz organization.
	ID *string `json:"id,omitempty"`
	// EnterpriseAppID - The Id of the Enterprise App used for Single sign on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`
	// SingleSignOnURL - The login URL specific to this Logz Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for OrganizationProperties.
func (op OrganizationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if op.CompanyName != nil {
		objectMap["companyName"] = op.CompanyName
	}
	if op.EnterpriseAppID != nil {
		objectMap["enterpriseAppId"] = op.EnterpriseAppID
	}
	if op.SingleSignOnURL != nil {
		objectMap["singleSignOnUrl"] = op.SingleSignOnURL
	}
	return json.Marshal(objectMap)
}

// PlanData ...
type PlanData struct {
	// UsageType - different usage type like PAYG/COMMITTED. this could be enum
	UsageType *string `json:"usageType,omitempty"`
	// BillingCycle - different billing cycles like MONTHLY/WEEKLY. this could be enum
	BillingCycle *string `json:"billingCycle,omitempty"`
	// PlanDetails - plan id as published by Logz
	PlanDetails *string `json:"planDetails,omitempty"`
	// EffectiveDate - date when plan was applied
	EffectiveDate *date.Time `json:"effectiveDate,omitempty"`
}

// SingleSignOnCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SingleSignOnCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SingleSignOnClient) (SingleSignOnResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SingleSignOnCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SingleSignOnCreateOrUpdateFuture.Result.
func (future *SingleSignOnCreateOrUpdateFuture) result(client SingleSignOnClient) (ssor SingleSignOnResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SingleSignOnCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ssor.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("logz.SingleSignOnCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssor.Response.Response, err = future.GetResult(sender); err == nil && ssor.Response.Response.StatusCode != http.StatusNoContent {
		ssor, err = client.CreateOrUpdateResponder(ssor.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "logz.SingleSignOnCreateOrUpdateFuture", "Result", ssor.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SingleSignOnProperties ...
type SingleSignOnProperties struct {
	// SingleSignOnState - Possible values include: 'SingleSignOnStatesInitial', 'SingleSignOnStatesEnable', 'SingleSignOnStatesDisable', 'SingleSignOnStatesExisting'
	SingleSignOnState SingleSignOnStates `json:"singleSignOnState,omitempty"`
	// EnterpriseAppID - The Id of the Enterprise App used for Single sign-on.
	EnterpriseAppID *string `json:"enterpriseAppId,omitempty"`
	// SingleSignOnURL - The login URL specific to this Logz Organization.
	SingleSignOnURL *string `json:"singleSignOnUrl,omitempty"`
	// ProvisioningState - Possible values include: 'ProvisioningStateAccepted', 'ProvisioningStateCreating', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateNotSpecified'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// SingleSignOnResource ...
type SingleSignOnResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the configuration.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string                 `json:"type,omitempty"`
	SystemData *SystemData             `json:"systemData,omitempty"`
	Properties *SingleSignOnProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SingleSignOnResource.
func (ssor SingleSignOnResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssor.SystemData != nil {
		objectMap["systemData"] = ssor.SystemData
	}
	if ssor.Properties != nil {
		objectMap["properties"] = ssor.Properties
	}
	return json.Marshal(objectMap)
}

// SingleSignOnResourceListResponse response of a list operation.
type SingleSignOnResourceListResponse struct {
	autorest.Response `json:"-"`
	// Value - Results of a list operation.
	Value *[]SingleSignOnResource `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// SingleSignOnResourceListResponseIterator provides access to a complete listing of SingleSignOnResource
// values.
type SingleSignOnResourceListResponseIterator struct {
	i    int
	page SingleSignOnResourceListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SingleSignOnResourceListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SingleSignOnResourceListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SingleSignOnResourceListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SingleSignOnResourceListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SingleSignOnResourceListResponseIterator) Response() SingleSignOnResourceListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SingleSignOnResourceListResponseIterator) Value() SingleSignOnResource {
	if !iter.page.NotDone() {
		return SingleSignOnResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SingleSignOnResourceListResponseIterator type.
func NewSingleSignOnResourceListResponseIterator(page SingleSignOnResourceListResponsePage) SingleSignOnResourceListResponseIterator {
	return SingleSignOnResourceListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssorlr SingleSignOnResourceListResponse) IsEmpty() bool {
	return ssorlr.Value == nil || len(*ssorlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssorlr SingleSignOnResourceListResponse) hasNextLink() bool {
	return ssorlr.NextLink != nil && len(*ssorlr.NextLink) != 0
}

// singleSignOnResourceListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssorlr SingleSignOnResourceListResponse) singleSignOnResourceListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !ssorlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssorlr.NextLink)))
}

// SingleSignOnResourceListResponsePage contains a page of SingleSignOnResource values.
type SingleSignOnResourceListResponsePage struct {
	fn     func(context.Context, SingleSignOnResourceListResponse) (SingleSignOnResourceListResponse, error)
	ssorlr SingleSignOnResourceListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SingleSignOnResourceListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SingleSignOnResourceListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssorlr)
		if err != nil {
			return err
		}
		page.ssorlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SingleSignOnResourceListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SingleSignOnResourceListResponsePage) NotDone() bool {
	return !page.ssorlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SingleSignOnResourceListResponsePage) Response() SingleSignOnResourceListResponse {
	return page.ssorlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SingleSignOnResourceListResponsePage) Values() []SingleSignOnResource {
	if page.ssorlr.IsEmpty() {
		return nil
	}
	return *page.ssorlr.Value
}

// Creates a new instance of the SingleSignOnResourceListResponsePage type.
func NewSingleSignOnResourceListResponsePage(cur SingleSignOnResourceListResponse, getNextPage func(context.Context, SingleSignOnResourceListResponse) (SingleSignOnResourceListResponse, error)) SingleSignOnResourceListResponsePage {
	return SingleSignOnResourceListResponsePage{
		fn:     getNextPage,
		ssorlr: cur,
	}
}

// SubAccountCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubAccountCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubAccountClient) (MonitorResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SubAccountCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SubAccountCreateFuture.Result.
func (future *SubAccountCreateFuture) result(client SubAccountClient) (mr MonitorResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("logz.SubAccountCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mr.Response.Response, err = future.GetResult(sender); err == nil && mr.Response.Response.StatusCode != http.StatusNoContent {
		mr, err = client.CreateResponder(mr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "logz.SubAccountCreateFuture", "Result", mr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SubAccountDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SubAccountDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SubAccountClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SubAccountDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SubAccountDeleteFuture.Result.
func (future *SubAccountDeleteFuture) result(client SubAccountClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.SubAccountDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("logz.SubAccountDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// UserInfo ...
type UserInfo struct {
	// FirstName - First Name of the user
	FirstName *string `json:"firstName,omitempty"`
	// LastName - Last Name of the user
	LastName *string `json:"lastName,omitempty"`
	// EmailAddress - Email of the user used by Logz for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`
	// PhoneNumber - Phone number of the user used by Logz for contacting them if needed
	PhoneNumber *string `json:"phoneNumber,omitempty"`
}

// UserRoleListResponse response for list of user's role for Logz.io account.
type UserRoleListResponse struct {
	autorest.Response `json:"-"`
	// Value - List of user roles for Logz.io account.
	Value *[]UserRoleResponse `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserRoleListResponseIterator provides access to a complete listing of UserRoleResponse values.
type UserRoleListResponseIterator struct {
	i    int
	page UserRoleListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserRoleListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserRoleListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserRoleListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserRoleListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserRoleListResponseIterator) Response() UserRoleListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserRoleListResponseIterator) Value() UserRoleResponse {
	if !iter.page.NotDone() {
		return UserRoleResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserRoleListResponseIterator type.
func NewUserRoleListResponseIterator(page UserRoleListResponsePage) UserRoleListResponseIterator {
	return UserRoleListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (urlr UserRoleListResponse) IsEmpty() bool {
	return urlr.Value == nil || len(*urlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (urlr UserRoleListResponse) hasNextLink() bool {
	return urlr.NextLink != nil && len(*urlr.NextLink) != 0
}

// userRoleListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (urlr UserRoleListResponse) userRoleListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !urlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(urlr.NextLink)))
}

// UserRoleListResponsePage contains a page of UserRoleResponse values.
type UserRoleListResponsePage struct {
	fn   func(context.Context, UserRoleListResponse) (UserRoleListResponse, error)
	urlr UserRoleListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserRoleListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserRoleListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.urlr)
		if err != nil {
			return err
		}
		page.urlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserRoleListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserRoleListResponsePage) NotDone() bool {
	return !page.urlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserRoleListResponsePage) Response() UserRoleListResponse {
	return page.urlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserRoleListResponsePage) Values() []UserRoleResponse {
	if page.urlr.IsEmpty() {
		return nil
	}
	return *page.urlr.Value
}

// Creates a new instance of the UserRoleListResponsePage type.
func NewUserRoleListResponsePage(cur UserRoleListResponse, getNextPage func(context.Context, UserRoleListResponse) (UserRoleListResponse, error)) UserRoleListResponsePage {
	return UserRoleListResponsePage{
		fn:   getNextPage,
		urlr: cur,
	}
}

// UserRoleRequest request for checking user's role for Logz.io account.
type UserRoleRequest struct {
	// EmailAddress - Email of the user used by Logz for contacting them if needed
	EmailAddress *string `json:"emailAddress,omitempty"`
}

// UserRoleResponse response for checking user's role for Logz.io account.
type UserRoleResponse struct {
	// Role - Possible values include: 'UserRoleNone', 'UserRoleUser', 'UserRoleAdmin'
	Role UserRole `json:"role,omitempty"`
}

// VMExtensionPayload response of payload to be passed while installing VM agent.
type VMExtensionPayload struct {
	autorest.Response `json:"-"`
	// APIKey - API Key corresponding to the resource.
	APIKey *string `json:"apiKey,omitempty"`
	// Region - Logz.io region where the resource has been created.
	Region *string `json:"region,omitempty"`
}

// VMHostUpdateRequest request of a list VM Host Update Operation.
type VMHostUpdateRequest struct {
	// VMResourceIds - Request of a list vm host update operation.
	VMResourceIds *[]VMResources `json:"vmResourceIds,omitempty"`
	// State - Specifies the state of the operation - install/ delete. Possible values include: 'VMHostUpdateStatesInstall', 'VMHostUpdateStatesDelete'
	State VMHostUpdateStates `json:"state,omitempty"`
}

// VMResources VM Resource Ids
type VMResources struct {
	// ID - Request of a list vm host update operation.
	ID *string `json:"id,omitempty"`
	// AgentVersion - Version of the Logz agent installed on the VM.
	AgentVersion *string `json:"agentVersion,omitempty"`
}

// VMResourcesListResponse response of a list VM Host Update Operation.
type VMResourcesListResponse struct {
	autorest.Response `json:"-"`
	// Value - Response of a list vm host update operation.
	Value *[]VMResources `json:"value,omitempty"`
	// NextLink - Link to the next set of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// VMResourcesListResponseIterator provides access to a complete listing of VMResources values.
type VMResourcesListResponseIterator struct {
	i    int
	page VMResourcesListResponsePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VMResourcesListResponseIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMResourcesListResponseIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VMResourcesListResponseIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VMResourcesListResponseIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VMResourcesListResponseIterator) Response() VMResourcesListResponse {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VMResourcesListResponseIterator) Value() VMResources {
	if !iter.page.NotDone() {
		return VMResources{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VMResourcesListResponseIterator type.
func NewVMResourcesListResponseIterator(page VMResourcesListResponsePage) VMResourcesListResponseIterator {
	return VMResourcesListResponseIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vrlr VMResourcesListResponse) IsEmpty() bool {
	return vrlr.Value == nil || len(*vrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vrlr VMResourcesListResponse) hasNextLink() bool {
	return vrlr.NextLink != nil && len(*vrlr.NextLink) != 0
}

// vMResourcesListResponsePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vrlr VMResourcesListResponse) vMResourcesListResponsePreparer(ctx context.Context) (*http.Request, error) {
	if !vrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vrlr.NextLink)))
}

// VMResourcesListResponsePage contains a page of VMResources values.
type VMResourcesListResponsePage struct {
	fn   func(context.Context, VMResourcesListResponse) (VMResourcesListResponse, error)
	vrlr VMResourcesListResponse
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VMResourcesListResponsePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VMResourcesListResponsePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vrlr)
		if err != nil {
			return err
		}
		page.vrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VMResourcesListResponsePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VMResourcesListResponsePage) NotDone() bool {
	return !page.vrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VMResourcesListResponsePage) Response() VMResourcesListResponse {
	return page.vrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VMResourcesListResponsePage) Values() []VMResources {
	if page.vrlr.IsEmpty() {
		return nil
	}
	return *page.vrlr.Value
}

// Creates a new instance of the VMResourcesListResponsePage type.
func NewVMResourcesListResponsePage(cur VMResourcesListResponse, getNextPage func(context.Context, VMResourcesListResponse) (VMResourcesListResponse, error)) VMResourcesListResponsePage {
	return VMResourcesListResponsePage{
		fn:   getNextPage,
		vrlr: cur,
	}
}
