package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeliveryHistoryJob invokes the actiontrail.CreateDeliveryHistoryJob API synchronously
func (client *Client) CreateDeliveryHistoryJob(request *CreateDeliveryHistoryJobRequest) (response *CreateDeliveryHistoryJobResponse, err error) {
	response = CreateCreateDeliveryHistoryJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeliveryHistoryJobWithChan invokes the actiontrail.CreateDeliveryHistoryJob API asynchronously
func (client *Client) CreateDeliveryHistoryJobWithChan(request *CreateDeliveryHistoryJobRequest) (<-chan *CreateDeliveryHistoryJobResponse, <-chan error) {
	responseChan := make(chan *CreateDeliveryHistoryJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeliveryHistoryJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeliveryHistoryJobWithCallback invokes the actiontrail.CreateDeliveryHistoryJob API asynchronously
func (client *Client) CreateDeliveryHistoryJobWithCallback(request *CreateDeliveryHistoryJobRequest, callback func(response *CreateDeliveryHistoryJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeliveryHistoryJobResponse
		var err error
		defer close(result)
		response, err = client.CreateDeliveryHistoryJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeliveryHistoryJobRequest is the request struct for api CreateDeliveryHistoryJob
type CreateDeliveryHistoryJobRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	TrailName   string `position:"Query" name:"TrailName"`
}

// CreateDeliveryHistoryJobResponse is the response struct for api CreateDeliveryHistoryJob
type CreateDeliveryHistoryJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     int    `json:"JobId" xml:"JobId"`
}

// CreateCreateDeliveryHistoryJobRequest creates a request to invoke CreateDeliveryHistoryJob API
func CreateCreateDeliveryHistoryJobRequest() (request *CreateDeliveryHistoryJobRequest) {
	request = &CreateDeliveryHistoryJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "CreateDeliveryHistoryJob", "actiontrail", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDeliveryHistoryJobResponse creates a response to parse from CreateDeliveryHistoryJob response
func CreateCreateDeliveryHistoryJobResponse() (response *CreateDeliveryHistoryJobResponse) {
	response = &CreateDeliveryHistoryJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
