package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopActionCustome invokes the cloudwf.ShopActionCustome API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactioncustome.html
func (client *Client) ShopActionCustome(request *ShopActionCustomeRequest) (response *ShopActionCustomeResponse, err error) {
	response = CreateShopActionCustomeResponse()
	err = client.DoAction(request, response)
	return
}

// ShopActionCustomeWithChan invokes the cloudwf.ShopActionCustome API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactioncustome.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopActionCustomeWithChan(request *ShopActionCustomeRequest) (<-chan *ShopActionCustomeResponse, <-chan error) {
	responseChan := make(chan *ShopActionCustomeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopActionCustome(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopActionCustomeWithCallback invokes the cloudwf.ShopActionCustome API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopactioncustome.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopActionCustomeWithCallback(request *ShopActionCustomeRequest, callback func(response *ShopActionCustomeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopActionCustomeResponse
		var err error
		defer close(result)
		response, err = client.ShopActionCustome(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopActionCustomeRequest is the request struct for api ShopActionCustome
type ShopActionCustomeRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// ShopActionCustomeResponse is the response struct for api ShopActionCustome
type ShopActionCustomeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopActionCustomeRequest creates a request to invoke ShopActionCustome API
func CreateShopActionCustomeRequest() (request *ShopActionCustomeRequest) {
	request = &ShopActionCustomeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopActionCustome", "cloudwf", "openAPI")
	return
}

// CreateShopActionCustomeResponse creates a response to parse from ShopActionCustome response
func CreateShopActionCustomeResponse() (response *ShopActionCustomeResponse) {
	response = &ShopActionCustomeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
