package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateResourceEvaluationResults invokes the config.ListAggregateResourceEvaluationResults API synchronously
func (client *Client) ListAggregateResourceEvaluationResults(request *ListAggregateResourceEvaluationResultsRequest) (response *ListAggregateResourceEvaluationResultsResponse, err error) {
	response = CreateListAggregateResourceEvaluationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateResourceEvaluationResultsWithChan invokes the config.ListAggregateResourceEvaluationResults API asynchronously
func (client *Client) ListAggregateResourceEvaluationResultsWithChan(request *ListAggregateResourceEvaluationResultsRequest) (<-chan *ListAggregateResourceEvaluationResultsResponse, <-chan error) {
	responseChan := make(chan *ListAggregateResourceEvaluationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateResourceEvaluationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateResourceEvaluationResultsWithCallback invokes the config.ListAggregateResourceEvaluationResults API asynchronously
func (client *Client) ListAggregateResourceEvaluationResultsWithCallback(request *ListAggregateResourceEvaluationResultsRequest, callback func(response *ListAggregateResourceEvaluationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateResourceEvaluationResultsResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateResourceEvaluationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateResourceEvaluationResultsRequest is the request struct for api ListAggregateResourceEvaluationResults
type ListAggregateResourceEvaluationResultsRequest struct {
	*requests.RpcRequest
	ResourceId     string           `position:"Query" name:"ResourceId"`
	AggregatorId   string           `position:"Query" name:"AggregatorId"`
	ResourceType   string           `position:"Query" name:"ResourceType"`
	NextToken      string           `position:"Query" name:"NextToken"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
	Region         string           `position:"Query" name:"Region"`
	ComplianceType string           `position:"Query" name:"ComplianceType"`
}

// ListAggregateResourceEvaluationResultsResponse is the response struct for api ListAggregateResourceEvaluationResults
type ListAggregateResourceEvaluationResultsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	EvaluationResults EvaluationResults `json:"EvaluationResults" xml:"EvaluationResults"`
}

// CreateListAggregateResourceEvaluationResultsRequest creates a request to invoke ListAggregateResourceEvaluationResults API
func CreateListAggregateResourceEvaluationResultsRequest() (request *ListAggregateResourceEvaluationResultsRequest) {
	request = &ListAggregateResourceEvaluationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateResourceEvaluationResults", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateResourceEvaluationResultsResponse creates a response to parse from ListAggregateResourceEvaluationResults response
func CreateListAggregateResourceEvaluationResultsResponse() (response *ListAggregateResourceEvaluationResultsResponse) {
	response = &ListAggregateResourceEvaluationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
