package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckInvalidAddress invokes the dm.CheckInvalidAddress API synchronously
// api document: https://help.aliyun.com/api/dm/checkinvalidaddress.html
func (client *Client) CheckInvalidAddress(request *CheckInvalidAddressRequest) (response *CheckInvalidAddressResponse, err error) {
	response = CreateCheckInvalidAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CheckInvalidAddressWithChan invokes the dm.CheckInvalidAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/checkinvalidaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckInvalidAddressWithChan(request *CheckInvalidAddressRequest) (<-chan *CheckInvalidAddressResponse, <-chan error) {
	responseChan := make(chan *CheckInvalidAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckInvalidAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckInvalidAddressWithCallback invokes the dm.CheckInvalidAddress API asynchronously
// api document: https://help.aliyun.com/api/dm/checkinvalidaddress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckInvalidAddressWithCallback(request *CheckInvalidAddressRequest, callback func(response *CheckInvalidAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckInvalidAddressResponse
		var err error
		defer close(result)
		response, err = client.CheckInvalidAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckInvalidAddressRequest is the request struct for api CheckInvalidAddress
type CheckInvalidAddressRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ToAddress            string           `position:"Query" name:"ToAddress"`
}

// CheckInvalidAddressResponse is the response struct for api CheckInvalidAddress
type CheckInvalidAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckInvalidAddressRequest creates a request to invoke CheckInvalidAddress API
func CreateCheckInvalidAddressRequest() (request *CheckInvalidAddressRequest) {
	request = &CheckInvalidAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "CheckInvalidAddress", "", "")
	return
}

// CreateCheckInvalidAddressResponse creates a response to parse from CheckInvalidAddress response
func CreateCheckInvalidAddressResponse() (response *CheckInvalidAddressResponse) {
	response = &CheckInvalidAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
