package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGatewayRoute invokes the mse.AddGatewayRoute API synchronously
func (client *Client) AddGatewayRoute(request *AddGatewayRouteRequest) (response *AddGatewayRouteResponse, err error) {
	response = CreateAddGatewayRouteResponse()
	err = client.DoAction(request, response)
	return
}

// AddGatewayRouteWithChan invokes the mse.AddGatewayRoute API asynchronously
func (client *Client) AddGatewayRouteWithChan(request *AddGatewayRouteRequest) (<-chan *AddGatewayRouteResponse, <-chan error) {
	responseChan := make(chan *AddGatewayRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGatewayRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGatewayRouteWithCallback invokes the mse.AddGatewayRoute API asynchronously
func (client *Client) AddGatewayRouteWithCallback(request *AddGatewayRouteRequest, callback func(response *AddGatewayRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGatewayRouteResponse
		var err error
		defer close(result)
		response, err = client.AddGatewayRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGatewayRouteRequest is the request struct for api AddGatewayRoute
type AddGatewayRouteRequest struct {
	*requests.RpcRequest
	GatewayUniqueId    string                            `position:"Query" name:"GatewayUniqueId"`
	DestinationType    string                            `position:"Query" name:"DestinationType"`
	DomainIdListJSON   string                            `position:"Query" name:"DomainIdListJSON"`
	DomainId           requests.Integer                  `position:"Query" name:"DomainId"`
	GatewayId          requests.Integer                  `position:"Query" name:"GatewayId"`
	RouteOrder         requests.Integer                  `position:"Query" name:"RouteOrder"`
	Services           *[]AddGatewayRouteServices        `position:"Query" name:"Services"  type:"Json"`
	Predicates         AddGatewayRoutePredicates         `position:"Query" name:"Predicates"  type:"Struct"`
	RedirectJSON       AddGatewayRouteRedirectJSON       `position:"Query" name:"RedirectJSON"  type:"Struct"`
	DirectResponseJSON AddGatewayRouteDirectResponseJSON `position:"Query" name:"DirectResponseJSON"  type:"Struct"`
	Name               string                            `position:"Query" name:"Name"`
	AcceptLanguage     string                            `position:"Query" name:"AcceptLanguage"`
}

// AddGatewayRouteServices is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRouteServices struct {
	Name       string `name:"Name"`
	Namespace  string `name:"Namespace"`
	SourceType string `name:"SourceType"`
	ServiceId  string `name:"ServiceId"`
	Percent    string `name:"Percent"`
	Version    string `name:"Version"`
	GroupName  string `name:"GroupName"`
}

// AddGatewayRoutePredicates is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRoutePredicates struct {
	PathPredicates   AddGatewayRoutePredicatesPathPredicates          `name:"PathPredicates" type:"Struct"`
	MethodPredicates *[]string                                        `name:"MethodPredicates" type:"Repeated"`
	HeaderPredicates *[]AddGatewayRoutePredicatesHeaderPredicatesItem `name:"HeaderPredicates" type:"Repeated"`
	QueryPredicates  *[]AddGatewayRoutePredicatesQueryPredicatesItem  `name:"QueryPredicates" type:"Repeated"`
}

// AddGatewayRouteRedirectJSON is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRouteRedirectJSON struct {
	Path string `name:"Path"`
	Code string `name:"Code"`
	Host string `name:"Host"`
}

// AddGatewayRouteDirectResponseJSON is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRouteDirectResponseJSON struct {
	Code string `name:"Code"`
	Body string `name:"Body"`
}

// AddGatewayRoutePredicatesPathPredicates is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRoutePredicatesPathPredicates struct {
	Path       string `name:"Path"`
	IgnoreCase string `name:"IgnoreCase"`
	Type       string `name:"Type"`
}

// AddGatewayRoutePredicatesHeaderPredicatesItem is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRoutePredicatesHeaderPredicatesItem struct {
	Type  string `name:"Type"`
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// AddGatewayRoutePredicatesQueryPredicatesItem is a repeated param struct in AddGatewayRouteRequest
type AddGatewayRoutePredicatesQueryPredicatesItem struct {
	Type  string `name:"Type"`
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// AddGatewayRouteResponse is the response struct for api AddGatewayRoute
type AddGatewayRouteResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddGatewayRouteRequest creates a request to invoke AddGatewayRoute API
func CreateAddGatewayRouteRequest() (request *AddGatewayRouteRequest) {
	request = &AddGatewayRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddGatewayRoute", "", "")
	request.Method = requests.POST
	return
}

// CreateAddGatewayRouteResponse creates a response to parse from AddGatewayRoute response
func CreateAddGatewayRouteResponse() (response *AddGatewayRouteResponse) {
	response = &AddGatewayRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
