package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateABTestGroup invokes the opensearch.UpdateABTestGroup API synchronously
func (client *Client) UpdateABTestGroup(request *UpdateABTestGroupRequest) (response *UpdateABTestGroupResponse, err error) {
	response = CreateUpdateABTestGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateABTestGroupWithChan invokes the opensearch.UpdateABTestGroup API asynchronously
func (client *Client) UpdateABTestGroupWithChan(request *UpdateABTestGroupRequest) (<-chan *UpdateABTestGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateABTestGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateABTestGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateABTestGroupWithCallback invokes the opensearch.UpdateABTestGroup API asynchronously
func (client *Client) UpdateABTestGroupWithCallback(request *UpdateABTestGroupRequest, callback func(response *UpdateABTestGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateABTestGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateABTestGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateABTestGroupRequest is the request struct for api UpdateABTestGroup
type UpdateABTestGroupRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// UpdateABTestGroupResponse is the response struct for api UpdateABTestGroup
type UpdateABTestGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateUpdateABTestGroupRequest creates a request to invoke UpdateABTestGroup API
func CreateUpdateABTestGroupRequest() (request *UpdateABTestGroupRequest) {
	request = &UpdateABTestGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateABTestGroup", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]", "opensearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateABTestGroupResponse creates a response to parse from UpdateABTestGroup response
func CreateUpdateABTestGroupResponse() (response *UpdateABTestGroupResponse) {
	response = &UpdateABTestGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
