package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateOnPurchaseSuccess invokes the qualitycheck.UpdateOnPurchaseSuccess API synchronously
func (client *Client) UpdateOnPurchaseSuccess(request *UpdateOnPurchaseSuccessRequest) (response *UpdateOnPurchaseSuccessResponse, err error) {
	response = CreateUpdateOnPurchaseSuccessResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateOnPurchaseSuccessWithChan invokes the qualitycheck.UpdateOnPurchaseSuccess API asynchronously
func (client *Client) UpdateOnPurchaseSuccessWithChan(request *UpdateOnPurchaseSuccessRequest) (<-chan *UpdateOnPurchaseSuccessResponse, <-chan error) {
	responseChan := make(chan *UpdateOnPurchaseSuccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateOnPurchaseSuccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateOnPurchaseSuccessWithCallback invokes the qualitycheck.UpdateOnPurchaseSuccess API asynchronously
func (client *Client) UpdateOnPurchaseSuccessWithCallback(request *UpdateOnPurchaseSuccessRequest, callback func(response *UpdateOnPurchaseSuccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateOnPurchaseSuccessResponse
		var err error
		defer close(result)
		response, err = client.UpdateOnPurchaseSuccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateOnPurchaseSuccessRequest is the request struct for api UpdateOnPurchaseSuccess
type UpdateOnPurchaseSuccessRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UpdateOnPurchaseSuccessResponse is the response struct for api UpdateOnPurchaseSuccess
type UpdateOnPurchaseSuccessResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateOnPurchaseSuccessRequest creates a request to invoke UpdateOnPurchaseSuccess API
func CreateUpdateOnPurchaseSuccessRequest() (request *UpdateOnPurchaseSuccessRequest) {
	request = &UpdateOnPurchaseSuccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateOnPurchaseSuccess", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateOnPurchaseSuccessResponse creates a response to parse from UpdateOnPurchaseSuccess response
func CreateUpdateOnPurchaseSuccessResponse() (response *UpdateOnPurchaseSuccessResponse) {
	response = &UpdateOnPurchaseSuccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
