package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccount invokes the resourcemanager.GetAccount API synchronously
func (client *Client) GetAccount(request *GetAccountRequest) (response *GetAccountResponse, err error) {
	response = CreateGetAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountWithChan invokes the resourcemanager.GetAccount API asynchronously
func (client *Client) GetAccountWithChan(request *GetAccountRequest) (<-chan *GetAccountResponse, <-chan error) {
	responseChan := make(chan *GetAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountWithCallback invokes the resourcemanager.GetAccount API asynchronously
func (client *Client) GetAccountWithCallback(request *GetAccountRequest, callback func(response *GetAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountResponse
		var err error
		defer close(result)
		response, err = client.GetAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountRequest is the request struct for api GetAccount
type GetAccountRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// GetAccountResponse is the response struct for api GetAccount
type GetAccountResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreateGetAccountRequest creates a request to invoke GetAccount API
func CreateGetAccountRequest() (request *GetAccountRequest) {
	request = &GetAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAccountResponse creates a response to parse from GetAccount response
func CreateGetAccountResponse() (response *GetAccountResponse) {
	response = &GetAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
