package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGatewayClass invokes the sgw.ModifyGatewayClass API synchronously
func (client *Client) ModifyGatewayClass(request *ModifyGatewayClassRequest) (response *ModifyGatewayClassResponse, err error) {
	response = CreateModifyGatewayClassResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGatewayClassWithChan invokes the sgw.ModifyGatewayClass API asynchronously
func (client *Client) ModifyGatewayClassWithChan(request *ModifyGatewayClassRequest) (<-chan *ModifyGatewayClassResponse, <-chan error) {
	responseChan := make(chan *ModifyGatewayClassResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGatewayClass(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGatewayClassWithCallback invokes the sgw.ModifyGatewayClass API asynchronously
func (client *Client) ModifyGatewayClassWithCallback(request *ModifyGatewayClassRequest, callback func(response *ModifyGatewayClassResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGatewayClassResponse
		var err error
		defer close(result)
		response, err = client.ModifyGatewayClass(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGatewayClassRequest is the request struct for api ModifyGatewayClass
type ModifyGatewayClassRequest struct {
	*requests.RpcRequest
	GatewayClass  string `position:"Query" name:"GatewayClass"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// ModifyGatewayClassResponse is the response struct for api ModifyGatewayClass
type ModifyGatewayClassResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
	BuyURL    string `json:"BuyURL" xml:"BuyURL"`
}

// CreateModifyGatewayClassRequest creates a request to invoke ModifyGatewayClass API
func CreateModifyGatewayClassRequest() (request *ModifyGatewayClassRequest) {
	request = &ModifyGatewayClassRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "ModifyGatewayClass", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGatewayClassResponse creates a response to parse from ModifyGatewayClass response
func CreateModifyGatewayClassResponse() (response *ModifyGatewayClassResponse) {
	response = &ModifyGatewayClassResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
