package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetAlertCenterResourceByConsole invokes the sls.SetAlertCenterResourceByConsole API synchronously
func (client *Client) SetAlertCenterResourceByConsole(request *SetAlertCenterResourceByConsoleRequest) (response *SetAlertCenterResourceByConsoleResponse, err error) {
	response = CreateSetAlertCenterResourceByConsoleResponse()
	err = client.DoAction(request, response)
	return
}

// SetAlertCenterResourceByConsoleWithChan invokes the sls.SetAlertCenterResourceByConsole API asynchronously
func (client *Client) SetAlertCenterResourceByConsoleWithChan(request *SetAlertCenterResourceByConsoleRequest) (<-chan *SetAlertCenterResourceByConsoleResponse, <-chan error) {
	responseChan := make(chan *SetAlertCenterResourceByConsoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetAlertCenterResourceByConsole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetAlertCenterResourceByConsoleWithCallback invokes the sls.SetAlertCenterResourceByConsole API asynchronously
func (client *Client) SetAlertCenterResourceByConsoleWithCallback(request *SetAlertCenterResourceByConsoleRequest, callback func(response *SetAlertCenterResourceByConsoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetAlertCenterResourceByConsoleResponse
		var err error
		defer close(result)
		response, err = client.SetAlertCenterResourceByConsole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetAlertCenterResourceByConsoleRequest is the request struct for api SetAlertCenterResourceByConsole
type SetAlertCenterResourceByConsoleRequest struct {
	*requests.RpcRequest
	App      string `position:"Body" name:"App"`
	Language string `position:"Body" name:"Language"`
	Region   string `position:"Body" name:"Region"`
}

// SetAlertCenterResourceByConsoleResponse is the response struct for api SetAlertCenterResourceByConsole
type SetAlertCenterResourceByConsoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateSetAlertCenterResourceByConsoleRequest creates a request to invoke SetAlertCenterResourceByConsole API
func CreateSetAlertCenterResourceByConsoleRequest() (request *SetAlertCenterResourceByConsoleRequest) {
	request = &SetAlertCenterResourceByConsoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "SetAlertCenterResourceByConsole", "sls", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetAlertCenterResourceByConsoleResponse creates a response to parse from SetAlertCenterResourceByConsole response
func CreateSetAlertCenterResourceByConsoleResponse() (response *SetAlertCenterResourceByConsoleResponse) {
	response = &SetAlertCenterResourceByConsoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
