package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpconnFromVbr invokes the vpc.CreateVpconnFromVbr API synchronously
func (client *Client) CreateVpconnFromVbr(request *CreateVpconnFromVbrRequest) (response *CreateVpconnFromVbrResponse, err error) {
	response = CreateCreateVpconnFromVbrResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpconnFromVbrWithChan invokes the vpc.CreateVpconnFromVbr API asynchronously
func (client *Client) CreateVpconnFromVbrWithChan(request *CreateVpconnFromVbrRequest) (<-chan *CreateVpconnFromVbrResponse, <-chan error) {
	responseChan := make(chan *CreateVpconnFromVbrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpconnFromVbr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpconnFromVbrWithCallback invokes the vpc.CreateVpconnFromVbr API asynchronously
func (client *Client) CreateVpconnFromVbrWithCallback(request *CreateVpconnFromVbrRequest, callback func(response *CreateVpconnFromVbrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpconnFromVbrResponse
		var err error
		defer close(result)
		response, err = client.CreateVpconnFromVbr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpconnFromVbrRequest is the request struct for api CreateVpconnFromVbr
type CreateVpconnFromVbrRequest struct {
	*requests.RpcRequest
	DryRun    requests.Boolean `position:"Query" name:"DryRun"`
	OrderMode string           `position:"Query" name:"OrderMode"`
	VbrId     string           `position:"Query" name:"VbrId"`
	Token     string           `position:"Query" name:"Token"`
}

// CreateVpconnFromVbrResponse is the response struct for api CreateVpconnFromVbr
type CreateVpconnFromVbrResponse struct {
	*responses.BaseResponse
	RequestId                 string `json:"RequestId" xml:"RequestId"`
	VirtualPhysicalConnection string `json:"VirtualPhysicalConnection" xml:"VirtualPhysicalConnection"`
}

// CreateCreateVpconnFromVbrRequest creates a request to invoke CreateVpconnFromVbr API
func CreateCreateVpconnFromVbrRequest() (request *CreateVpconnFromVbrRequest) {
	request = &CreateVpconnFromVbrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateVpconnFromVbr", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpconnFromVbrResponse creates a response to parse from CreateVpconnFromVbr response
func CreateCreateVpconnFromVbrResponse() (response *CreateVpconnFromVbrResponse) {
	response = &CreateVpconnFromVbrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
