/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.internal.SearchDecoration;
import org.eclipse.ui.internal.findandreplace.FindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.HistoryStore;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolBar;
import org.eclipse.ui.internal.findandreplace.overlay.AccessibleToolItemBuilder;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlayImages;
import org.eclipse.ui.internal.findandreplace.overlay.HistoryTextWrapper;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FindReplaceOverlay {
    public static final String ID_DATA_KEY = "org.eclipse.ui.internal.findreplace.overlay.FindReplaceOverlay.id";
    private static final String REPLACE_BAR_OPEN_DIALOG_SETTING = "replaceBarOpen";
    private static final double WORST_CASE_RATIO_EDITOR_TO_OVERLAY = 0.95;
    private static final double BIG_WIDTH_RATIO_EDITOR_TO_OVERLAY = 0.7;
    private static final String MINIMAL_WIDTH_TEXT = "THIS TEXT IS SHORT ";
    private static final String IDEAL_WIDTH_TEXT = "THIS TEXT HAS A REASONABLE LENGTH FOR SEARCHING";
    private static final int HISTORY_SIZE = 15;
    private FindReplaceLogic findReplaceLogic;
    private final IWorkbenchPart targetPart;
    private boolean replaceBarOpen;
    private final Composite targetControl;
    private Composite containerControl;
    private AccessibleToolBar replaceToggleTools;
    private ToolItem replaceToggle;
    private Composite contentGroup;
    private Composite searchContainer;
    private Composite searchBarContainer;
    private HistoryTextWrapper searchBar;
    private AccessibleToolBar searchTools;
    private ToolItem searchInSelectionButton;
    private ToolItem wholeWordSearchButton;
    private ToolItem caseSensitiveSearchButton;
    private ToolItem regexSearchButton;
    private ToolItem searchBackwardButton;
    private ToolItem searchForwardButton;
    private ToolItem selectAllButton;
    private AccessibleToolBar closeTools;
    private Composite replaceContainer;
    private Composite replaceBarContainer;
    private HistoryTextWrapper replaceBar;
    private AccessibleToolBar replaceTools;
    private ToolItem replaceButton;
    private ToolItem replaceAllButton;
    private Color widgetBackgroundColor;
    private Color overlayBackgroundColor;
    private Color normalTextForegroundColor;
    private Color errorTextForegroundColor;
    private boolean positionAtTop = true;
    private ControlDecoration searchBarDecoration;
    private ContentAssistCommandAdapter contentAssistSearchField;
    private ContentAssistCommandAdapter contentAssistReplaceField;
    private FocusListener targetActionActivationHandling = new FocusListener(){
        private DeactivateGlobalActionHandlers globalActionHandlerDeaction;

        public void focusGained(FocusEvent e) {
            this.setTextEditorActionsActivated(false);
        }

        public void focusLost(FocusEvent e) {
            this.setTextEditorActionsActivated(true);
        }

        private void setTextEditorActionsActivated(boolean state) {
            if (!(FindReplaceOverlay.this.targetPart instanceof AbstractTextEditor) || FindReplaceOverlay.this.targetPart.getSite().getWorkbenchWindow().isClosing()) {
                return;
            }
            IWorkbenchPartSite iWorkbenchPartSite = FindReplaceOverlay.this.targetPart.getSite();
            if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
                MultiPageEditorSite multiEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
                if (!state && this.globalActionHandlerDeaction == null) {
                    this.globalActionHandlerDeaction = new DeactivateGlobalActionHandlers(multiEditorSite.getActionBars());
                } else if (state && this.globalActionHandlerDeaction != null) {
                    this.globalActionHandlerDeaction.reactivate();
                    this.globalActionHandlerDeaction = null;
                }
            }
            try {
                Method method = AbstractTextEditor.class.getDeclaredMethod("setActionActivation", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)FindReplaceOverlay.this.targetPart, state);
            }
            catch (IllegalArgumentException | ReflectiveOperationException ex) {
                TextEditorPlugin.getDefault().getLog().log(Status.error((String)"cannot (de-)activate actions for text editor", (Throwable)ex));
            }
        }

        static final class DeactivateGlobalActionHandlers {
            private static final List<String> ACTIONS = List.of(ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND);
            private final Map<String, IAction> deactivatedActions = new HashMap<String, IAction>();
            private final IActionBars actionBars;

            public DeactivateGlobalActionHandlers(IActionBars actionBars) {
                this.actionBars = actionBars;
                for (String actionID : ACTIONS) {
                    this.deactivatedActions.putIfAbsent(actionID, actionBars.getGlobalActionHandler(actionID));
                    actionBars.setGlobalActionHandler(actionID, null);
                }
            }

            public void reactivate() {
                for (String actionID : this.deactivatedActions.keySet()) {
                    this.actionBars.setGlobalActionHandler(actionID, this.deactivatedActions.get(actionID));
                }
            }
        }
    };
    private final CustomFocusOrder customFocusOrder = new CustomFocusOrder();
    private ControlListener targetMovementListener = ControlListener.controlResizedAdapter(__ -> this.asyncExecIfOpen(this::updatePlacementAndVisibility));
    private FocusListener targetFocusListener = FocusListener.focusGainedAdapter(__ -> {
        this.removeSearchScope();
        this.searchBar.storeHistory();
    });
    private KeyListener closeOnTargetEscapeListener = KeyListener.keyPressedAdapter(c -> {
        if (c.keyCode == 27) {
            this.close();
        }
    });

    public FindReplaceOverlay(Shell parent, IWorkbenchPart part, IFindReplaceTarget target) {
        this.targetPart = part;
        this.targetControl = FindReplaceOverlay.getTargetControl(parent, part);
        this.createFindReplaceLogic(target);
        this.createContainerAndSearchControls(this.targetControl);
        this.containerControl.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.containerControl, "org.eclipse.ui.find_replace_overlay_context");
    }

    private static Composite getTargetControl(Shell targetShell, IWorkbenchPart targetPart) {
        if (targetPart instanceof StatusTextEditor) {
            StatusTextEditor textEditor = (StatusTextEditor)targetPart;
            return textEditor.getAdapter(ITextViewer.class).getTextWidget();
        }
        return targetShell;
    }

    private boolean insertedInTargetParent() {
        return this.targetControl instanceof StyledText;
    }

    private void createFindReplaceLogic(IFindReplaceTarget target) {
        this.findReplaceLogic = new FindReplaceLogic();
        boolean isTargetEditable = false;
        if (target != null) {
            isTargetEditable = target.isEditable();
        }
        this.findReplaceLogic.updateTarget(target, isTargetEditable);
        this.findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.findReplaceLogic.activate(SearchOptions.WRAP);
        this.findReplaceLogic.activate(SearchOptions.FORWARD);
    }

    public Composite getContainerControl() {
        return this.containerControl;
    }

    private void performReplaceAll() {
        BusyIndicator.showWhile((Display)(this.containerControl.getShell() != null ? this.containerControl.getShell().getDisplay() : Display.getCurrent()), this.findReplaceLogic::performReplaceAll);
        this.evaluateStatusAfterReplace();
        this.replaceBar.storeHistory();
        this.searchBar.storeHistory();
    }

    private void performSelectAll() {
        BusyIndicator.showWhile((Display)(this.containerControl.getShell() != null ? this.containerControl.getShell().getDisplay() : Display.getCurrent()), this.findReplaceLogic::performSelectAll);
        this.searchBar.storeHistory();
    }

    private void asyncExecIfOpen(Runnable operation) {
        if (!this.containerControl.isDisposed()) {
            this.containerControl.getDisplay().asyncExec(() -> {
                if (this.containerControl != null || this.containerControl.isDisposed()) {
                    operation.run();
                }
            });
        }
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(FindReplaceAction.class)).getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(FindReplaceAction.class.getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(FindReplaceAction.class.getClass().getName());
        }
        return dialogSettings;
    }

    public void close() {
        if (this.containerControl.isDisposed() || !this.containerControl.isVisible()) {
            return;
        }
        if (this.targetPart != null) {
            this.targetPart.setFocus();
        }
        this.storeOverlaySettings();
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.unbindListeners();
        this.containerControl.setVisible(false);
    }

    public void open() {
        if (!this.containerControl.isVisible()) {
            this.containerControl.setVisible(true);
            this.bindListeners();
            this.restoreOverlaySettings();
        }
        this.assignIDs();
        this.containerControl.layout();
        this.containerControl.moveAbove(null);
        this.updatePlacementAndVisibility();
        this.updateContentAssistAvailability();
        this.searchBar.setFocus();
        this.updateFromTargetSelection();
    }

    private void storeOverlaySettings() {
        this.getDialogSettings().put(REPLACE_BAR_OPEN_DIALOG_SETTING, this.replaceBarOpen);
    }

    private void restoreOverlaySettings() {
        Boolean shouldOpenReplaceBar = this.getDialogSettings().getBoolean(REPLACE_BAR_OPEN_DIALOG_SETTING);
        this.setReplaceVisible(shouldOpenReplaceBar);
    }

    private void assignIDs() {
        this.replaceToggle.setData(ID_DATA_KEY, (Object)"replaceToggle");
        this.searchBar.setData(ID_DATA_KEY, "searchInput");
        this.searchBackwardButton.setData(ID_DATA_KEY, (Object)"searchBackward");
        this.searchForwardButton.setData(ID_DATA_KEY, (Object)"searchForward");
        this.selectAllButton.setData(ID_DATA_KEY, (Object)"selectAll");
        this.searchInSelectionButton.setData(ID_DATA_KEY, (Object)"searchInSelection");
        this.wholeWordSearchButton.setData(ID_DATA_KEY, (Object)"wholeWordSearch");
        this.regexSearchButton.setData(ID_DATA_KEY, (Object)"regExSearch");
        this.caseSensitiveSearchButton.setData(ID_DATA_KEY, (Object)"caseSensitiveSearch");
        if (this.replaceBarOpen) {
            this.replaceBar.setData(ID_DATA_KEY, "replaceInput");
            this.replaceButton.setData(ID_DATA_KEY, (Object)"replaceOne");
            this.replaceAllButton.setData(ID_DATA_KEY, (Object)"replaceAll");
        }
    }

    private void unbindListeners() {
        this.targetControl.removeFocusListener(this.targetFocusListener);
        this.targetControl.removeControlListener(this.targetMovementListener);
        this.targetControl.removeKeyListener(this.closeOnTargetEscapeListener);
    }

    private void bindListeners() {
        this.targetControl.addFocusListener(this.targetFocusListener);
        this.targetControl.addControlListener(this.targetMovementListener);
        this.targetControl.addKeyListener(this.closeOnTargetEscapeListener);
    }

    private void createContainerAndSearchControls(Composite parent) {
        if (this.insertedInTargetParent()) {
            parent = parent.getParent();
        }
        this.retrieveColors();
        this.createMainContainer(parent);
        this.initializeSearchShortcutHandlers();
        this.containerControl.layout();
    }

    private void initializeSearchShortcutHandlers() {
        this.searchTools.registerActionShortcutsAtControl((Control)this.searchBar);
        this.closeTools.registerActionShortcutsAtControl((Control)this.searchBar);
        this.replaceToggleTools.registerActionShortcutsAtControl((Control)this.searchBar);
    }

    private void retrieveColors() {
        IWorkbenchPart iWorkbenchPart = this.targetPart;
        if (iWorkbenchPart instanceof StatusTextEditor) {
            StatusTextEditor textEditor = (StatusTextEditor)iWorkbenchPart;
            StyledText targetWidget = textEditor.getAdapter(ITextViewer.class).getTextWidget();
            this.widgetBackgroundColor = targetWidget.getBackground();
            this.normalTextForegroundColor = targetWidget.getForeground();
        } else {
            Text textBarForRetrievingTheRightColor = new Text((Composite)this.targetControl.getShell(), 132);
            this.targetControl.getShell().layout();
            this.widgetBackgroundColor = textBarForRetrievingTheRightColor.getBackground();
            this.normalTextForegroundColor = textBarForRetrievingTheRightColor.getForeground();
            textBarForRetrievingTheRightColor.dispose();
        }
        this.overlayBackgroundColor = this.retrieveDefaultCompositeBackground();
        this.errorTextForegroundColor = JFaceColors.getErrorText((Display)this.targetControl.getShell().getDisplay());
    }

    private Color retrieveDefaultCompositeBackground() {
        final AtomicReference colorReference = new AtomicReference();
        Dialog dummyDialogForColorRetrieval = new Dialog(this.targetControl.getShell()){

            public void create() {
                super.create();
                colorReference.set(this.getContents().getBackground());
            }
        };
        dummyDialogForColorRetrieval.create();
        dummyDialogForColorRetrieval.close();
        return (Color)colorReference.get();
    }

    private void createMainContainer(Composite parent) {
        this.containerControl = new FixedColorComposite(parent, 0, this.overlayBackgroundColor);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.containerControl);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(2, 2).spacing(2, 0).applyTo(this.containerControl);
        this.createReplaceToggle();
        this.createContentsContainer();
    }

    private void createReplaceToggle() {
        this.replaceToggleTools = new AccessibleToolBar(this.containerControl);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).applyTo((Control)this.replaceToggleTools);
        this.replaceToggleTools.addMouseListener(MouseListener.mouseDownAdapter(__ -> this.setReplaceVisible(!this.replaceBarOpen)));
        this.replaceToggle = new AccessibleToolItemBuilder(this.replaceToggleTools).withShortcuts(KeyboardShortcuts.TOGGLE_REPLACE).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.open_replace")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_replaceToggle_toolTip).withOperation(() -> this.setReplaceVisible(!this.replaceBarOpen)).withShortcuts(KeyboardShortcuts.TOGGLE_REPLACE).build();
    }

    private void createContentsContainer() {
        this.contentGroup = new FixedColorComposite(this.containerControl, 0, this.overlayBackgroundColor);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).spacing(0, 2).applyTo(this.contentGroup);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.contentGroup);
        this.createSearchContainer();
    }

    private void createSearchTools() {
        this.searchTools = new AccessibleToolBar(this.searchContainer);
        GridDataFactory.fillDefaults().grab(false, true).align(3, 3).applyTo((Control)this.searchTools);
        this.searchTools.createToolItem(2);
        this.createCaseSensitiveButton();
        this.createRegexSearchButton();
        this.createWholeWordsButton();
        this.createAreaSearchButton();
        this.searchTools.createToolItem(2);
        this.searchBackwardButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.select_prev")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_upSearchButton_toolTip).withOperation(() -> this.performSearch(false)).withShortcuts(KeyboardShortcuts.SEARCH_BACKWARD).build();
        this.searchForwardButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.select_next")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_downSearchButton_toolTip).withOperation(() -> this.performSearch(true)).withShortcuts(KeyboardShortcuts.SEARCH_FORWARD).build();
        this.searchForwardButton.setSelection(true);
        this.selectAllButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.search_all")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_searchAllButton_toolTip).withOperation(this::performSelectAll).withShortcuts(KeyboardShortcuts.SEARCH_ALL).build();
    }

    private void createCloseTools() {
        this.closeTools = new AccessibleToolBar(this.searchContainer);
        GridDataFactory.fillDefaults().grab(false, true).align(3, 3).applyTo((Control)this.closeTools);
        new AccessibleToolItemBuilder(this.closeTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.close")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_closeButton_toolTip).withOperation(this::close).withShortcuts(KeyboardShortcuts.CLOSE).build();
    }

    private void createAreaSearchButton() {
        this.searchInSelectionButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.search_in_selection")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_searchInSelectionButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.GLOBAL, !this.searchInSelectionButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_SEARCH_IN_SELECTION).build();
        this.searchInSelectionButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
    }

    private void createRegexSearchButton() {
        this.regexSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.regex")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_regexSearchButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.REGEX, this.regexSearchButton.getSelection());
            this.wholeWordSearchButton.setEnabled(this.findReplaceLogic.isAvailable(SearchOptions.WHOLE_WORD));
            this.updateIncrementalSearch();
            this.updateContentAssistAvailability();
            this.decorate();
        }).withShortcuts(KeyboardShortcuts.OPTION_REGEX).build();
        this.regexSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.REGEX));
    }

    private void createCaseSensitiveButton() {
        this.caseSensitiveSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.case_sensitive")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_caseSensitiveButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.CASE_SENSITIVE, this.caseSensitiveSearchButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_CASE_SENSITIVE).build();
        this.caseSensitiveSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.CASE_SENSITIVE));
    }

    private void createWholeWordsButton() {
        this.wholeWordSearchButton = new AccessibleToolItemBuilder(this.searchTools).withStyleBits(32).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.whole_word")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_wholeWordsButton_toolTip).withOperation(() -> {
            this.activateInFindReplacerIf(SearchOptions.WHOLE_WORD, this.wholeWordSearchButton.getSelection());
            this.updateIncrementalSearch();
        }).withShortcuts(KeyboardShortcuts.OPTION_WHOLE_WORD).build();
        this.wholeWordSearchButton.setSelection(this.findReplaceLogic.isActive(SearchOptions.WHOLE_WORD));
    }

    private void createReplaceTools() {
        this.replaceTools = new AccessibleToolBar(this.replaceContainer);
        this.replaceTools.createToolItem(2);
        GridDataFactory.fillDefaults().grab(false, true).align(2, 3).applyTo((Control)this.replaceTools);
        this.replaceButton = new AccessibleToolItemBuilder(this.replaceTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.replace")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_replaceButton_toolTip).withOperation(() -> {
            if (this.getFindString().isEmpty()) {
                this.applyErrorColor(this.replaceBar);
                return;
            }
            this.performSingleReplace();
        }).withShortcuts(KeyboardShortcuts.SEARCH_FORWARD).build();
        this.replaceAllButton = new AccessibleToolItemBuilder(this.replaceTools).withStyleBits(8).withImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.replace_all")).withToolTipText(FindReplaceMessages.FindReplaceOverlay_replaceAllButton_toolTip).withOperation(() -> {
            if (this.getFindString().isEmpty()) {
                this.applyErrorColor(this.replaceBar);
                return;
            }
            this.performReplaceAll();
        }).withShortcuts(KeyboardShortcuts.SEARCH_ALL).build();
    }

    private ContentAssistCommandAdapter createContentAssistField(HistoryTextWrapper control, boolean isFind) {
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(isFind);
        return new ContentAssistCommandAdapter((Control)control.getTextBar(), (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
    }

    private void createSearchBar() {
        this.searchBarContainer = new Composite(this.searchContainer, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchBarContainer);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.searchBarContainer);
        HistoryStore searchHistory = new HistoryStore(this.getDialogSettings(), "findhistory", 15);
        this.searchBar = new HistoryTextWrapper(searchHistory, this.searchBarContainer, 4);
        this.searchBarDecoration = new ControlDecoration((Control)this.searchBar, 17408);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchBar);
        this.searchBar.forceFocus();
        this.searchBar.selectAll();
        this.searchBar.addModifyListener(e -> {
            this.wholeWordSearchButton.setEnabled(this.findReplaceLogic.isAvailable(SearchOptions.WHOLE_WORD));
            this.updateIncrementalSearch();
            this.decorate();
        });
        this.searchBar.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                FindReplaceOverlay.this.findReplaceLogic.resetIncrementalBaseLocation();
            }

            public void focusLost(FocusEvent e) {
                FindReplaceOverlay.this.resetErrorColoring();
            }
        });
        this.searchBar.addFocusListener(this.targetActionActivationHandling);
        this.searchBar.setMessage(FindReplaceMessages.FindReplaceOverlay_searchBar_message);
        this.contentAssistSearchField = this.createContentAssistField(this.searchBar, true);
        this.searchBar.setTabList(null);
    }

    private void updateIncrementalSearch() {
        this.findReplaceLogic.setFindString(this.searchBar.getText());
        this.evaluateStatusAfterFind();
    }

    private void createReplaceBar() {
        this.replaceBarContainer = new Composite(this.replaceContainer, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 3).applyTo((Control)this.replaceBarContainer);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(this.replaceBarContainer);
        HistoryStore replaceHistory = new HistoryStore(this.getDialogSettings(), "replacehistory", 15);
        this.replaceBar = new HistoryTextWrapper(replaceHistory, this.replaceBarContainer, 4);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)this.replaceBar);
        this.replaceBar.setMessage(FindReplaceMessages.FindReplaceOverlay_replaceBar_message);
        this.replaceBar.addModifyListener(e -> {
            this.findReplaceLogic.setReplaceString(this.replaceBar.getText());
            this.resetErrorColoring();
        });
        this.replaceBar.addFocusListener(this.targetActionActivationHandling);
        this.replaceBar.addFocusListener(FocusListener.focusLostAdapter(e -> this.resetErrorColoring()));
        this.contentAssistReplaceField = this.createContentAssistField(this.replaceBar, false);
    }

    private void createSearchContainer() {
        this.searchContainer = new FixedColorComposite(this.contentGroup, 0, this.widgetBackgroundColor);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.searchContainer);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(7, 4, 3, 5).equalWidth(false).applyTo(this.searchContainer);
        this.createSearchBar();
        this.createSearchTools();
        this.createCloseTools();
    }

    private void createReplaceContainer() {
        this.replaceContainer = new FixedColorComposite(this.contentGroup, 0, this.widgetBackgroundColor);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.replaceContainer);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).extendedMargins(7, 4, 3, 5).equalWidth(false).applyTo(this.replaceContainer);
        this.createReplaceBar();
        this.createReplaceTools();
    }

    private void setReplaceVisible(boolean visible) {
        if (this.findReplaceLogic.getTarget().isEditable() && visible) {
            this.createReplaceDialog();
            this.replaceToggle.setImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.close_replace"));
        } else {
            this.hideReplace();
            this.replaceToggle.setImage(FindReplaceOverlayImages.get("org.eclipse.ui.workbench.texteditor.elcl.open_replace"));
        }
        this.updateContentAssistAvailability();
    }

    private void hideReplace() {
        if (!this.replaceBarOpen) {
            return;
        }
        this.customFocusOrder.dispose();
        this.searchBar.forceFocus();
        this.contentAssistReplaceField = null;
        this.replaceBarOpen = false;
        this.replaceContainer.dispose();
        this.updatePlacementAndVisibility();
    }

    private void createReplaceDialog() {
        if (this.replaceBarOpen) {
            return;
        }
        this.replaceBarOpen = true;
        this.createReplaceContainer();
        this.initializeReplaceShortcutHandlers();
        this.updatePlacementAndVisibility();
        this.assignIDs();
        this.replaceBar.forceFocus();
        this.customFocusOrder.apply();
    }

    private void initializeReplaceShortcutHandlers() {
        this.replaceTools.registerActionShortcutsAtControl((Control)this.replaceBar);
        this.closeTools.registerActionShortcutsAtControl((Control)this.replaceBar);
        this.replaceToggleTools.registerActionShortcutsAtControl((Control)this.replaceBar);
    }

    private void enableSearchTools(boolean enable) {
        ((GridData)this.searchTools.getLayoutData()).exclude = !enable;
        this.searchTools.setVisible(enable);
    }

    private void enableReplaceToggle(boolean enable) {
        if (!FindReplaceOverlay.okayToUse((Widget)this.replaceToggle)) {
            return;
        }
        boolean shouldBeVisible = enable && this.findReplaceLogic.getTarget().isEditable();
        ((GridLayout)this.containerControl.getLayout()).numColumns = shouldBeVisible ? 2 : 1;
        ((GridData)this.replaceToggleTools.getLayoutData()).exclude = !shouldBeVisible;
        this.replaceToggleTools.setVisible(shouldBeVisible);
    }

    private void enableReplaceTools(boolean enable) {
        if (!FindReplaceOverlay.okayToUse((Widget)this.replaceTools)) {
            return;
        }
        ((GridData)this.replaceTools.getLayoutData()).exclude = !enable;
        this.replaceTools.setVisible(enable);
    }

    private int getIdealOverlayWidth(Rectangle targetBounds) {
        int idealOverlayWidth = this.calculateOverlayWidthWithToolbars(IDEAL_WIDTH_TEXT);
        int minimumOverlayWidth = Math.min(this.calculateOverlayWidthWithoutToolbars(MINIMAL_WIDTH_TEXT), (int)((double)targetBounds.width * 0.95));
        int overlayWidth = idealOverlayWidth;
        int maximumOverlayWidth = (int)((double)targetBounds.width * 0.7);
        if (overlayWidth > maximumOverlayWidth) {
            overlayWidth = maximumOverlayWidth;
        }
        if (overlayWidth < minimumOverlayWidth) {
            overlayWidth = minimumOverlayWidth;
        }
        return overlayWidth;
    }

    private void configureDisplayedWidgetsForWidth(int overlayWidth) {
        int minimumWidthWithToolbars = this.calculateOverlayWidthWithoutToolbars(IDEAL_WIDTH_TEXT);
        int minimumWidthWithReplaceToggle = this.calculateOverlayWidthWithoutToolbars(MINIMAL_WIDTH_TEXT);
        this.enableSearchTools(overlayWidth >= minimumWidthWithToolbars);
        this.enableReplaceTools(overlayWidth >= minimumWidthWithToolbars);
        this.enableReplaceToggle(overlayWidth >= minimumWidthWithReplaceToggle);
    }

    private int calculateOverlayWidthWithToolbars(String searchInput) {
        int toolbarWidth = this.searchTools.getSize().x;
        return this.calculateOverlayWidthWithoutToolbars(searchInput) + toolbarWidth;
    }

    private int calculateOverlayWidthWithoutToolbars(String searchInput) {
        int replaceToggleWidth = 0;
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceToggle)) {
            replaceToggleWidth = this.replaceToggle.getBounds().width;
        }
        int closeButtonWidth = this.closeTools.getSize().x;
        int searchInputWidth = this.getTextWidthInSearchBar(searchInput);
        return replaceToggleWidth + closeButtonWidth + searchInputWidth;
    }

    private int getTextWidthInSearchBar(String input) {
        GC gc = new GC((Drawable)this.searchBar);
        gc.setFont(this.searchBar.getFont());
        int textWidth = gc.stringExtent((String)input).x;
        gc.dispose();
        return textWidth;
    }

    private void repositionTextSelection() {
        if (FindReplaceOverlay.okayToUse((Widget)this.searchBar) && !this.searchBar.isFocusControl()) {
            this.searchBar.setSelection(0, 0);
        }
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceBar) && !this.replaceBar.isFocusControl()) {
            this.replaceBar.setSelection(0, 0);
        }
    }

    private void updatePlacementAndVisibility() {
        if (!FindReplaceOverlay.okayToUse((Widget)this.targetControl)) {
            this.close();
            return;
        }
        this.containerControl.requestLayout();
        Rectangle targetControlBounds = this.calculateControlBounds((Control)this.targetControl);
        Rectangle overlayBounds = this.calculateDesiredOverlayBounds(targetControlBounds);
        this.updatePosition(overlayBounds);
        this.configureDisplayedWidgetsForWidth(overlayBounds.width);
        this.updateVisibility(targetControlBounds, overlayBounds);
        this.repositionTextSelection();
    }

    private Rectangle calculateControlBounds(Control control) {
        Rectangle controlBounds = control.getBounds();
        int width = controlBounds.width;
        int height = controlBounds.height;
        int x = 0;
        int y = 0;
        if (this.insertedInTargetParent()) {
            x = controlBounds.x;
            y = controlBounds.y;
        }
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            ScrollBar verticalBar = scrollable.getVerticalBar();
            ScrollBar horizontalBar = scrollable.getHorizontalBar();
            if (verticalBar != null) {
                width -= verticalBar.getSize().x;
            }
            if (horizontalBar != null) {
                height -= horizontalBar.getSize().y;
            }
        }
        if (control instanceof StyledText) {
            StyledText styledText = (StyledText)control;
            width -= styledText.getRightMargin();
        }
        return new Rectangle(x, y, width, height);
    }

    private Rectangle calculateDesiredOverlayBounds(Rectangle targetControlBounds) {
        int width = this.getIdealOverlayWidth(targetControlBounds);
        int height = this.containerControl.computeSize((int)-1, (int)-1).y;
        int x = targetControlBounds.x + targetControlBounds.width - width;
        int y = targetControlBounds.y;
        if (!this.positionAtTop) {
            y += targetControlBounds.height - height;
        }
        return new Rectangle(x, y, width, height);
    }

    private void updatePosition(Rectangle overlayBounds) {
        this.containerControl.setSize(new Point(overlayBounds.width, overlayBounds.height));
        this.containerControl.setLocation(new Point(overlayBounds.x, overlayBounds.y));
        this.containerControl.layout(true);
    }

    private void updateVisibility(Rectangle targetControlBounds, Rectangle overlayBounds) {
        boolean shallBeVisible = true;
        if (this.positionAtTop) {
            shallBeVisible = overlayBounds.y + overlayBounds.height <= targetControlBounds.y + targetControlBounds.height;
        } else {
            boolean bl = shallBeVisible = overlayBounds.y >= targetControlBounds.y;
        }
        if (shallBeVisible != this.containerControl.isVisible()) {
            this.containerControl.setVisible(shallBeVisible);
        }
    }

    private String getFindString() {
        return this.searchBar.getText();
    }

    private void performSingleReplace() {
        if (this.findReplaceLogic.performSelectAndReplace()) {
            this.findReplaceLogic.performSearch();
            this.evaluateStatusAfterFind();
        } else {
            this.evaluateStatusAfterReplace();
        }
        this.replaceBar.storeHistory();
        this.searchBar.storeHistory();
    }

    private void performSearch(boolean forward) {
        boolean oldForwardSearchSetting = this.findReplaceLogic.isActive(SearchOptions.FORWARD);
        this.activateInFindReplacerIf(SearchOptions.FORWARD, forward);
        this.findReplaceLogic.performSearch();
        this.activateInFindReplacerIf(SearchOptions.FORWARD, oldForwardSearchSetting);
        this.evaluateStatusAfterFind();
        this.searchBar.storeHistory();
    }

    private void updateFromTargetSelection() {
        String selectionText = this.findReplaceLogic.getTarget().getSelectionText();
        if (selectionText.contains("\n")) {
            this.findReplaceLogic.deactivate(SearchOptions.GLOBAL);
            this.searchInSelectionButton.setSelection(true);
        } else if (!selectionText.isEmpty()) {
            if (this.findReplaceLogic.isAvailableAndActive(SearchOptions.REGEX)) {
                selectionText = FindReplaceDocumentAdapter.escapeForRegExPattern((String)selectionText);
            }
            this.searchBar.setText(selectionText);
            this.findReplaceLogic.findAndSelect(this.findReplaceLogic.getTarget().getSelection().x);
        }
        this.searchBar.setSelection(0, this.searchBar.getText().length());
    }

    private void evaluateStatusAfterFind() {
        this.resetErrorColoring();
        if (!this.findReplaceLogic.getStatus().wasSuccessful()) {
            this.applyErrorColor(this.searchBar);
        }
    }

    private void evaluateStatusAfterReplace() {
        this.resetErrorColoring();
        if (!this.findReplaceLogic.getStatus().wasSuccessful()) {
            this.applyErrorColor(this.replaceBar);
        }
    }

    private void applyErrorColor(HistoryTextWrapper inputField) {
        inputField.setForeground(this.errorTextForegroundColor);
    }

    private void resetErrorColoring() {
        this.searchBar.setForeground(this.normalTextForegroundColor);
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceBar)) {
            this.replaceBar.setForeground(this.normalTextForegroundColor);
        }
    }

    private void activateInFindReplacerIf(SearchOptions option, boolean shouldActivate) {
        if (shouldActivate) {
            this.findReplaceLogic.activate(option);
        } else {
            this.findReplaceLogic.deactivate(option);
        }
    }

    private static boolean okayToUse(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    public void setPositionToTop(boolean shouldPositionOverlayOnTop) {
        this.positionAtTop = shouldPositionOverlayOnTop;
        if (this.containerControl != null && this.containerControl.isVisible()) {
            this.updatePlacementAndVisibility();
        }
    }

    private void removeSearchScope() {
        this.findReplaceLogic.activate(SearchOptions.GLOBAL);
        this.searchInSelectionButton.setSelection(false);
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.contentAssistSearchField.setEnabled(enable);
        if (FindReplaceOverlay.okayToUse((Widget)this.replaceBar)) {
            this.contentAssistReplaceField.setEnabled(enable);
        }
    }

    private void updateContentAssistAvailability() {
        this.setContentAssistsEnablement(this.findReplaceLogic.isAvailableAndActive(SearchOptions.REGEX));
    }

    private void decorate() {
        if (this.regexSearchButton.getSelection()) {
            SearchDecoration.validateRegex((String)this.getFindString(), (ControlDecoration)this.searchBarDecoration);
        } else {
            this.searchBarDecoration.hide();
        }
    }

    private class CustomFocusOrder {
        private final Listener searchBarToReplaceBar = e -> {
            if (e.detail == 16) {
                e.doit = false;
                FindReplaceOverlay.this.replaceBar.forceFocus();
            }
        };
        private final Listener replaceBarToSearchBarAndTools = e -> {
            switch (e.detail) {
                case 16: {
                    e.doit = false;
                    FindReplaceOverlay.this.searchBar.getDropDownTool().getFirstControl().forceFocus();
                    break;
                }
                case 8: {
                    e.doit = false;
                    FindReplaceOverlay.this.searchBar.getTextBar().forceFocus();
                }
            }
        };
        private final Listener searchToolsToReplaceBar = e -> {
            switch (e.detail) {
                case 8: {
                    e.doit = false;
                    FindReplaceOverlay.this.replaceBar.forceFocus();
                }
            }
        };
        private final Listener closeToolsToReplaceTools = e -> {
            switch (e.detail) {
                case 16: {
                    e.doit = false;
                    FindReplaceOverlay.this.replaceBar.getDropDownTool().getFirstControl().forceFocus();
                }
            }
        };
        private final Listener replaceToolsToCloseTools = e -> {
            switch (e.detail) {
                case 8: {
                    e.doit = false;
                    FindReplaceOverlay.this.closeTools.getFirstControl().forceFocus();
                }
            }
        };

        private CustomFocusOrder() {
        }

        void apply() {
            FindReplaceOverlay.this.searchBar.getTextBar().addListener(31, this.searchBarToReplaceBar);
            FindReplaceOverlay.this.replaceBar.getTextBar().addListener(31, this.replaceBarToSearchBarAndTools);
            FindReplaceOverlay.this.searchBar.getDropDownTool().getFirstControl().addListener(31, this.searchToolsToReplaceBar);
            FindReplaceOverlay.this.closeTools.getFirstControl().addListener(31, this.closeToolsToReplaceTools);
            FindReplaceOverlay.this.replaceBar.getDropDownTool().getFirstControl().addListener(31, this.replaceToolsToCloseTools);
        }

        void dispose() {
            FindReplaceOverlay.this.searchBar.getTextBar().removeListener(31, this.searchBarToReplaceBar);
            FindReplaceOverlay.this.replaceBar.getTextBar().removeListener(31, this.replaceBarToSearchBarAndTools);
            FindReplaceOverlay.this.searchBar.getDropDownTool().getFirstControl().removeListener(31, this.searchToolsToReplaceBar);
            FindReplaceOverlay.this.closeTools.getFirstControl().removeListener(31, this.closeToolsToReplaceTools);
            FindReplaceOverlay.this.replaceBar.getDropDownTool().getFirstControl().removeListener(31, this.replaceToolsToCloseTools);
        }
    }

    private class FixedColorComposite
    extends Composite {
        private Color fixColor;

        public FixedColorComposite(Composite parent, int style, Color backgroundColor) {
            super(parent, style);
            this.fixColor = backgroundColor;
            this.setBackground(backgroundColor);
        }

        public void setBackground(Color unusedColor) {
            super.setBackground(this.fixColor);
        }
    }

    private final class KeyboardShortcuts {
        private static final List<KeyStroke> SEARCH_FORWARD = List.of(KeyStroke.getInstance((int)13), KeyStroke.getInstance((int)0x1000050));
        private static final List<KeyStroke> SEARCH_BACKWARD = List.of(KeyStroke.getInstance((int)131072, (int)13), KeyStroke.getInstance((int)131072, (int)0x1000050));
        private static final List<KeyStroke> SEARCH_ALL = List.of(KeyStroke.getInstance((int)SWT.MOD1, (int)13), KeyStroke.getInstance((int)SWT.MOD1, (int)0x1000050));
        private static final List<KeyStroke> OPTION_CASE_SENSITIVE = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)67), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)99));
        private static final List<KeyStroke> OPTION_WHOLE_WORD = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)68), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)100));
        private static final List<KeyStroke> OPTION_REGEX = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)80), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)112));
        private static final List<KeyStroke> OPTION_SEARCH_IN_SELECTION = List.of(KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)73), KeyStroke.getInstance((int)(SWT.MOD1 | 0x20000), (int)105));
        private static final List<KeyStroke> CLOSE = List.of(KeyStroke.getInstance((int)27), KeyStroke.getInstance((int)SWT.MOD1, (int)70), KeyStroke.getInstance((int)SWT.MOD1, (int)102));
        private static final List<KeyStroke> TOGGLE_REPLACE = List.of(KeyStroke.getInstance((int)SWT.MOD1, (int)82), KeyStroke.getInstance((int)SWT.MOD1, (int)114));

        private KeyboardShortcuts() {
        }
    }
}

