/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.json.JsonBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class RemoveProhibitedPropertyFix
extends PsiUpdateModCommandQuickFix {
    private final JsonValidationError.ProhibitedPropertyIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public RemoveProhibitedPropertyFix(JsonValidationError.ProhibitedPropertyIssueData data, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"remove.prohibited.property", (Object[])new Object[0]);
        if (string == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.getFamilyName() + " '" + this.myData.propertyName + "'";
        if (string == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        JsonLikePsiWalker walker;
        if (project == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(4);
        }
        if ((walker = JsonLikePsiWalker.getWalker(element)) == null) {
            return;
        }
        JsonPropertyAdapter parentProperty = walker.getParentPropertyAdapter(element);
        assert (this.myData.propertyName.equals(Objects.requireNonNull(parentProperty).getName()));
        this.myQuickFixAdapter.removeProperty(parentProperty.getDelegate());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/RemoveProhibitedPropertyFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/RemoveProhibitedPropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

