/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.listener;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class ChatModelResponse {
    private final String id;
    private final String model;
    private final TokenUsage tokenUsage;
    private final FinishReason finishReason;
    private final AiMessage aiMessage;

    public ChatModelResponse(String id, String model, TokenUsage tokenUsage, FinishReason finishReason, AiMessage aiMessage) {
        this.id = id;
        this.model = model;
        this.tokenUsage = tokenUsage;
        this.finishReason = finishReason;
        this.aiMessage = aiMessage;
    }

    static ChatModelResponse fromChatResponse(ChatResponse chatResponse) {
        if (chatResponse == null) {
            return null;
        }
        ChatResponseMetadata chatResponseMetadata = chatResponse.metadata();
        return ChatModelResponse.builder().id(chatResponseMetadata.id()).model(chatResponseMetadata.modelName()).tokenUsage(chatResponseMetadata.tokenUsage()).finishReason(chatResponseMetadata.finishReason()).aiMessage(chatResponse.aiMessage()).build();
    }

    static ChatResponse toChatResponse(ChatModelResponse chatModelResponse) {
        if (chatModelResponse == null) {
            return null;
        }
        return ChatResponse.builder().aiMessage(chatModelResponse.aiMessage()).metadata(((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)ChatResponseMetadata.builder().id(chatModelResponse.id())).modelName(chatModelResponse.model())).tokenUsage(chatModelResponse.tokenUsage())).finishReason(chatModelResponse.finishReason())).build()).build();
    }

    public static ChatModelResponseBuilder builder() {
        return new ChatModelResponseBuilder();
    }

    public String id() {
        return this.id;
    }

    public String model() {
        return this.model;
    }

    public TokenUsage tokenUsage() {
        return this.tokenUsage;
    }

    public FinishReason finishReason() {
        return this.finishReason;
    }

    public AiMessage aiMessage() {
        return this.aiMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatModelResponse that = (ChatModelResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.model, that.model) && Objects.equals(this.tokenUsage, that.tokenUsage) && this.finishReason == that.finishReason && Objects.equals(this.aiMessage, that.aiMessage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.model, this.tokenUsage, this.finishReason, this.aiMessage});
    }

    public static class ChatModelResponseBuilder {
        private String id;
        private String model;
        private TokenUsage tokenUsage;
        private FinishReason finishReason;
        private AiMessage aiMessage;

        ChatModelResponseBuilder() {
        }

        public ChatModelResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ChatModelResponseBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatModelResponseBuilder tokenUsage(TokenUsage tokenUsage) {
            this.tokenUsage = tokenUsage;
            return this;
        }

        public ChatModelResponseBuilder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public ChatModelResponseBuilder aiMessage(AiMessage aiMessage) {
            this.aiMessage = aiMessage;
            return this;
        }

        public ChatModelResponse build() {
            return new ChatModelResponse(this.id, this.model, this.tokenUsage, this.finishReason, this.aiMessage);
        }

        public String toString() {
            return "ChatModelResponse.ChatModelResponseBuilder(id=" + this.id + ", model=" + this.model + ", tokenUsage=" + String.valueOf(this.tokenUsage) + ", finishReason=" + String.valueOf((Object)this.finishReason) + ", aiMessage=" + String.valueOf(this.aiMessage) + ")";
        }
    }
}

