/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.google.common.collect.Collections2;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.impl.DjangoTemplateHierarchyVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import java.util.Collection;

public final class DjangoTemplateDescriptorProvider
implements XmlElementDescriptorProvider {
    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        PsiFile file = tag.getContainingFile().getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE);
        PsiFile file1 = tag.getContainingFile();
        if (file != null && file1 instanceof XmlFile) {
            XmlProlog prolog;
            XmlDoctype doctype;
            XmlDocument document1 = ((XmlFile)file1).getDocument();
            if (document1 != null && (doctype = (prolog = document1.getProlog()).getDoctype()) != null) {
                return null;
            }
            DjangoHtmlDocumentVisitor visitor2 = new DjangoHtmlDocumentVisitor();
            file.accept((PsiElementVisitor)visitor2);
            for (XmlDocument document : visitor2.getVisitedXmlDocument()) {
                if (document == null || !HtmlUtil.isHtml5Document((XmlDocument)document)) continue;
                XmlNSDescriptor htmlNSDescriptor = document.getDefaultNSDescriptor(tag.getNamespace(), false);
                if (htmlNSDescriptor == null) {
                    return null;
                }
                return htmlNSDescriptor instanceof XmlNSDescriptorImpl ? ((XmlNSDescriptorImpl)htmlNSDescriptor).getElementDescriptor(tag.getLocalName(), tag.getNamespace()) : htmlNSDescriptor.getElementDescriptor(tag);
            }
        }
        return null;
    }

    static class DjangoHtmlDocumentVisitor
    extends DjangoTemplateHierarchyVisitor {
        DjangoHtmlDocumentVisitor() {
        }

        public Collection<XmlDocument> getVisitedXmlDocument() {
            return Collections2.transform((Collection)this.myVisitedFiles, input -> {
                XmlFile xmlFile = (XmlFile)input.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
                if (xmlFile != null) {
                    return xmlFile.getDocument();
                }
                return null;
            });
        }
    }
}

