/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.psi.PuppetNamedScopeHolder;
import com.intellij.lang.puppet.psi.PuppetNodeDefinition;
import com.intellij.lang.puppet.psi.PupppetTopScopeHolder;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.lang.puppet.psi.resolve.PuppetVariableScopeProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetPsiFileImpl
extends PsiFileBase
implements PuppetNamedScopeHolder,
PupppetTopScopeHolder {
    @NonNls
    private static final String PUPPET_BUILTIN_STUBS_FILE_NAME = "builtin.pp";
    private static final String PUPPET_BUILTIN_STUBS_FILE_PATH = PuppetLibraryUtil.PUPPET_STUBS_ROOT_PATH + "builtin.pp";
    private static final Key<Boolean> PUPPET_BUILTIN_STUBS_FILE_KEY = Key.create((String)"it's a puppet builtins stubs file");
    @NonNls
    private static final String PUPPET_BUILTIN_VARIABLES_STUBS_FILE_NAME = "builtin_variables.pp";
    private static final String PUPPET_BUILTIN_VARIABLES_STUBS_FILE_PATH = PuppetLibraryUtil.PUPPET_STUBS_ROOT_PATH + "builtin_variables.pp";
    private static final Key<Boolean> PUPPET_BUILTIN_VARIABLES_STUBS_FILE_KEY = Key.create((String)"it's a puppet builtin variables stubs file");

    public PuppetPsiFileImpl(FileViewProvider provider) {
        this(provider, PuppetLanguage.INSTANCE);
    }

    protected PuppetPsiFileImpl(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(1);
        }
        super(viewProvider, language);
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile != null) {
            String fileName = virtualFile.getName();
            if (FileUtil.namesEqual((String)fileName, (String)PUPPET_BUILTIN_STUBS_FILE_NAME) && FileUtil.pathsEqual((String)virtualFile.getPath(), (String)PUPPET_BUILTIN_STUBS_FILE_PATH)) {
                this.putUserData(PUPPET_BUILTIN_STUBS_FILE_KEY, true);
            }
            if (FileUtil.namesEqual((String)fileName, (String)PUPPET_BUILTIN_VARIABLES_STUBS_FILE_NAME) && FileUtil.pathsEqual((String)virtualFile.getPath(), (String)PUPPET_BUILTIN_VARIABLES_STUBS_FILE_PATH)) {
                this.putUserData(PUPPET_BUILTIN_VARIABLES_STUBS_FILE_KEY, true);
            }
        }
    }

    @NotNull
    public FileType getFileType() {
        PuppetFileType puppetFileType = PuppetFileType.INSTANCE;
        if (puppetFileType == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(2);
        }
        return puppetFileType;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, @Nullable PsiElement lastChildElement, @NotNull PsiElement originElement) {
        boolean childrenProcessingResult;
        if (processor == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(3);
        }
        if (resolveState == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(4);
        }
        if (originElement == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(5);
        }
        if (lastChildElement instanceof PuppetNodeDefinition) {
            lastChildElement = null;
        }
        if ((childrenProcessingResult = PuppetResolveUtil.processChildren(this, processor, resolveState, lastChildElement, originElement)) && processor instanceof PuppetVariableScopeProcessor) {
            ((PuppetVariableScopeProcessor)processor).processFile((PsiFile)this);
        }
        return childrenProcessingResult;
    }

    public static boolean isInBuiltInStubsFile(@NotNull PsiElement element) {
        if (element == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(6);
        }
        return PUPPET_BUILTIN_STUBS_FILE_KEY.get((UserDataHolder)element.getContainingFile()) != null;
    }

    public static boolean isInBuiltinVariablesStubsFile(@NotNull PsiElement element) {
        if (element == null) {
            PuppetPsiFileImpl.$$$reportNull$$$0(7);
        }
        return PUPPET_BUILTIN_VARIABLES_STUBS_FILE_KEY.get((UserDataHolder)element.getContainingFile()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/PuppetPsiFileImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/PuppetPsiFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInBuiltInStubsFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInBuiltinVariablesStubsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

