/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http4;

import java.io.IOException;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import org.apache.commons.vfs2.provider.http4.Http4FileObject;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;

public class Http4FileContentInfoFactory
implements FileContentInfoFactory {
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        DefaultFileContentInfo defaultFileContentInfo;
        block10: {
            String contentMimeType = null;
            String contentCharset = null;
            Http4FileObject http4File = (Http4FileObject)FileObjectUtils.getAbstractFileObject(fileContent.getFile());
            try {
                HttpResponse lastHeadResponse = http4File.getLastHeadResponse();
                Header header = lastHeadResponse.getFirstHeader("Content-Type");
                if (header != null) {
                    ContentType contentType = ContentType.parse((String)header.getValue());
                    contentMimeType = contentType.getMimeType();
                    if (contentType.getCharset() != null) {
                        contentCharset = contentType.getCharset().name();
                    }
                }
                defaultFileContentInfo = new DefaultFileContentInfo(contentMimeType, contentCharset);
                if (http4File == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (http4File != null) {
                        try {
                            http4File.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            http4File.close();
        }
        return defaultFileContentInfo;
    }
}

