/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.nio.charset.MalformedInputException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u001a0\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u001aB\u0010\u0000\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a&\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u001a,\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002\u00a8\u0006\u0014"}, d2={"getDirectoryTree", "", "Ljava/nio/file/Path;", "excluded", "", "printContent", "", "printRootName", "", "dir", "indent", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sortedFileList", "", "printFile", "file", "appendIndentString", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nFileTreePrinter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileTreePrinter.kt\ncom/intellij/util/io/FileTreePrinterKt\n+ 2 path.kt\ncom/intellij/util/io/PathKt\n*L\n1#1,71:1\n152#2,6:72\n*S KotlinDebug\n*F\n+ 1 FileTreePrinter.kt\ncom/intellij/util/io/FileTreePrinterKt\n*L\n39#1:72,6\n*E\n"})
public final class FileTreePrinterKt {
    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent, boolean printRootName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTree, (String)"<this>");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        StringBuilder sb = new StringBuilder();
        FileTreePrinterKt.getDirectoryTree($this$getDirectoryTree, 0, sb, excluded, printContent, printRootName);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String getDirectoryTree$default(Path path, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return FileTreePrinterKt.getDirectoryTree(path, set, bl, bl2);
    }

    private static final void getDirectoryTree(Path dir, int indent, StringBuilder sb, Set<String> excluded, boolean printContent, boolean printRootName) {
        List list = UtilKt.nullize(FileTreePrinterKt.sortedFileList(dir, excluded));
        if (list == null) {
            return;
        }
        List fileList = list;
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        if (printRootName) {
            sb.append(((Object)dir.getFileName()).toString());
        }
        sb.append("/");
        sb.append("\n");
        for (Path file : fileList) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileTreePrinterKt.getDirectoryTree(file, indent + 1, sb, excluded, printContent, printRootName);
                continue;
            }
            FileTreePrinterKt.printFile(file, indent + 1, sb, printContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Path> sortedFileList(Path dir, Set<String> excluded) {
        Object object;
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            List list;
            object = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream stream = (DirectoryStream)object;
                boolean bl = false;
                Sequence sequence = CollectionsKt.asSequence((Iterable)stream);
                if (!((Collection)excluded).isEmpty()) {
                    sequence = SequencesKt.filter((Sequence)sequence, arg_0 -> FileTreePrinterKt.sortedFileList$lambda$1$lambda$0(excluded, arg_0));
                }
                List list2 = SequencesKt.toMutableList((Sequence)sequence);
                CollectionsKt.sort((List)list2);
                list = list2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = list;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = null;
        }
        return object;
    }

    private static final void printFile(Path file, int indent, StringBuilder sb, boolean printContent) {
        FileTreePrinterKt.appendIndentString(indent, sb);
        if (printContent) {
            sb.append("\u251c\u2500\u2500");
        }
        String fileName = ((Object)file.getFileName()).toString();
        sb.append(fileName);
        sb.append("\n");
        if (printContent && !StringsKt.endsWith$default((String)fileName, (String)".zip", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)fileName, (String)".class", (boolean)false, (int)2, null)) {
            try {
                sb.append(PathKt.readChars((Path)file)).append("\n\n");
            }
            catch (MalformedInputException malformedInputException) {
                // empty catch block
            }
        }
    }

    private static final void appendIndentString(int indent, StringBuilder sb) {
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded, boolean printContent) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTree, (String)"<this>");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, printContent, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree, @NotNull Set<String> excluded) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTree, (String)"<this>");
        Intrinsics.checkNotNullParameter(excluded, (String)"excluded");
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, excluded, false, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getDirectoryTree(@NotNull Path $this$getDirectoryTree) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectoryTree, (String)"<this>");
        return FileTreePrinterKt.getDirectoryTree$default($this$getDirectoryTree, null, false, false, 7, null);
    }

    private static final boolean sortedFileList$lambda$1$lambda$0(Set $excluded, Path it) {
        return !$excluded.contains(((Object)it.getFileName()).toString());
    }
}

