//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************

#ifndef G4VTKPOLYDATAPOLYLINE2DPIPELINE_HH
#define G4VTKPOLYDATAPOLYLINE2DPIPELINE_HH

#include "G4VtkPolydataPipeline.hh"

class G4String;
class G4VtkVisContext;
class G4VisAttributes;
class G4Polyline;

class vtkPolyDataMapper2D;
class vtkActor2D;

class G4VtkPolydataPolyline2DPipeline : public G4VtkPolydataPipeline
{
  public:
    G4VtkPolydataPolyline2DPipeline(G4String name, const G4VtkVisContext& vc,
                                    const G4VisAttributes* pVA);
    ~G4VtkPolydataPolyline2DPipeline() override = default;

    void Modified() override;
    using G4VtkPolydataPipeline::SetPolydata;
    void SetPolydata(const G4Polyline& polyline) override;

    vtkSmartPointer<vtkActor2D> GetActor2D() { return actor2D; }

    void Clear() override;

    static std::size_t MakeHash(const G4VisAttributes* va);

  protected:
    vtkSmartPointer<vtkPolyDataMapper2D> mapper2D;
    vtkSmartPointer<vtkActor2D> actor2D;
};

#endif
