import asyncio

from grpclib.client import Channel

# generated by protoc
from .helloworld_pb2 import HelloRequest
from .helloworld_grpc import GreeterStub


async def main() -> None:
    async with Channel('127.0.0.1', 50051) as channel:
        greeter = GreeterStub(channel)

        reply = await greeter.SayHello(HelloRequest(name='Dr. Strange'))
        print(reply.message)


if __name__ == '__main__':
    asyncio.run(main())
