//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstokenfielddelegate?language=objc)
    #[cfg(all(feature = "NSControl", feature = "NSTextField"))]
    pub unsafe trait NSTokenFieldDelegate: NSTextFieldDelegate + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Allows the delegate to provide an array of appropriate completions for the contents of the receiver
        ///
        /// Parameter `tokenField`: The token field where editing is occurring
        ///
        /// Parameter `substring`: The partial string that is being completed
        ///
        /// Parameter `tokenIndex`: The index of the token being completed
        ///
        /// Parameter `selectedIndex`: Optionally, you can return by reference an index into the returned array that specifies which of the completions should be initially selected. If none are to be selected, return by reference `-1`.
        ///
        /// Returns: An array of strings (`NSString`) that are possible completions, or `nil` to provide no completions
        ///
        /// If the delegate does not implement this method, no completions are provided
        ///
        /// # Safety
        ///
        /// `selected_index` must be a valid pointer or null.
        #[optional]
        #[unsafe(method(tokenField:completionsForSubstring:indexOfToken:indexOfSelectedItem:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_completionsForSubstring_indexOfToken_indexOfSelectedItem(
            &self,
            token_field: &NSTokenField,
            substring: &NSString,
            token_index: NSInteger,
            selected_index: *mut NSInteger,
        ) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `tokens` generic should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:shouldAddObjects:atIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_shouldAddObjects_atIndex(
            &self,
            token_field: &NSTokenField,
            tokens: &NSArray,
            index: NSUInteger,
        ) -> Retained<NSArray>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:displayStringForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_displayStringForRepresentedObject(
            &self,
            token_field: &NSTokenField,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:editingStringForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_editingStringForRepresentedObject(
            &self,
            token_field: &NSTokenField,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tokenField:representedObjectForEditingString:))]
        #[unsafe(method_family = none)]
        fn tokenField_representedObjectForEditingString(
            &self,
            token_field: &NSTokenField,
            editing_string: &NSString,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `objects` generic should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:writeRepresentedObjects:toPasteboard:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_writeRepresentedObjects_toPasteboard(
            &self,
            token_field: &NSTokenField,
            objects: &NSArray,
            pboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(tokenField:readFromPasteboard:))]
        #[unsafe(method_family = none)]
        fn tokenField_readFromPasteboard(
            &self,
            token_field: &NSTokenField,
            pboard: &NSPasteboard,
        ) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSMenu", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:menuForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_menuForRepresentedObject(
            &self,
            token_field: &NSTokenField,
            represented_object: &AnyObject,
        ) -> Option<Retained<NSMenu>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:hasMenuForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_hasMenuForRepresentedObject(
            &self,
            token_field: &NSTokenField,
            represented_object: &AnyObject,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSTokenFieldCell",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `represented_object` should be of the correct type.
        #[optional]
        #[unsafe(method(tokenField:styleForRepresentedObject:))]
        #[unsafe(method_family = none)]
        unsafe fn tokenField_styleForRepresentedObject(
            &self,
            token_field: &NSTokenField,
            represented_object: &AnyObject,
        ) -> NSTokenStyle;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstokenfield?language=objc)
    #[unsafe(super(NSTextField, NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(
        feature = "NSControl",
        feature = "NSResponder",
        feature = "NSTextField",
        feature = "NSView"
    ))]
    pub struct NSTokenField;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSTokenField {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSTokenField {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityNavigableStaticText for NSTokenField {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityStaticText for NSTokenField {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSTokenField {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSCoding for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextContent",
    feature = "NSTextField",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSTextContent for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSTokenField {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
impl NSTokenField {
    extern_methods!(
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSTokenFieldDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSTokenFieldDelegate>>,
        );

        #[cfg(feature = "NSTokenFieldCell")]
        #[unsafe(method(tokenStyle))]
        #[unsafe(method_family = none)]
        pub fn tokenStyle(&self) -> NSTokenStyle;

        #[cfg(feature = "NSTokenFieldCell")]
        /// Setter for [`tokenStyle`][Self::tokenStyle].
        #[unsafe(method(setTokenStyle:))]
        #[unsafe(method_family = none)]
        pub fn setTokenStyle(&self, token_style: NSTokenStyle);

        #[unsafe(method(completionDelay))]
        #[unsafe(method_family = none)]
        pub fn completionDelay(&self) -> NSTimeInterval;

        /// Setter for [`completionDelay`][Self::completionDelay].
        #[unsafe(method(setCompletionDelay:))]
        #[unsafe(method_family = none)]
        pub fn setCompletionDelay(&self, completion_delay: NSTimeInterval);

        #[unsafe(method(defaultCompletionDelay))]
        #[unsafe(method_family = none)]
        pub fn defaultCompletionDelay(mtm: MainThreadMarker) -> NSTimeInterval;

        #[unsafe(method(tokenizingCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn tokenizingCharacterSet(&self) -> Retained<NSCharacterSet>;

        /// Setter for [`tokenizingCharacterSet`][Self::tokenizingCharacterSet].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTokenizingCharacterSet:))]
        #[unsafe(method_family = none)]
        pub fn setTokenizingCharacterSet(&self, tokenizing_character_set: Option<&NSCharacterSet>);

        #[unsafe(method(defaultTokenizingCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn defaultTokenizingCharacterSet(mtm: MainThreadMarker) -> Retained<NSCharacterSet>;
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
impl NSTokenField {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
impl NSTokenField {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSTextField",
    feature = "NSView"
))]
impl NSTokenField {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
